/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.BooleanLiteral;
import AST.CharacterLiteral;
import AST.CodeGeneration;
import AST.Constant;
import AST.DoubleLiteral;
import AST.Expr;
import AST.FloatingPointLiteral;
import AST.IntegerLiteral;
import AST.LongLiteral;
import AST.NullLiteral;
import AST.ObjectLiteral;
import AST.ParameterDeclaration;
import AST.PrimaryExpr;
import AST.StringLiteral;
import beaver.Symbol;
import java.lang.reflect.Method;
import java.util.Map;
import jpe.Environment;
import jpe.error.UnInlinableException;

public abstract class Literal
extends PrimaryExpr
implements Cloneable {
    public boolean isCompileTimed = false;
    protected String tokenString_LITERAL;
    public int LITERALstart;
    public int LITERALend;
    protected boolean constant_computed = false;
    protected Constant constant_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.constant_computed = false;
        this.constant_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public Literal clone() throws CloneNotSupportedException {
        Literal node = (Literal)super.clone();
        node.constant_computed = false;
        node.constant_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    static long parseLong(String s) {
        long x = 0L;
        s = s.toLowerCase();
        boolean neg = false;
        if (s.startsWith("-")) {
            s = s.substring(1);
            neg = true;
        }
        if (s.startsWith("0x")) {
            int i;
            if ((s = s.substring(2)).length() > 16) {
                i = 0;
                while (i < s.length() - 16) {
                    if (s.charAt(i) != '0') {
                        throw new NumberFormatException("");
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < s.length()) {
                int c = s.charAt(i);
                if (c >= 97 && c <= 102) {
                    c = c - 97 + 10;
                } else if (c >= 48 && c <= 57) {
                    c -= 48;
                } else {
                    throw new NumberFormatException("");
                }
                x = x * 16L + (long)c;
                ++i;
            }
        } else if (s.startsWith("0")) {
            int i;
            if ((s = s.substring(1)).length() > 21) {
                i = 0;
                while (i < s.length() - 21) {
                    if (i == s.length() - 21 - 1 ? s.charAt(i) != '0' && s.charAt(i) != '1' : s.charAt(i) != '0') {
                        throw new NumberFormatException("");
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < s.length()) {
                int c = s.charAt(i);
                if (c < 48 || c > 55) {
                    throw new NumberFormatException("");
                }
                x = x * 8L + (long)(c -= 48);
                ++i;
            }
        } else {
            long oldx = 0L;
            int i = 0;
            while (i < s.length()) {
                int c = s.charAt(i);
                if (c < 48 || c > 57) {
                    throw new NumberFormatException("");
                }
                x = x * 10L + (long)(c -= 48);
                if (x < oldx) {
                    boolean negMinValue;
                    boolean bl = negMinValue = i == s.length() - 1 && neg && x == Long.MIN_VALUE;
                    if (!negMinValue) {
                        throw new NumberFormatException("");
                    }
                }
                oldx = x;
                ++i;
            }
            if (x == Long.MIN_VALUE) {
                return x;
            }
            if (x < 0L) {
                throw new NumberFormatException("");
            }
        }
        return neg ? -x : x;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.getLITERAL());
    }

    protected static String escape(String s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case '\b': {
                    result.append("\\b");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\f': {
                    result.append("\\f");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\"': {
                    result.append("\\\"");
                    break;
                }
                case '\'': {
                    result.append("\\'");
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                default: {
                    char value = s.charAt(i);
                    if (value < ' ' || value > '~') {
                        result.append(Literal.asEscape(value));
                        break;
                    }
                    result.append(s.charAt(i));
                }
            }
            ++i;
        }
        return result.toString();
    }

    protected static String asEscape(int value) {
        StringBuffer s = new StringBuffer("\\u");
        String hex = Integer.toHexString(value);
        int i = 0;
        while (i < 4 - hex.length()) {
            s.append("0");
            ++i;
        }
        s.append(hex);
        return s.toString();
    }

    public void emitPushConstant(CodeGeneration gen) {
        System.out.println("ERROR: Tried to generate bytecode for: " + this.getClass().getName());
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        this.emitPushConstant(gen);
    }

    public static Literal buildLiteral(Object o) {
        if (o == null) {
            return new NullLiteral("null");
        }
        Class<?> clazz = o.getClass();
        if (clazz.equals(String.class)) {
            return new StringLiteral((String)o);
        }
        if (clazz.equals(Integer.class)) {
            return new IntegerLiteral(((Integer)o).toString());
        }
        if (clazz.equals(Double.class)) {
            return new DoubleLiteral(((Double)o).toString());
        }
        if (clazz.equals(Float.class)) {
            return new FloatingPointLiteral(((Float)o).toString());
        }
        if (clazz.equals(Character.class)) {
            return new CharacterLiteral(((Character)o).toString());
        }
        if (clazz.equals(Long.class)) {
            return new LongLiteral(((Long)o).toString());
        }
        if (clazz.equals(Short.class)) {
            return new IntegerLiteral(((Short)o).toString());
        }
        if (clazz.equals(Byte.class)) {
            return new IntegerLiteral(((Byte)o).toString());
        }
        if (clazz.equals(Boolean.class)) {
            return new BooleanLiteral(((Boolean)o).toString());
        }
        if (clazz.equals(ObjectLiteral.class)) {
            return (Literal)o;
        }
        if (Object.class.isInstance(o)) {
            ObjectLiteral ol = new ObjectLiteral();
            ol.setObject(o);
            return ol;
        }
        throw new Error("Unknown literal: " + o);
    }

    @Override
    public Expr inline(Map<ParameterDeclaration, Expr> paramVarMap) throws UnInlinableException {
        return this;
    }

    public Method hasMethod(Class<?> c, String methodName, Class<?>[] paramTypes) {
        try {
            Method m = c.getDeclaredMethod(methodName, paramTypes);
            return m;
        }
        catch (NoSuchMethodException e) {
            Class<?> sc = c.getSuperclass();
            if (sc != null) {
                return this.hasMethod(sc, methodName, paramTypes);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean equals(Literal that) {
        Object x = this.literalValueObject();
        return x == null ? that.literalValueObject() == null : x.equals(that.literalValueObject());
    }

    @Override
    public boolean canRemove(Map<String, Boolean> usedVars) {
        return true;
    }

    public Literal() {
    }

    public Literal(String p0) {
        this.setLITERAL(p0);
    }

    public Literal(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    public void setLITERAL(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol.value;
        this.LITERALstart = symbol.getStart();
        this.LITERALend = symbol.getEnd();
    }

    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    public abstract Class<?> literalValueClass();

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        throw new UnsupportedOperationException("ConstantExpression operation constant not supported for type " + this.getClass().getName());
    }

    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        boolean isConstant_value = this.isConstant_compute();
        return isConstant_value;
    }

    private boolean isConstant_compute() {
        return true;
    }

    @Override
    public String dumpString() {
        ASTNode$State state = this.state();
        String dumpString_value = this.dumpString_compute();
        return dumpString_value;
    }

    private String dumpString_compute() {
        return String.valueOf(this.getClass().getName()) + " [" + this.getLITERAL() + "]";
    }

    public boolean isCompileTimed() {
        ASTNode$State state = this.state();
        boolean isCompileTimed_value = this.isCompileTimed_compute();
        return isCompileTimed_value;
    }

    private boolean isCompileTimed_compute() {
        return this.isCompileTimed;
    }

    @Override
    public boolean isCompileTime(Environment env) {
        ASTNode$State state = this.state();
        boolean isCompileTime_jpe_Environment_value = this.isCompileTime_compute(env);
        return isCompileTime_jpe_Environment_value;
    }

    private boolean isCompileTime_compute(Environment env) {
        return false;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

