/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.CodeGeneration;
import AST.Constant;
import AST.Expr;
import AST.IntegerLiteral;
import AST.LongLiteral;
import AST.TypeDecl;
import AST.Unary;

public class MinusExpr
extends Unary
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public MinusExpr clone() throws CloneNotSupportedException {
        MinusExpr node = (MinusExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public MinusExpr copy() {
        try {
            MinusExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public MinusExpr fullCopy() {
        MinusExpr res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void typeCheck() {
        if (!this.getOperand().type().isNumericType()) {
            this.error("unary minus only operates on numeric types");
        }
    }

    @Override
    void emitOperation(CodeGeneration gen) {
        this.type().neg(gen);
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        this.boxingGen(gen);
    }

    public MinusExpr() {
    }

    public MinusExpr(Expr p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    @Override
    public void setOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        Constant constant_value = this.constant_compute();
        return constant_value;
    }

    private Constant constant_compute() {
        return this.type().minus(this.getOperand().constant());
    }

    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        boolean isConstant_value = this.isConstant_compute();
        return isConstant_value;
    }

    private boolean isConstant_compute() {
        return this.getOperand().isConstant();
    }

    @Override
    public String printPreOp() {
        ASTNode$State state = this.state();
        String printPreOp_value = this.printPreOp_compute();
        return printPreOp_value;
    }

    private String printPreOp_compute() {
        return "-";
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getOperand().type().unaryNumericPromotion();
    }

    @Override
    public ASTNode rewriteTo() {
        if (this.getOperand() instanceof IntegerLiteral && ((IntegerLiteral)this.getOperand()).isDecimal() && this.getOperand().isPositive()) {
            ++this.state().duringConstantExpression;
            IntegerLiteral result = this.rewriteRule0();
            --this.state().duringConstantExpression;
            return result;
        }
        if (this.getOperand() instanceof LongLiteral && ((LongLiteral)this.getOperand()).isDecimal() && this.getOperand().isPositive()) {
            ++this.state().duringConstantExpression;
            LongLiteral result = this.rewriteRule1();
            --this.state().duringConstantExpression;
            return result;
        }
        return super.rewriteTo();
    }

    private IntegerLiteral rewriteRule0() {
        return new IntegerLiteral("-" + ((IntegerLiteral)this.getOperand()).getLITERAL());
    }

    private LongLiteral rewriteRule1() {
        return new LongLiteral("-" + ((LongLiteral)this.getOperand()).getLITERAL());
    }
}

