/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.AbstractObject;
import AST.Constant;
import AST.ConstructorDecl;
import AST.Dot;
import AST.Expr;
import AST.List;
import AST.Literal;
import AST.MethodAccess;
import AST.TypeAccess;
import AST.TypeDecl;
import AST.VarAccess;
import AST.Variable;
import beaver.Symbol;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import jpe.Environment;
import jpe.Util;

public class ObjectLiteral
extends Literal
implements Cloneable,
AbstractObject {
    protected Object object;
    protected TypeDecl typeDecl;
    protected Variable variable;
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
        this.constant_computed = false;
        this.constant_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ObjectLiteral clone() throws CloneNotSupportedException {
        ObjectLiteral node = (ObjectLiteral)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.constant_computed = false;
        node.constant_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ObjectLiteral copy() {
        try {
            ObjectLiteral node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ObjectLiteral fullCopy() {
        ObjectLiteral res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public boolean hasVarAccess() {
        return this.variable != null;
    }

    public Expr getVarAccess() {
        Util.assertTrue(this.variable != null, this.sourceFile(), this.lineNumber(), "VarAccess for ObjectLiteral is null!");
        if (this.variable.isStatic()) {
            return new Dot(new TypeAccess(this.variable.hostType().typeName()), new VarAccess(this.variable.name()));
        }
        return new VarAccess(this.variable.name());
    }

    public ObjectLiteral(Object object, TypeDecl typeDecl) {
        this.object = object;
        this.typeDecl = typeDecl;
    }

    public ObjectLiteral(TypeDecl typeDecl) {
        this.typeDecl = typeDecl;
    }

    public ObjectLiteral(Object object, TypeDecl typeDecl, Variable v) {
        this.object = object;
        this.typeDecl = typeDecl;
        this.variable = v;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(Literal.buildLiteral(this.object).toString());
    }

    public TypeDecl getTypeDecl() {
        return this.typeDecl;
    }

    public void setTypeDecl(TypeDecl typeDecl) {
        this.typeDecl = typeDecl;
    }

    @Override
    public String toString() {
        Util.assertTrue(false, this.sourceFile(), this.lineNumber(), "ObjectLiteral.toString(): We should not be here!");
        return "";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectLiteral)) {
            return false;
        }
        ObjectLiteral other = (ObjectLiteral)obj;
        return !(this.object == null ? other.object != null : !this.object.equals(other.object));
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Constructor<?> hasConstructor(Class<?> c, Class<?>[] parameterTypes) {
        block3: {
            try {
                Constructor<?> cons = c.getDeclaredConstructor(parameterTypes);
                return cons;
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                Class<?> sc = c.getSuperclass();
                if (sc == null) break block3;
                return this.hasConstructor(sc, parameterTypes);
            }
        }
        return null;
    }

    public void createObject(ConstructorDecl cdecl, List<Expr> peArgs) {
        String qClassName = String.valueOf(this.typeDecl.packageName()) + "." + this.typeDecl.name();
        try {
            Class<?> clazz = Util.getClassForType(qClassName);
            Class<?>[] parameterTypes = Util.getParameterTypes(cdecl);
            Object[] parameters = Util.getParameters(peArgs, parameterTypes);
            Constructor<?> constructor = this.hasConstructor(clazz, parameterTypes);
            constructor.setAccessible(true);
            Object o = constructor.newInstance(parameters);
            this.setObject(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Could not create object literal " + cdecl + ":" + peArgs);
        }
    }

    @Override
    public Expr getFieldValue(String fieldName) {
        Field f;
        block7: {
            assert (this.object != null);
            String type = String.valueOf(this.type().packageName()) + "." + this.type().name();
            Class<?> c = Util.getClassForType(type);
            f = this.hasField(c, fieldName);
            if (f != null) break block7;
            if (c.isArray() && fieldName == "length") {
                int len = Array.getLength(this.object);
                return Literal.buildLiteral(len);
            }
            return null;
        }
        try {
            f.setAccessible(true);
            Object val = f.get(this.object);
            return ObjectLiteral.makeObjectLiteral(val, null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        throw new Error("Could not find field " + fieldName + " in object " + this.toString());
    }

    public static Literal makeObjectLiteral(Object val, MethodAccess ma) {
        Literal retLiteral = Literal.buildLiteral(val);
        if (retLiteral instanceof ObjectLiteral) {
            TypeDecl td = Util.lookupType(val.getClass());
            if (td == null && ma != null) {
                td = ma.type();
            }
            ((ObjectLiteral)retLiteral).setTypeDecl(td);
        }
        return retLiteral;
    }

    public Expr getArrayItem(int i) {
        assert (this.object != null);
        try {
            Object val = Array.get(this.object, i);
            return ObjectLiteral.makeObjectLiteral(val, null);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new Error("Could not find array index " + this.toString());
        }
    }

    @Override
    public Expr getFieldValue(Variable v) {
        ObjectLiteral o;
        Expr e = this.getFieldValue(v.name());
        if (e instanceof ObjectLiteral && (o = (ObjectLiteral)e).getTypeDecl() == null) {
            o.setTypeDecl(v.type());
        }
        return e;
    }

    @Override
    public void setFieldValue(Variable v, Expr exp) {
        if (!(exp instanceof Literal)) {
            throw new Error("Unable to assign a non-literal " + exp + " to object " + this.object);
        }
        Object val = ((Literal)exp).literalValueObject();
        String fieldName = v.name();
        assert (this.object != null);
        String type = String.valueOf(this.type().packageName()) + "." + this.type().name();
        try {
            Class<?> c = Util.getClassForType(type);
            Field f = c.getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(this.object, val);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Could not find field " + fieldName + " in object " + this.toString());
        }
    }

    public Field hasField(Class<?> c, String fieldName) {
        try {
            Field f = c.getDeclaredField(fieldName);
            return f;
        }
        catch (NoSuchFieldException e) {
            Class<?> sc = c.getSuperclass();
            if (sc != null) {
                return this.hasField(sc, fieldName);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean hasField(Variable v) {
        String fieldName = v.name();
        assert (this.object != null);
        String type = String.valueOf(this.type().packageName()) + "." + this.type().name();
        Class<?> c = null;
        try {
            c = Util.getClassForType(type);
            return this.hasField(c, fieldName) != null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void addUsedVars(Map<String, Boolean> usedVars) {
    }

    public ObjectLiteral() {
    }

    public ObjectLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public ObjectLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    @Override
    public void setLITERAL(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol.value;
        this.LITERALstart = symbol.getStart();
        this.LITERALend = symbol.getEnd();
    }

    @Override
    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    @Override
    public Object literalValueObject() {
        ASTNode$State state = this.state();
        Object literalValueObject_value = this.literalValueObject_compute();
        return literalValueObject_value;
    }

    private Object literalValueObject_compute() {
        return this.getObject();
    }

    @Override
    public Class<?> literalValueClass() {
        ASTNode$State state = this.state();
        Class<?> literalValueClass_value = this.literalValueClass_compute();
        return literalValueClass_value;
    }

    private Class<?> literalValueClass_compute() {
        return this.getObject().getClass();
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeObject();
    }

    public TypeDecl typeObject() {
        ASTNode$State state = this.state();
        TypeDecl typeObject_value = this.typeObject_compute();
        return typeObject_value;
    }

    private TypeDecl typeObject_compute() {
        return this.typeDecl;
    }

    @Override
    public Literal invoke(Environment env, MethodAccess ma, List<Expr> actualParams) {
        ASTNode$State state = this.state();
        Literal invoke_jpe_Environment_MethodAccess_List_Expr__value = this.invoke_compute(env, ma, actualParams);
        return invoke_jpe_Environment_MethodAccess_List_Expr__value;
    }

    private Literal invoke_compute(Environment env, MethodAccess ma, List<Expr> actualParams) {
        try {
            Class<?>[] parameterTypes = Util.getParameterTypes(ma.decl());
            Class<?> clz = this.object.getClass();
            Method m = this.hasMethod(clz, ma.name(), parameterTypes);
            m.setAccessible(true);
            Object[] parameters = Util.getParameters(actualParams, parameterTypes);
            Object val = m.invoke(this.object, parameters);
            return ObjectLiteral.makeObjectLiteral(val, ma);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Invocation problem", e);
        }
        return null;
    }

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        if (this.object instanceof Double) {
            return Constant.create((Double)this.object);
        }
        throw new UnsupportedOperationException("ConstantExpression operation constant not supported for Object type " + this.object.getClass().getName());
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

