/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp;

import beaver.comp.Configuration;
import beaver.comp.State;
import beaver.comp.util.BitSet;
import beaver.comp.util.Log;
import beaver.spec.Grammar;
import beaver.spec.GrammarSymbol;
import beaver.spec.NonTerminal;
import beaver.spec.Production;
import beaver.spec.Terminal;
import java.util.Arrays;
import java.util.Comparator;

class Action {
    static final Comparator LOOKAHEAD_ID_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((Action)object).lookahead.id - ((Action)object2).lookahead.id;
        }
    };
    Action next;
    Type type;
    GrammarSymbol lookahead;

    Action(Type type, GrammarSymbol grammarSymbol) {
        this.type = type;
        this.lookahead = grammarSymbol;
    }

    short getId() {
        return 0;
    }

    boolean resolveConflict(Action action, State state) {
        throw new IllegalStateException("only shift-reduce or reduce-reduce conflicts are expected");
    }

    public String toString() {
        return this.lookahead + ":\t" + this.type;
    }

    static class List {
        static final Comparator NUM_ACTIONS_CMP = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((List)object2).num_actions - ((List)object).num_actions;
            }
        };
        State state;
        Action first;
        Action last;
        int num_actions;

        List(State state) {
            this.state = state;
        }

        void add(Action action) {
            this.last = this.last == null ? (this.first = action) : (this.last.next = action);
            ++this.num_actions;
        }

        int resolveConflicts() {
            int n = 0;
            if (this.first != null && this.num_actions > 1) {
                Action action = this.first;
                while (action != this.last) {
                    if (!action.type.isResolved()) {
                        Action action2 = action.next;
                        while (action2 != null) {
                            if (action2.lookahead == action.lookahead && !action.resolveConflict(action2, this.state)) {
                                ++n;
                            }
                            action2 = action2.next;
                        }
                    }
                    action = action.next;
                }
                this.removeResolvedActions();
            }
            return n;
        }

        void reportConflicts(Log log) {
            if (this.first != null && this.num_actions > 1) {
                Action action = this.first;
                while (action != null) {
                    if (action.type instanceof Type.Conflict) {
                        log.error(action.type.toString());
                    }
                    action = action.next;
                }
            }
        }

        private void removeResolvedActions() {
            while (this.first != null && this.first.type.isRemovable()) {
                this.first = this.first.next;
                --this.num_actions;
            }
            this.last = this.first;
            Action action = this.first.next;
            while (action != null) {
                if (action.type.isRemovable()) {
                    --this.num_actions;
                } else {
                    this.last = this.last.next = action;
                }
                action = action.next;
            }
            this.last.next = null;
        }

        void markReducibleProductions() {
            Action action = this.first;
            while (action != null) {
                if (action.type == Type.REDUCE) {
                    ((Reduce)action).rule.is_reducible = true;
                }
                action = action.next;
            }
        }

        void compress() {
            Production production = null;
            int n = 0;
            Action action = this.first;
            while (action != null) {
                Production production2;
                if (action.type == Type.REDUCE && (production2 = ((Reduce)action).rule) != production) {
                    int n2 = 1;
                    Action action2 = action.next;
                    while (action2 != null) {
                        if (action2.type == Type.REDUCE && ((Reduce)action2).rule == production2) {
                            ++n2;
                        }
                        action2 = action2.next;
                    }
                    if (n2 > n) {
                        production = production2;
                        n = n2;
                    }
                }
                action = action.next;
            }
            if (n > 1) {
                action = this.first;
                while (action.type != Type.REDUCE || ((Reduce)action).rule != production) {
                    action = action.next;
                }
                action.lookahead = null;
                action = action.next;
                while (action != null) {
                    if (action.type == Type.REDUCE && ((Reduce)action).rule == production) {
                        action.type = Type.NOT_USED;
                    }
                    action = action.next;
                }
            }
        }

        Action split(List list, List list2) {
            Action action = null;
            Action action2 = null;
            Action action3 = null;
            this.num_actions = 0;
            Action action4 = this.first;
            while (action4 != null) {
                if (action4.type.isRemovable()) {
                    action3 = action3 == null ? (action2 = action4) : (action3.next = action4);
                    ++this.num_actions;
                } else if (action4.lookahead instanceof NonTerminal) {
                    list2.add(action4);
                } else if (action4.lookahead instanceof Terminal) {
                    list.add(action4);
                } else {
                    if (action != null) {
                        throw new IllegalStateException("multiple default actions in state " + this.state.id + " actions list");
                    }
                    action = action4;
                }
                action4 = action4.next;
            }
            this.first = action2;
            this.last = action3;
            if (action3 != null) {
                action3.next = null;
            }
            if (action != null) {
                action.next = null;
            }
            if (list.last != null) {
                list.last.next = null;
            }
            if (list2.last != null) {
                list2.last.next = null;
            }
            list.sort();
            list2.sort();
            return action;
        }

        void sort() {
            if (this.num_actions > 1) {
                Action[] actionArray = new Action[this.num_actions];
                int n = 0;
                Action action = this.first;
                while (action != null) {
                    actionArray[n++] = action;
                    action = action.next;
                }
                Arrays.sort(actionArray, LOOKAHEAD_ID_COMPARATOR);
                n = 0;
                action = this.first = actionArray[0];
                while (++n < this.num_actions) {
                    action = action.next = actionArray[n];
                }
                this.last = action;
                action.next = null;
            }
        }
    }

    static class Accept
    extends Action {
        private short id;

        Accept(Grammar grammar) {
            super(Type.ACCEPT, grammar.goal_symbol);
            this.id = (short)(~grammar.rules.length);
        }

        short getId() {
            return this.id;
        }
    }

    static class Reduce
    extends Action {
        Production rule;

        Reduce(Terminal terminal, Production production) {
            super(Type.REDUCE, terminal);
            this.rule = production;
        }

        boolean resolveConflict(Action action, State state) {
            if (!(action instanceof Reduce)) {
                throw new IllegalArgumentException("reduce-reduce expected");
            }
            Terminal terminal = this.rule.prec_sym;
            Reduce reduce = (Reduce)action;
            Terminal terminal2 = reduce.rule.prec_sym;
            if (terminal.prec > terminal2.prec) {
                action.type = Type.RESOLVED;
                return true;
            }
            if (terminal.prec < terminal2.prec) {
                this.type = Type.RESOLVED;
                return true;
            }
            action.type = new Type.Conflict.ReduceReduce(this, reduce, state, "equal precedence");
            return false;
        }

        short getId() {
            return (short)(~this.rule.id);
        }

        public String toString() {
            return this.lookahead != null ? this.lookahead + ":\t" + this.type + " " + this.rule : "[any]:\tREDUCE " + this.rule;
        }

        static class Maker
        extends BitSet.Processor {
            Terminal[] terminals;
            State state;
            Production rule;

            Maker(Terminal[] terminalArray, State state) {
                this.terminals = terminalArray;
                this.state = state;
            }

            void buildReduceActions() {
                while (this.state != null) {
                    Configuration configuration = this.state.conf_set.first_conf;
                    while (configuration != null) {
                        if (configuration.dot == configuration.rule.rhs.items.length) {
                            this.rule = configuration.rule;
                            configuration.lookaheads.forEachElementRun(this);
                        }
                        configuration = configuration.next;
                    }
                    this.state = this.state.next;
                }
            }

            protected void process(int n) {
                this.state.actions.add(new Reduce(this.terminals[n], this.rule));
            }
        }
    }

    static class Shift
    extends Action {
        State state;

        Shift(GrammarSymbol grammarSymbol, State state) {
            super(Type.SHIFT, grammarSymbol);
            this.state = state;
        }

        boolean resolveConflict(Action action, State state) {
            if (!(action instanceof Reduce)) {
                throw new IllegalArgumentException("shift-reduce expected, \"" + action + "\" found");
            }
            Reduce reduce = (Reduce)action;
            Terminal terminal = reduce.rule.prec_sym;
            if (this.lookahead instanceof NonTerminal) {
                action.type = new Type.Conflict.ShiftReduce(this, reduce, state, this.lookahead.name + " is a non-terminal");
                return false;
            }
            Terminal terminal2 = (Terminal)this.lookahead;
            if (terminal2.prec > terminal.prec) {
                action.type = Type.RESOLVED;
                return true;
            }
            if (terminal2.prec < terminal.prec) {
                this.type = Type.RESOLVED;
                return true;
            }
            if (terminal2.assoc == Terminal.Associativity.RIGHT) {
                action.type = Type.RESOLVED;
                return true;
            }
            if (terminal2.assoc == Terminal.Associativity.LEFT) {
                this.type = Type.RESOLVED;
                return true;
            }
            action.type = new Type.Conflict.ShiftReduce(this, reduce, state, terminal2.prec > 0 ? this.lookahead.name + " is nonassociative" : "insufficient precedence information");
            return false;
        }

        short getId() {
            return (short)this.state.id;
        }

        public String toString() {
            return this.lookahead + ":\t" + this.type + "; goto " + this.state.id;
        }
    }

    static class Type {
        static final Type SHIFT = new Type(1, "SHIFT");
        static final Type REDUCE = new Type(2, "REDUCE");
        static final Type ACCEPT = new Type(3, "ACCEPT");
        static final Type RESOLVED = new Type(-1, "RESOLVED");
        static final Type NOT_USED = new Type(-2, "NOT USED");
        private int id;
        private String name;

        Type(int n, String string) {
            this.id = n;
            this.name = string;
        }

        boolean isRemovable() {
            return this.id < 0;
        }

        boolean isResolved() {
            return this.id <= 0;
        }

        public String toString() {
            return this.name;
        }

        static class Conflict
        extends Type {
            private String descr;

            Conflict(String string, String string2) {
                super(0, string + " conflict");
                this.descr = string2;
            }

            public String toString() {
                return new StringBuffer(super.toString().length() + 2 + this.descr.length()).append(super.toString()).append(": ").append(this.descr).toString();
            }

            static class ReduceReduce
            extends Conflict {
                ReduceReduce(Reduce reduce, Reduce reduce2, State state, String string) {
                    super("reduce-reduce", ReduceReduce.makeDescription(reduce, reduce2, state, string));
                }

                private static String makeDescription(Reduce reduce, Reduce reduce2, State state, String string) {
                    StringBuffer stringBuffer = new StringBuffer(256).append("\n\treduce\t").append(reduce.rule);
                    int n = reduce.rule.getFirstLine();
                    if (n > 0) {
                        stringBuffer.append(" @ ").append(n);
                    }
                    stringBuffer.append("\n\tor\t").append(reduce2.rule);
                    n = reduce2.rule.getFirstLine();
                    if (n > 0) {
                        stringBuffer.append(" @ ").append(n);
                    }
                    stringBuffer.append("\n\ton ").append(reduce.lookahead.name).append(" - ").append(string);
                    return stringBuffer.toString();
                }
            }

            static class ShiftReduce
            extends Conflict {
                ShiftReduce(Shift shift, Reduce reduce, State state, String string) {
                    super("shift-reduce", ShiftReduce.makeDescription(shift, reduce, state, string));
                }

                private static String makeDescription(Shift shift, Reduce reduce, State state, String string) {
                    StringBuffer stringBuffer = new StringBuffer(256).append("\n\tshift ").append(shift.lookahead.name).append(" in:");
                    Configuration configuration = state.conf_set.first_conf;
                    while (configuration != null) {
                        if (configuration.dot < configuration.rule.rhs.items.length && configuration.rule.rhs.items[configuration.dot].symbol == shift.lookahead) {
                            stringBuffer.append("\n\t\t").append(configuration);
                        }
                        configuration = configuration.next;
                    }
                    stringBuffer.append("\n\tor reduce:\n\t\t").append(reduce.rule.toString());
                    int n = reduce.rule.getFirstLine();
                    if (n > 0) {
                        stringBuffer.append(" @ ").append(n);
                    }
                    stringBuffer.append("\n\t- ").append(string);
                    return stringBuffer.toString();
                }
            }
        }
    }
}

