/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp;

import beaver.Parser;
import beaver.comp.Action;
import beaver.comp.Configuration;
import beaver.comp.ParsingTables;
import beaver.comp.State;
import beaver.comp.io.SrcReader;
import beaver.comp.run.Options;
import beaver.comp.util.BitSet;
import beaver.comp.util.Log;
import beaver.spec.Grammar;
import beaver.spec.GrammarBuilder;
import beaver.spec.NonTerminal;
import beaver.spec.Production;
import beaver.spec.Terminal;
import beaver.spec.ast.GrammarTreeRoot;
import beaver.spec.parser.GrammarParser;
import beaver.spec.parser.GrammarScanner;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.DeflaterOutputStream;

public class ParserGenerator {
    public static final String VERSION = "0.9.4";
    public static final String SOURCE_FILE_EXT = ".java";
    public static final String SERIALIZED_PARSER_TABLES_FILE_EXT = ".spec";
    public static final String PARSER_ACTIONS_REPORT_FILE_EXT = ".stat";

    public static void compile(SrcReader srcReader, Options options, Log log) throws IOException, Parser.Exception, Grammar.Exception {
        Grammar grammar = ParserGenerator.parseGrammar(srcReader, log);
        if (!log.hasErrors()) {
            CompiledParser compiledParser = ParserGenerator.compile(grammar, options, log);
            if (!log.hasErrors()) {
                File file = srcReader.file.getParentFile();
                String string = ParserGenerator.getOutputFileName(grammar, srcReader.file);
                if (options.report_actions) {
                    compiledParser.writeActionsReport(file, string);
                    log.message("Generated: " + string + PARSER_ACTIONS_REPORT_FILE_EXT);
                }
                if (!options.no_output) {
                    compiledParser.writeParserSource(srcReader.file, string, options);
                    log.message("Generated: " + string + SOURCE_FILE_EXT);
                    if (options.export_terminals) {
                        compiledParser.writeTerminalsSource(srcReader.file, "Terminals", options);
                        log.message("Generated: Terminals.java");
                    }
                    if (options.exp_parsing_tables) {
                        compiledParser.writeParsingTables(file, string);
                        log.message("Generated: " + string + SERIALIZED_PARSER_TABLES_FILE_EXT);
                    }
                }
            }
        }
    }

    public static Grammar parseGrammar(SrcReader srcReader, Log log) throws IOException, Parser.Exception, Grammar.Exception {
        GrammarTreeRoot grammarTreeRoot = (GrammarTreeRoot)new GrammarParser(log).parse(new GrammarScanner(srcReader));
        if (log.hasErrors()) {
            throw new Grammar.Exception("cannot parse grammar");
        }
        GrammarBuilder grammarBuilder = new GrammarBuilder(log);
        grammarTreeRoot.accept(grammarBuilder);
        return grammarBuilder.getGrammar();
    }

    public static CompiledParser compile(Grammar grammar, Options options, Log log) throws Grammar.Exception {
        grammar.markNullableProductions();
        grammar.buildFirstSets();
        State state = ParserGenerator.makeStates(grammar);
        ParserGenerator.findLookaheads(state);
        ParserGenerator.buildActions(grammar, state);
        ParserGenerator.checkAndResolveConflicts(state, log);
        ParserGenerator.checkUnreducibleProductions(grammar, state, log);
        if (!options.no_compression) {
            ParserGenerator.compressActions(state);
        }
        ParserGenerator.splitActions(state);
        return new CompiledParser(grammar, new ParsingTables(grammar, state));
    }

    private static State makeStates(Grammar grammar) {
        Object object;
        Configuration.Set.Factory factory = new Configuration.Set.Factory(grammar);
        Object object2 = grammar.goal_symbol.definitions.start();
        while (object2 != null) {
            object = factory.addConfiguration((Production)object2, 0);
            ((Configuration)object).addLookahead(grammar.eof);
            object2 = ((Production)object2).next_definition;
        }
        object = object2 = new State.Factory(factory).getState(factory.getCore());
        while (object != null) {
            ((State)object).conf_set.reverseReversePropagation();
            ((State)object).conf_set.resetContributionFlags();
            object = ((State)object).next;
        }
        return object2;
    }

    private static void findLookaheads(State state) {
        boolean bl;
        do {
            bl = false;
            State state2 = state;
            while (state2 != null) {
                if (state2.findLookaheads()) {
                    bl = true;
                }
                state2 = state2.next;
            }
        } while (bl);
    }

    private static void buildActions(Grammar grammar, State state) {
        new Action.Reduce.Maker(grammar.terminals, state).buildReduceActions();
        state.actions.add(new Action.Accept(grammar));
    }

    private static void checkAndResolveConflicts(State state, Log log) throws Grammar.Exception {
        int n = 0;
        State state2 = state;
        while (state2 != null) {
            n += state2.actions.resolveConflicts();
            state2 = state2.next;
        }
        if (n > 0) {
            state2 = state;
            while (state2 != null) {
                state2.actions.reportConflicts(log);
                state2 = state2.next;
            }
            throw new Grammar.Exception("grammar has conflicts");
        }
    }

    private static void checkUnreducibleProductions(Grammar grammar, State state, Log log) throws Grammar.Exception {
        State state2 = state;
        while (state2 != null) {
            state2.actions.markReducibleProductions();
            state2 = state2.next;
        }
        boolean bl = false;
        for (int i = 0; i < grammar.rules.length; ++i) {
            Production production = grammar.rules[i];
            if (production.is_reducible) continue;
            log.error(production.start_pos, production.end_pos, "Production \"" + production.toString() + "\" can not be reduced");
            bl = true;
        }
        if (bl) {
            throw new Grammar.Exception("grammar has unreducible productions");
        }
    }

    private static void compressActions(State state) {
        State state2 = state;
        while (state2 != null) {
            state2.actions.compress();
            state2 = state2.next;
        }
    }

    private static void splitActions(State state) {
        State state2 = state;
        while (state2 != null) {
            state2.splitActions();
            state2 = state2.next;
        }
    }

    public static String getOutputFileName(Grammar grammar, File file) {
        if (grammar.class_name != null) {
            return grammar.class_name;
        }
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static class CompiledParser {
        private static final Comparator TERMINAL_NAME_CMP = new Comparator(){

            public int compare(Object object, Object object2) {
                Terminal terminal = (Terminal)object;
                Terminal terminal2 = (Terminal)object2;
                return terminal.id == 0 ? -1 : terminal.name.compareTo(terminal2.name);
            }
        };
        private static final char[] _62_or_63 = new char[]{'#', '$'};
        private Grammar grammar;
        private ParsingTables tables;
        private int[] rule_descr;

        private static int[] makeProductionDescriptors(Grammar grammar) {
            int[] nArray = new int[grammar.rules.length];
            for (int i = 0; i < grammar.rules.length; ++i) {
                Production production = grammar.rules[i];
                nArray[i] = production.lhs.id << 16 | production.rhs.items.length;
            }
            return nArray;
        }

        private static void writeTerminalsClass(Grammar grammar, Options options, String string, Writer writer) throws IOException {
            int n;
            Terminal[] terminalArray;
            writer.write(string);
            if (string.length() > 0) {
                writer.write("static ");
            }
            writer.write("public class Terminals {\n");
            if (options.sort_terminals) {
                terminalArray = new Terminal[grammar.terminals.length];
                System.arraycopy(grammar.terminals, 0, terminalArray, 0, terminalArray.length);
                Arrays.sort(terminalArray, TERMINAL_NAME_CMP);
            } else {
                terminalArray = grammar.terminals;
            }
            for (n = 0; n < terminalArray.length; ++n) {
                if (terminalArray[n].name.charAt(0) == '$') continue;
                writer.write(string);
                writer.write("\tstatic public final short ");
                writer.write(terminalArray[n].name);
                writer.write(" = ");
                writer.write(String.valueOf(terminalArray[n].id));
                writer.write(";\n");
            }
            if (options.terminal_names) {
                terminalArray = grammar.terminals;
                writer.write(10);
                writer.write(string);
                writer.write("\tstatic public final String[] NAMES = {\n");
                for (n = 0; n < terminalArray.length - 1; ++n) {
                    if (terminalArray[n].name.charAt(0) == '$') continue;
                    writer.write(string);
                    writer.write("\t\t\"");
                    writer.write(terminalArray[n].name);
                    writer.write("\",\n");
                }
                if (terminalArray.length > 0 && terminalArray[terminalArray.length - 1].name.charAt(0) != '$') {
                    writer.write(string);
                    writer.write("\t\t\"");
                    writer.write(terminalArray[terminalArray.length - 1].name);
                    writer.write("\"\n");
                }
                writer.write(string);
                writer.write("\t};\n");
            }
            writer.write(string);
            writer.write("}\n");
        }

        private static boolean writeMarkersClass(Terminal[] terminalArray, Writer writer) throws IOException {
            boolean bl = false;
            for (int i = 0; i < terminalArray.length; ++i) {
                if (terminalArray[i].name.charAt(0) != '$') continue;
                if (!bl) {
                    writer.write("\tstatic public class AltGoals {\n");
                    bl = true;
                }
                writer.write("\t\tstatic public final short ");
                writer.write(terminalArray[i].name.substring(1));
                writer.write(" = ");
                writer.write(String.valueOf(terminalArray[i].id));
                writer.write(";\n");
            }
            if (bl) {
                writer.write("\t}\n");
            }
            return bl;
        }

        private static void writeReduceActionClasses(Grammar grammar, Writer writer) throws IOException {
            for (int i = 0; i < grammar.rules.length; ++i) {
                Production production = grammar.rules[i];
                if (production.code == null) continue;
                writer.write("\n\t/**");
                writer.write("\n\t * ");
                writer.write(production.toString());
                writer.write("\n\t */");
                writer.write("\n\tfinal class Action");
                writer.write(String.valueOf(production.id));
                writer.write(" extends Action {\n");
                writer.write("\t\t\t\tpublic Symbol reduce(Symbol[] _symbols, int offset) {\n");
                CompiledParser.writeReduceActionCode(production, writer);
                writer.write("\t\t\t\t}");
                writer.write("\n\t}\n");
            }
        }

        private static void writeStaticReturns(Grammar grammar, Writer writer) throws IOException {
            BitSet bitSet = new BitSet();
            for (int i = 0; i < grammar.rules.length; ++i) {
                int n;
                Production production = grammar.rules[i];
                if (production.code != null || production.rhs.size() <= 1 || (n = CompiledParser.indexOfLastReferencedSymbol(production.rhs)) == 0) continue;
                if (n < 0) {
                    n = production.rhs.size() - 1;
                }
                if (!bitSet.add(n)) continue;
                writer.write("\n\tstatic final Action RETURN");
                writer.write(String.valueOf(n + 1));
                writer.write(" = new Action() {\n");
                writer.write("\t\tpublic Symbol reduce(Symbol[] _symbols, int offset) {\n");
                writer.write("\t\t\treturn _symbols[offset + ");
                writer.write(String.valueOf(n + 1));
                writer.write("];\n");
                writer.write("\t\t}\n");
                writer.write("\t};\n");
            }
        }

        private static int countReferencedSymbols(Production.RHS rHS) {
            int n = 0;
            for (int i = 0; i < rHS.items.length; ++i) {
                if (rHS.items[i].alias == null) continue;
                ++n;
            }
            return n;
        }

        private static int indexOfLastReferencedSymbol(Production.RHS rHS) {
            int n = rHS.size();
            while (--n >= 0 && rHS.items[n].alias == null) {
            }
            return n;
        }

        private static void writeParserActionsArray(Grammar grammar, Options options, Writer writer) throws IOException {
            int n = grammar.rules.length - 1;
            for (int i = 0; i < grammar.rules.length; ++i) {
                Production production = grammar.rules[i];
                writer.write("\n\t\t\t");
                if (production.code == null) {
                    if (production.rhs.size() == 0) {
                        writer.write("Action.NONE");
                        if (i != n) {
                            writer.write(",  ");
                        }
                        writer.write("\t// [");
                        writer.write(String.valueOf(production.id));
                        writer.write("] ");
                        writer.write(production.toString());
                        continue;
                    }
                    if (production.rhs.size() == 1) {
                        writer.write("Action.RETURN");
                        if (i != n) {
                            writer.write(44);
                        }
                        writer.write("\t// [");
                        writer.write(String.valueOf(production.id));
                        writer.write("] ");
                        writer.write(production.toString());
                        continue;
                    }
                    int n2 = CompiledParser.indexOfLastReferencedSymbol(production.rhs);
                    if (n2 == 0) {
                        writer.write("Action.RETURN");
                    } else if (n2 > 0) {
                        writer.write("RETURN");
                        writer.write(String.valueOf(n2 + 1));
                    } else {
                        writer.write("RETURN");
                        writer.write(String.valueOf(production.rhs.size()));
                    }
                    if (i != n) {
                        writer.write(44);
                    }
                    writer.write("\t// [");
                    writer.write(String.valueOf(production.id));
                    writer.write("] ");
                    writer.write(production.toString());
                    if (n2 < 0) {
                        writer.write("; returns '");
                        writer.write(production.rhs.items[production.rhs.size() - 1].symbol.name);
                        writer.write("' although none is marked");
                        continue;
                    }
                    if (CompiledParser.countReferencedSymbols(production.rhs) <= 1) continue;
                    writer.write("; returns '");
                    writer.write(production.rhs.items[n2].alias);
                    writer.write("' although more are marked");
                    continue;
                }
                writer.write("new Action");
                if (options.name_action_classes) {
                    writer.write(String.valueOf(production.id));
                    writer.write("()");
                    if (i != n) {
                        writer.write(44);
                    }
                    writer.write("\t// [");
                    writer.write(String.valueOf(production.id));
                    writer.write("] ");
                    writer.write(production.toString());
                    continue;
                }
                writer.write("() {\t// [");
                writer.write(String.valueOf(production.id));
                writer.write("] ");
                writer.write(production.toString());
                writer.write(10);
                writer.write("\t\t\t\tpublic Symbol reduce(Symbol[] _symbols, int offset) {\n");
                CompiledParser.writeReduceActionCode(production, writer);
                writer.write("\t\t\t\t}");
                writer.write("\n\t\t\t}");
                if (i == n) continue;
                writer.write(44);
            }
        }

        private static void writeParserActionsSwitch(Grammar grammar, Options options, Writer writer) throws IOException {
            int n;
            writer.write("\t\tswitch(rule_num) {\n");
            int n2 = grammar.rules.length;
            Production[] productionArray = new Production[n2];
            System.arraycopy(grammar.rules, 0, productionArray, 0, n2);
            for (n = 0; n < productionArray.length; ++n) {
                if (productionArray[n].code == null) continue;
                writer.write("\t\t\tcase ");
                writer.write(String.valueOf(productionArray[n].id));
                writer.write(": // ");
                writer.write(productionArray[n].toString());
                writer.write("\n\t\t\t{\n");
                CompiledParser.writeReduceActionCode(productionArray[n], writer);
                writer.write("\t\t\t}\n");
                productionArray[n] = null;
                --n2;
            }
            n = 0;
            while (n2 > 0) {
                int n3 = 0;
                for (int i = 0; i < productionArray.length; ++i) {
                    if (productionArray[i] == null) continue;
                    int n4 = CompiledParser.indexOfLastReferencedSymbol(productionArray[i].rhs) + 1;
                    if (n4 == 0) {
                        n4 = productionArray[i].rhs.size();
                    }
                    if (n4 != n) continue;
                    writer.write("\t\t\tcase ");
                    writer.write(String.valueOf(productionArray[i].id));
                    writer.write(": // ");
                    writer.write(productionArray[i].toString());
                    writer.write("\n");
                    productionArray[i] = null;
                    --n2;
                    ++n3;
                }
                if (n3 > 0) {
                    writer.write("\t\t\t{\n");
                    if (n == 0) {
                        writer.write("\t\t\t\treturn new Symbol(null);\n");
                    } else {
                        writer.write("\t\t\t\treturn _symbols[offset + ");
                        writer.write(String.valueOf(n));
                        writer.write("];\n");
                    }
                    writer.write("\t\t\t}\n");
                }
                ++n;
            }
            writer.write("\t\t\tdefault:\n");
            writer.write("\t\t\t\tthrow new IllegalArgumentException(\"unknown production #\" + rule_num);\n");
            writer.write("\t\t}\n");
        }

        private static void writeReduceActionCode(Production production, Writer writer) throws IOException {
            for (int i = 0; i < production.rhs.items.length; ++i) {
                Production.RHS.Item item = production.rhs.items[i];
                if (item.alias == null) continue;
                writer.write("\t\t\t\t\t");
                String string = item.symbol.type;
                if (string == null) {
                    writer.write("final Symbol ");
                    writer.write(item.alias);
                    writer.write(" = _symbols[offset + ");
                    writer.write(String.valueOf(i + 1));
                    writer.write("];\n");
                    continue;
                }
                writer.write("final Symbol _symbol_");
                writer.write(item.alias);
                writer.write(" = _symbols[offset + ");
                writer.write(String.valueOf(i + 1));
                writer.write("];\n");
                if (string.charAt(0) == '+') {
                    string = string.substring(1);
                    writer.write("\t\t\t\t\tfinal ");
                    writer.write(Grammar.EBNF_LIST_TYPE_NAME);
                    writer.write(" _list_");
                    writer.write(item.alias);
                    writer.write(" = (");
                    writer.write(Grammar.EBNF_LIST_TYPE_NAME);
                    writer.write(") _symbol_");
                    writer.write(item.alias);
                    writer.write(".value;\n");
                    writer.write("\t\t\t\t\tfinal ");
                    writer.write(string);
                    writer.write("[] ");
                    writer.write(item.alias);
                    writer.write(" = _list_");
                    writer.write(item.alias);
                    writer.write(" == null ? new ");
                    writer.write(string);
                    writer.write("[0] : (");
                    writer.write(string);
                    writer.write("[]) _list_");
                    writer.write(item.alias);
                    writer.write(".toArray(new ");
                    writer.write(string);
                    writer.write("[_list_");
                    writer.write(item.alias);
                    writer.write(".size()]);\n");
                    continue;
                }
                writer.write("\t\t\t\t\tfinal ");
                writer.write(string);
                writer.write(32);
                writer.write(item.alias);
                writer.write(" = (");
                writer.write(string);
                writer.write(") _symbol_");
                writer.write(item.alias);
                writer.write(".value;\n");
            }
            writer.write("\t\t\t\t\t");
            writer.write(production.code);
            writer.write(10);
        }

        private static ByteArrayOutputStream serializeParsingTables(ParsingTables parsingTables, int[] nArray, NonTerminal nonTerminal) throws IOException {
            int n = parsingTables.getSize() + nArray.length * 4 + 6;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            DataOutputStream dataOutputStream = new DataOutputStream(new DeflaterOutputStream(byteArrayOutputStream));
            parsingTables.writeTo(dataOutputStream);
            dataOutputStream.writeShort(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
            dataOutputStream.writeShort(nonTerminal.id);
            dataOutputStream.close();
            return byteArrayOutputStream;
        }

        private static String encode(byte[] byArray) throws IOException {
            int n;
            int n2;
            StringBuffer stringBuffer = new StringBuffer((byArray.length * 4 + 2) / 3);
            int n3 = 0;
            int n4 = byArray.length - byArray.length % 3;
            while (n3 < n4) {
                n2 = byArray[n3++] & 0xFF;
                n = byArray[n3++] & 0xFF;
                int n5 = byArray[n3++] & 0xFF;
                CompiledParser.encode(n2 >> 2, stringBuffer);
                CompiledParser.encode(n2 << 4 & 0x30 | n >> 4, stringBuffer);
                CompiledParser.encode(n << 2 & 0x3C | n5 >> 6, stringBuffer);
                CompiledParser.encode(n5 & 0x3F, stringBuffer);
            }
            if (n3 < byArray.length) {
                n2 = byArray[n3++] & 0xFF;
                if (n3 < byArray.length) {
                    n = byArray[n3] & 0xFF;
                    CompiledParser.encode(n2 >> 2, stringBuffer);
                    CompiledParser.encode(n2 << 4 & 0x30 | n >> 4, stringBuffer);
                    CompiledParser.encode(n << 2 & 0x3C, stringBuffer);
                    stringBuffer.append('=');
                } else {
                    CompiledParser.encode(n2 >> 2, stringBuffer);
                    CompiledParser.encode(n2 << 4 & 0x30, stringBuffer);
                    stringBuffer.append('=');
                    stringBuffer.append('=');
                }
            }
            return stringBuffer.toString();
        }

        private static void encode(int n, StringBuffer stringBuffer) {
            if (n < 10) {
                stringBuffer.append((char)(48 + n));
            } else if (n < 36) {
                stringBuffer.append((char)(55 + n));
            } else if (n < 62) {
                stringBuffer.append((char)(61 + n));
            } else {
                stringBuffer.append(_62_or_63[n - 62]);
            }
        }

        CompiledParser(Grammar grammar, ParsingTables parsingTables) {
            this.grammar = grammar;
            this.tables = parsingTables;
            this.rule_descr = CompiledParser.makeProductionDescriptors(grammar);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeActionsReport(File file, String string) throws IOException {
            FileWriter fileWriter = new FileWriter(new File(file, string + ParserGenerator.PARSER_ACTIONS_REPORT_FILE_EXT));
            try {
                fileWriter.write("// This file was generated by Beaver v");
                fileWriter.write(ParserGenerator.VERSION);
                fileWriter.write("\n\n");
                State state = this.tables.first_state;
                while (state != null) {
                    fileWriter.write(String.valueOf(state.id));
                    fileWriter.write(58);
                    Action action = state.terminal_lookahead_actions.first;
                    while (action != null) {
                        fileWriter.write(9);
                        fileWriter.write(action.toString());
                        fileWriter.write(10);
                        action = action.next;
                    }
                    action = state.nonterminal_lookahead_actions.first;
                    while (action != null) {
                        fileWriter.write(9);
                        fileWriter.write(action.toString());
                        fileWriter.write(10);
                        action = action.next;
                    }
                    if (state.default_action != null) {
                        fileWriter.write(9);
                        fileWriter.write(state.default_action.toString());
                        fileWriter.write(10);
                    }
                    state = state.next;
                }
            }
            finally {
                fileWriter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeParserSource(File file, String string, Options options) throws IOException {
            File file2 = file.getParentFile();
            FileWriter fileWriter = new FileWriter(new File(file2, string + ParserGenerator.SOURCE_FILE_EXT));
            try {
                if (this.grammar.prolog != null) {
                    fileWriter.write(this.grammar.prolog);
                    fileWriter.write(10);
                }
                if (this.grammar.package_name != null) {
                    fileWriter.write("package ");
                    fileWriter.write(this.grammar.package_name);
                    fileWriter.write(";\n\n");
                }
                for (int i = 0; i < this.grammar.imports.length; ++i) {
                    fileWriter.write("import ");
                    fileWriter.write(this.grammar.imports[i]);
                    fileWriter.write(";\n");
                }
                fileWriter.write(10);
                fileWriter.write("/**\n");
                fileWriter.write(" * This class is a LALR parser generated by\n");
                fileWriter.write(" * <a href=\"http://beaver.sourceforge.net\">Beaver</a> v");
                fileWriter.write(ParserGenerator.VERSION);
                fileWriter.write(10);
                fileWriter.write(" * from the grammar specification \"");
                fileWriter.write(file.getName());
                fileWriter.write("\".\n");
                fileWriter.write(" */\n");
                this.writeClass(string, options, fileWriter);
            }
            finally {
                fileWriter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTerminalsSource(File file, String string, Options options) throws IOException {
            FileWriter fileWriter = new FileWriter(new File(file.getParentFile(), string + ParserGenerator.SOURCE_FILE_EXT));
            try {
                if (this.grammar.package_name != null) {
                    fileWriter.write("package ");
                    fileWriter.write(this.grammar.package_name);
                    fileWriter.write(";\n\n");
                }
                fileWriter.write("/**\n");
                fileWriter.write(" * This class lists terminals used by the\n");
                fileWriter.write(" * grammar specified in \"");
                fileWriter.write(file.getName());
                fileWriter.write("\".\n");
                fileWriter.write(" */\n");
                CompiledParser.writeTerminalsClass(this.grammar, options, "", fileWriter);
            }
            finally {
                fileWriter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeParsingTables(File file, String string) throws IOException {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(file, string + ParserGenerator.SERIALIZED_PARSER_TABLES_FILE_EXT));
            try {
                CompiledParser.serializeParsingTables(this.tables, this.rule_descr, this.grammar.error).writeTo(fileOutputStream);
            }
            finally {
                fileOutputStream.close();
            }
        }

        private void writeClass(String string, Options options, Writer writer) throws IOException {
            writer.write("public class ");
            writer.write(string);
            writer.write(" extends ");
            if (string.equals("Parser")) {
                writer.write("beaver.");
            }
            writer.write("Parser {\n");
            if (!options.export_terminals) {
                CompiledParser.writeTerminalsClass(this.grammar, options, "\t", writer);
            }
            boolean bl = CompiledParser.writeMarkersClass(this.grammar.terminals, writer);
            writer.write("\n\tstatic final ParsingTables PARSING_TABLES = new ParsingTables(");
            if (options.exp_parsing_tables) {
                writer.write(string);
                writer.write(".class");
            } else {
                int n;
                String string2 = this.encodeParsingTables();
                writer.write(10);
                int n2 = 0;
                for (int i = n = string2.length() != 71 ? 71 : 73; i < string2.length(); i += n) {
                    writer.write("\t\t\"");
                    writer.write(string2.substring(n2, i));
                    writer.write("\" +\n");
                    n2 = i;
                }
                writer.write("\t\t\"");
                writer.write(string2.substring(n2));
                writer.write(34);
            }
            writer.write(");\n");
            if (!options.use_switch) {
                if (options.name_action_classes) {
                    CompiledParser.writeReduceActionClasses(this.grammar, writer);
                }
                CompiledParser.writeStaticReturns(this.grammar, writer);
            }
            if (this.grammar.class_code != null) {
                writer.write(this.grammar.class_code);
                writer.write(10);
            }
            if (!options.use_switch) {
                writer.write(10);
                writer.write("\tprivate final Action[] actions;\n");
            }
            writer.write(10);
            writer.write("\tpublic ");
            writer.write(string);
            writer.write("() {\n");
            writer.write("\t\tsuper(PARSING_TABLES);\n");
            if (!options.use_switch) {
                writer.write("\t\tactions = new Action[] {");
                CompiledParser.writeParserActionsArray(this.grammar, options, writer);
                writer.write("\n\t\t};\n");
            }
            if (this.grammar.init_code != null) {
                writer.write(10);
                writer.write(this.grammar.init_code);
                writer.write(10);
            }
            writer.write("\t}\n");
            writer.write(10);
            writer.write("\tprotected Symbol invokeReduceAction(int rule_num, int offset) {\n");
            if (options.use_switch) {
                CompiledParser.writeParserActionsSwitch(this.grammar, options, writer);
            } else {
                writer.write("\t\treturn actions[rule_num].reduce(_symbols, offset);\n");
            }
            writer.write("\t}\n");
            writer.write("}\n");
        }

        private String encodeParsingTables() throws IOException {
            return CompiledParser.encode(CompiledParser.serializeParsingTables(this.tables, this.rule_descr, this.grammar.error).toByteArray());
        }
    }
}

