/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp.run;

import beaver.Parser;
import beaver.Scanner;
import beaver.Symbol;
import beaver.comp.ParserGenerator;
import beaver.comp.io.SrcReader;
import beaver.comp.run.Options;
import beaver.comp.util.Log;
import beaver.spec.Grammar;
import beaver.spec.parser.GrammarScanner;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AntTask
extends Task {
    private Options options = new Options();
    private File grammar_file;

    public void setFile(File file) {
        this.grammar_file = file;
    }

    public void setExportTables(boolean bl) {
        this.options.exp_parsing_tables = bl;
    }

    public void setExportTerminals(boolean bl) {
        this.options.export_terminals = bl;
    }

    public void setSortTerminals(boolean bl) {
        this.options.sort_terminals = bl;
    }

    public void setReportActions(boolean bl) {
        this.options.report_actions = bl;
    }

    public void setCompress(boolean bl) {
        this.options.no_compression = !bl;
    }

    public void setTerminalNames(boolean bl) {
        this.options.terminal_names = bl;
    }

    public void setAnonymousActions(boolean bl) {
        this.options.name_action_classes = !bl;
    }

    public void setUseSwitch(boolean bl) {
        this.options.use_switch = bl;
    }

    public void execute() throws BuildException {
        if (!this.grammar_file.canRead()) {
            throw new BuildException("Cannot read grammar file " + this.grammar_file);
        }
        SrcReader srcReader = AntTask.getSrcReader(this.grammar_file);
        try {
            if (this.existsCurrentOutput(AntTask.getOutputFileName(srcReader))) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        srcReader.reset();
        Log log = new Log();
        AntTask.compile(srcReader, this.options, log);
        log.report(this.grammar_file.getName(), srcReader);
    }

    private boolean existsCurrentOutput(String string) {
        String string2 = this.grammar_file.getParent();
        File file = new File(string2, string + ".java");
        if (!file.canRead() || this.grammar_file.lastModified() > file.lastModified()) {
            return false;
        }
        file = new File(string2, string + ".spec");
        return !this.options.exp_parsing_tables || file.canRead() && this.grammar_file.lastModified() <= file.lastModified();
    }

    private static SrcReader getSrcReader(File file) throws BuildException {
        try {
            return new SrcReader(file);
        }
        catch (IOException iOException) {
            throw new BuildException("Failed to read grammar file " + file);
        }
    }

    private static String getOutputFileName(SrcReader srcReader) throws IOException, Scanner.Exception {
        String string = srcReader.file.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        GrammarScanner grammarScanner = new GrammarScanner(srcReader);
        Symbol symbol = grammarScanner.nextToken();
        while (symbol.getId() != 0) {
            String string2;
            if (symbol.getId() == 8 && (symbol = grammarScanner.nextToken()).getId() == 3 && (string2 = (String)symbol.value) != null && (string2 = string2.trim()).length() > 0) {
                return string2;
            }
            symbol = grammarScanner.nextToken();
        }
        return string;
    }

    private static void compile(SrcReader srcReader, Options options, Log log) {
        try {
            ParserGenerator.compile(srcReader, options, log);
        }
        catch (Parser.Exception exception) {
            System.err.print("Error: ");
            System.err.println(exception.getMessage());
        }
        catch (Grammar.Exception exception) {
            System.err.print("Error: ");
            System.err.println(exception.getMessage());
        }
        catch (IOException iOException) {
            System.err.print("System Error: ");
            System.err.println(iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

