/*
 * Decompiled with CFR 0.152.
 */
package jpe;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class FileClassLoader
extends ClassLoader {
    private Collection<String> path;

    public FileClassLoader(String targetDir, String[] userClasses) {
        if (targetDir == null) {
            throw new IllegalArgumentException("Null target directory");
        }
        this.path = new ArrayList<String>(userClasses.length + 1);
        this.path.add(targetDir);
        String[] stringArray = userClasses;
        int n = userClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            this.path.add(p);
            ++n2;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String filename = String.valueOf(name.replace('.', File.separatorChar)) + ".class";
        try {
            byte[] data = this.loadClassData(filename);
            Class<?> c = this.defineClass(name, data, 0, data.length);
            if (c == null) {
                throw new ClassNotFoundException(name);
            }
            return c;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Error reading file: " + filename);
        }
    }

    private File searchPath(String filename) {
        for (String p : this.path) {
            File f = new File(p, filename);
            if (!f.exists()) continue;
            return f;
        }
        throw new Error("class " + filename + " not found on path: " + this.path.toString());
    }

    private byte[] loadClassData(String filename) throws IOException {
        File f = this.searchPath(filename);
        int size = (int)f.length();
        byte[] buff = new byte[size];
        FileInputStream fis = new FileInputStream(f);
        DataInputStream dis = new DataInputStream(fis);
        dis.readFully(buff);
        dis.close();
        return buff;
    }
}

