/*
 * Decompiled with CFR 0.152.
 */
package jpe;

import AST.BytecodeParser;
import AST.CompilationUnit;
import AST.Frontend;
import AST.JavaParser;
import AST.MethodDecl;
import beaver.Parser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import jpe.Environment;
import jpe.Util;

public class JavaChecker
extends Frontend {
    @Override
    protected void processNoErrors(CompilationUnit unit) {
    }

    public boolean compile(String[] args) {
        return this.process(args, new BytecodeParser(), new JavaParser(){

            @Override
            public CompilationUnit parse(InputStream is, String fileName) throws IOException, Parser.Exception {
                return new parser.JavaParser().parse(is, fileName);
            }
        });
    }

    public void pe() {
        Util.currentProgram = this.program;
        this.program.fillInMethodDeclarations();
        for (MethodDecl m : this.program.methodDeclarations) {
            if (m.isAbstract() || !m.name().equals("main") || !m.isStatic() || !m.isPublic() || !m.isVoid()) continue;
            Environment env = new Environment();
            env.inStack(null);
            m.rewrite_pe(env);
            env.outStack();
        }
        int i = 0;
        while (i < this.program.getCompilationUnits().getNumChild()) {
            CompilationUnit cu = (CompilationUnit)this.program.getCompilationUnits().getChild(i);
            if (cu.fromSource()) {
                cu.inline();
            }
            ++i;
        }
        String outDir = "outdir";
        if (this.program.options().hasValueForOption("-d")) {
            outDir = this.program.options().getValueForOption("-d");
        }
        Iterator iter = this.program.compilationUnitIterator();
        while (iter.hasNext()) {
            CompilationUnit cu = (CompilationUnit)iter.next();
            if (!cu.fromSource()) continue;
            File fcu = new File(cu.pathName());
            String fname = fcu.getName();
            fcu = new File(String.valueOf(outDir) + File.separator + cu.packageName().replace('.', File.separatorChar));
            fcu.mkdirs();
            File outfile = new File(String.valueOf(fcu.getAbsolutePath()) + File.separator + fname);
            try {
                System.out.println("Writing " + outfile.getCanonicalPath() + " ....");
                FileOutputStream fs = new FileOutputStream(outfile);
                fs.write(cu.toString().getBytes());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected String name() {
        return "Civet: Hybrid Partial Evaluator for Java";
    }

    @Override
    protected String version() {
        return "1.0";
    }
}

