/*
 * Decompiled with CFR 0.152.
 */
package jpe;

import AST.Annotation;
import AST.ConstructorDecl;
import AST.ConstructorDeclSubstituted;
import AST.ElementConstantValue;
import AST.ElementValuePair;
import AST.Expr;
import AST.FieldDeclaration;
import AST.Literal;
import AST.MethodDecl;
import AST.MethodDeclSubstituted;
import AST.Modifiers;
import AST.ParameterDeclaration;
import AST.Program;
import AST.StringLiteral;
import AST.TypeDecl;
import AST.Variable;
import AST.VariableDeclaration;
import java.io.File;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jpe.Clazz;
import jpe.CompileTimeInfo;
import jpe.FileClassLoader;
import jpe.JPE;
import jpe.Method;
import jpe.Parameter;

public class Util {
    public static FileClassLoader testClassLoader = new FileClassLoader(JPE.tempClassDir.getAbsolutePath(), JPE.options.getValueForOption("-classpath").split(File.pathSeparator));
    public static final int WHILE_UNFOLD_DEPTH = 10;
    public static final int FOR_UNFOLD_DEPTH = 10;
    public static List<Method> genMethods = new LinkedList<Method>();
    private static Set<String> methodNames = new HashSet<String>();
    private static List<Clazz> genClasses = new LinkedList<Clazz>();
    private static Set<String> classNames = new HashSet<String>();
    private static Integer nameSeqNum = new Integer(1000000);
    public static Program currentProgram;

    public static Class<?> getClassForType(String typename) throws ClassNotFoundException {
        if (typename.equals("@primitive.boolean")) {
            return Boolean.TYPE;
        }
        if (typename.equals("@primitive.int")) {
            return Integer.TYPE;
        }
        if (typename.equals("@primitive.short")) {
            return Short.TYPE;
        }
        if (typename.equals("@primitive.double")) {
            return Double.TYPE;
        }
        if (typename.equals("@primitive.long")) {
            return Long.TYPE;
        }
        if (typename.equals("@primitive.float")) {
            return Float.TYPE;
        }
        if (typename.equals("@primitive.byte")) {
            return Byte.TYPE;
        }
        if (typename.equals("@primitive.char")) {
            return Character.TYPE;
        }
        if (typename.endsWith("[]")) {
            Class<?> claz = Util.getClassForType(typename.substring(0, typename.length() - 2));
            return Array.newInstance(claz, 0).getClass();
        }
        return testClassLoader.loadClass(typename);
    }

    public static boolean isJavaLiteral(Class<?> clazz) {
        return clazz.equals(String.class) || clazz.equals(Boolean.class) || clazz.equals(Integer.class) || clazz.equals(Short.class) || clazz.equals(Double.class) || clazz.equals(Long.class) || clazz.equals(Float.class) || clazz.equals(Byte.class) || clazz.equals(Character.class) || clazz.equals(Boolean.TYPE) || clazz.equals(Integer.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Double.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Float.TYPE) || clazz.equals(Byte.TYPE) || clazz.equals(Character.TYPE);
    }

    public static Map<String, Boolean> clone(Map<String, Boolean> map) {
        HashMap<String, Boolean> clone = new HashMap<String, Boolean>();
        for (String s : map.keySet()) {
            clone.put(s, new Boolean(map.get(s)));
        }
        return clone;
    }

    public static Class<?>[] getParameterTypes(MethodDecl md) throws ClassNotFoundException {
        if (md instanceof MethodDeclSubstituted) {
            md = ((MethodDeclSubstituted)md).getOriginal();
        }
        Class[] parameterTypes = new Class[md.getParameterList().getNumChild()];
        int i = 0;
        while (i < md.getParameterList().getNumChild()) {
            String pType = String.valueOf(md.getParameter(i).type().erasure().packageName()) + "." + md.getParameter(i).type().erasure().name();
            parameterTypes[i] = Util.getClassForType(pType);
            ++i;
        }
        return parameterTypes;
    }

    public static Class<?>[] getParameterTypes(ConstructorDecl cd) throws ClassNotFoundException {
        if (cd instanceof ConstructorDeclSubstituted) {
            cd = ((ConstructorDeclSubstituted)cd).getOriginal();
        }
        Class[] parameterTypes = new Class[cd.getParameterList().getNumChild()];
        int i = 0;
        while (i < cd.getParameterList().getNumChild()) {
            String pType = String.valueOf(cd.getParameter(i).type().erasure().packageName()) + "." + cd.getParameter(i).type().erasure().name();
            parameterTypes[i] = Util.getClassForType(pType);
            ++i;
        }
        return parameterTypes;
    }

    public static Object[] getParameters(AST.List<Expr> args, Class<?>[] parameterTypes) {
        int formals = parameterTypes.length;
        int actuals = args.getNumChild();
        Object[] parameters = new Object[formals];
        Object[] varags = null;
        int i = 0;
        while (i < actuals) {
            Object arg = args.getChild(i);
            Object val = ((Expr)arg).literalValueObject();
            if (i == formals - 1 && parameterTypes[i].isArray() && !val.getClass().isArray()) {
                parameters[i] = varags = (Object[])Array.newInstance(parameterTypes[i].getComponentType(), args.getNumChild() - formals + 1);
            }
            if (varags != null) {
                varags[i + 1 - formals] = val;
            } else {
                parameters[i] = val;
            }
            ++i;
        }
        if (actuals == formals - 1 && parameterTypes[actuals].isArray()) {
            parameters[actuals] = Array.newInstance(parameterTypes[actuals].getComponentType(), 0);
        }
        return parameters;
    }

    public static Object[] getParameters(AST.List<Expr> args) {
        Object[] parameters = new Object[args.getNumChild()];
        int i = 0;
        while (i < args.getNumChild()) {
            parameters[i] = ((Literal)args.getChild(i)).literalValueObject();
            ++i;
        }
        return parameters;
    }

    public static void unify(Map<String, Boolean> m1, Map<String, Boolean> m2) {
        for (String s : m2.keySet()) {
            if (!m1.containsKey(s)) {
                m1.put(s, m2.get(s));
                continue;
            }
            m1.put(s, m1.get(s) != false || m2.get(s) != false);
        }
    }

    public static String generateName(MethodDecl decl, List<Parameter> staticArgs) {
        Method m = new Method(decl, staticArgs);
        int i = genMethods.indexOf(m);
        if (i >= 0) {
            return genMethods.get(i).getGenMethodName();
        }
        String genName = "";
        while (methodNames.contains(genName = String.valueOf(decl.name()) + "$" + Util.getNextNameSeqNum())) {
        }
        methodNames.add(genName);
        genMethods.add(m.setGenMethodName(genName));
        return genName;
    }

    public static String generateClassName(ConstructorDecl decl, List<Parameter> staticArgs) {
        Clazz m = new Clazz(decl, staticArgs);
        int i = genClasses.indexOf(m);
        if (i >= 0) {
            return genClasses.get(i).getClassName();
        }
        String genName = "";
        while (classNames.contains(genName = String.valueOf(decl.name()) + "$" + Util.getNextNameSeqNum())) {
        }
        classNames.add(genName);
        genClasses.add(m.setClassName(genName));
        return genName;
    }

    public static String getNextNameSeqNum() {
        nameSeqNum = nameSeqNum + 1;
        return String.valueOf(nameSeqNum);
    }

    private static TypeDecl lookupType(String packageName, String typeName) {
        return currentProgram.lookupType(packageName, typeName);
    }

    public static TypeDecl lookupType(Class<?> c) {
        String simpleName;
        String packagename;
        if (c.isArray()) {
            return Util.lookupType(c.getComponentType()).arrayType();
        }
        String qName = c.getName();
        if (c.isPrimitive()) {
            packagename = "@primitive";
            simpleName = qName;
        } else {
            packagename = qName.substring(0, qName.lastIndexOf("."));
            simpleName = qName.substring(packagename.length() + 1);
        }
        return Util.lookupType(packagename, simpleName);
    }

    public static CompileTimeInfo populateCompileTimeInfo(Variable v) {
        Annotation staticStageAnn;
        CompileTimeInfo staticStageInfo = new CompileTimeInfo(v);
        Modifiers modifiers = null;
        if (v instanceof VariableDeclaration) {
            modifiers = ((VariableDeclaration)v).getModifiers();
        } else if (v instanceof ParameterDeclaration) {
            modifiers = ((ParameterDeclaration)v).getModifiers();
        }
        if (v instanceof FieldDeclaration) {
            modifiers = ((FieldDeclaration)v).getModifiers();
        }
        if ((staticStageAnn = modifiers.annotation(Util.lookupType("jpe.annotations", "CompileTime"))) != null) {
            staticStageInfo.setCompileTime(true);
        }
        if ((staticStageAnn = modifiers.annotation(Util.lookupType("jpe.annotations", "CompileTimeIf"))) != null) {
            ElementConstantValue value = (ElementConstantValue)((ElementValuePair)staticStageAnn.getElementValuePairs().getChild(0)).getElementValue();
            String depname = ((StringLiteral)value.getChild(0)).getLITERAL();
            staticStageInfo.addDependency(depname);
        }
        v.setCompileTimeInfo(staticStageInfo);
        return staticStageInfo;
    }

    public static String changePathName(String path, String fileName) {
        int idx = path.lastIndexOf("/");
        if (idx == -1) {
            idx = 0;
        }
        return String.valueOf(path.substring(0, idx)) + "/" + fileName + ".java";
    }

    public static void assertTrue(Boolean cond, String sourceFile, int lineNumber, String msg) {
        if (!cond.booleanValue()) {
            System.err.println(String.valueOf(sourceFile) + ",line:" + lineNumber + "\n\t" + msg);
        }
    }
}

