/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.AdditiveExpr;
import AST.CodeGeneration;
import AST.Constant;
import AST.Expr;
import AST.StringLiteral;
import AST.TypeDecl;

public class AddExpr
extends AdditiveExpr
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public AddExpr clone() throws CloneNotSupportedException {
        AddExpr node = (AddExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public AddExpr copy() {
        try {
            AddExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public AddExpr fullCopy() {
        AddExpr res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void typeCheck() {
        TypeDecl left = this.getLeftOperand().type();
        TypeDecl right = this.getRightOperand().type();
        if (!left.isString() && !right.isString()) {
            super.typeCheck();
        } else if (left.isVoid()) {
            this.error("The type void of the left hand side is not numeric");
        } else if (right.isVoid()) {
            this.error("The type void of the right hand side is not numeric");
        }
    }

    @Override
    void emitOperation(CodeGeneration gen) {
        this.type().add(gen);
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        if (!this.type().isString()) {
            super.createBCode(gen);
        } else if (this.isConstant()) {
            StringLiteral.push(gen, this.constant().stringValue());
        } else {
            TypeDecl argumentType;
            int index;
            String desc;
            TypeDecl stringBuffer = this.lookupType("java.lang", "StringBuffer");
            String classname = stringBuffer.constantPoolName();
            if (this.firstStringAddPart()) {
                stringBuffer.emitNew(gen);
                gen.emitDup();
                desc = "()V";
                index = gen.constantPool().addMethodref(classname, "<init>", desc);
                gen.emit((byte)-73, -1).add2(index);
                this.getLeftOperand().createBCode(gen);
                argumentType = this.getLeftOperand().type().stringPromotion();
                desc = "(" + argumentType.typeDescriptor() + ")" + stringBuffer.typeDescriptor();
                index = gen.constantPool().addMethodref(classname, "append", desc);
                gen.emit((byte)-74, -argumentType.variableSize()).add2(index);
            } else {
                this.getLeftOperand().createBCode(gen);
            }
            this.getRightOperand().createBCode(gen);
            argumentType = this.getRightOperand().type().stringPromotion();
            desc = "(" + argumentType.typeDescriptor() + ")" + stringBuffer.typeDescriptor();
            index = gen.constantPool().addMethodref(classname, "append", desc);
            gen.emit((byte)-74, -argumentType.variableSize()).add2(index);
            if (this.lastStringAddPart()) {
                desc = "()" + this.type().typeDescriptor();
                index = gen.constantPool().addMethodref(classname, "toString", desc);
                gen.emit((byte)-74, 0).add2(index);
            }
        }
    }

    public AddExpr() {
    }

    public AddExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLeftOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getLeftOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getLeftOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public void setRightOperand(Expr node) {
        this.setChild(node, 1);
    }

    @Override
    public Expr getRightOperand() {
        return (Expr)this.getChild(1);
    }

    @Override
    public Expr getRightOperandNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        Constant constant_value = this.constant_compute();
        return constant_value;
    }

    private Constant constant_compute() {
        return this.type().add(this.getLeftOperand().constant(), this.getRightOperand().constant());
    }

    @Override
    public String printOp() {
        ASTNode$State state = this.state();
        String printOp_value = this.printOp_compute();
        return printOp_value;
    }

    private String printOp_compute() {
        return " + ";
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        TypeDecl left = this.getLeftOperand().type();
        TypeDecl right = this.getRightOperand().type();
        if (!left.isString() && !right.isString()) {
            return super.type();
        }
        if (left.isVoid() || right.isVoid()) {
            return this.unknownType();
        }
        return left.isString() ? left : right;
    }

    @Override
    public boolean isStringAdd() {
        ASTNode$State state = this.state();
        boolean isStringAdd_value = this.isStringAdd_compute();
        return isStringAdd_value;
    }

    private boolean isStringAdd_compute() {
        return this.type().isString() && !this.isConstant();
    }

    public boolean firstStringAddPart() {
        ASTNode$State state = this.state();
        boolean firstStringAddPart_value = this.firstStringAddPart_compute();
        return firstStringAddPart_value;
    }

    private boolean firstStringAddPart_compute() {
        return this.type().isString() && !this.getLeftOperand().isStringAdd();
    }

    public boolean lastStringAddPart() {
        ASTNode$State state = this.state();
        boolean lastStringAddPart_value = this.lastStringAddPart_compute();
        return lastStringAddPart_value;
    }

    private boolean lastStringAddPart_compute() {
        return !this.getParent().isStringAdd();
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

