/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.AssignAdditiveExpr;
import AST.CodeGeneration;
import AST.Expr;
import AST.TypeDecl;

public class AssignPlusExpr
extends AssignAdditiveExpr
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public AssignPlusExpr clone() throws CloneNotSupportedException {
        AssignPlusExpr node = (AssignPlusExpr)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public AssignPlusExpr copy() {
        try {
            AssignPlusExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public AssignPlusExpr fullCopy() {
        AssignPlusExpr res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void typeCheck() {
        if (!this.getDest().isVariable()) {
            this.error("left hand side is not a variable");
        } else {
            if (this.getSource().type().isUnknown() || this.getDest().type().isUnknown()) {
                return;
            }
            if (this.getDest().type().isString() && !this.getSource().type().isVoid()) {
                return;
            }
            if (this.getSource().type().isBoolean() || this.getDest().type().isBoolean()) {
                this.error("Operator + does not operate on boolean types");
            } else {
                if (this.getSource().type().isPrimitive() && this.getDest().type().isPrimitive()) {
                    return;
                }
                this.error("can not assign " + this.getDest() + " of type " + this.getDest().type().typeName() + " a value of type " + this.sourceType().typeName());
            }
        }
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        TypeDecl dest = this.getDest().type();
        TypeDecl source = this.getSource().type();
        if (dest.isString()) {
            this.getDest().createAssignLoadDest(gen);
            TypeDecl stringBuffer = this.lookupType("java.lang", "StringBuffer");
            String classname = stringBuffer.constantPoolName();
            stringBuffer.emitNew(gen);
            gen.emitDup();
            String desc = "()V";
            int index = gen.constantPool().addMethodref(classname, "<init>", desc);
            gen.emit((byte)-73, -1).add2(index);
            gen.emitSwap();
            TypeDecl argumentType = dest.stringPromotion();
            desc = "(" + argumentType.typeDescriptor() + ")" + stringBuffer.typeDescriptor();
            index = gen.constantPool().addMethodref(classname, "append", desc);
            gen.emit((byte)-74, -argumentType.variableSize()).add2(index);
            this.getSource().createBCode(gen);
            argumentType = source.stringPromotion();
            desc = "(" + argumentType.typeDescriptor() + ")" + stringBuffer.typeDescriptor();
            index = gen.constantPool().addMethodref(classname, "append", desc);
            gen.emit((byte)-74, -argumentType.variableSize()).add2(index);
            desc = "()" + this.type().typeDescriptor();
            index = gen.constantPool().addMethodref(classname, "toString", desc);
            gen.emit((byte)-74, 0).add2(index);
            if (this.needsPush()) {
                this.getDest().createPushAssignmentResult(gen);
            }
            this.getDest().emitStore(gen);
        } else {
            super.createBCode(gen);
        }
    }

    @Override
    public void createAssignOp(CodeGeneration gen, TypeDecl type) {
        type.add(gen);
    }

    public AssignPlusExpr() {
    }

    public AssignPlusExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setDest(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getDest() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getDestNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public void setSource(Expr node) {
        this.setChild(node, 1);
    }

    @Override
    public Expr getSource() {
        return (Expr)this.getChild(1);
    }

    @Override
    public Expr getSourceNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    @Override
    public String printOp() {
        ASTNode$State state = this.state();
        String printOp_value = this.printOp_compute();
        return printOp_value;
    }

    private String printOp_compute() {
        return " += ";
    }

    @Override
    public TypeDecl sourceType() {
        ASTNode$State state = this.state();
        TypeDecl sourceType_value = this.sourceType_compute();
        return sourceType_value;
    }

    private TypeDecl sourceType_compute() {
        TypeDecl left = this.getDest().type();
        TypeDecl right = this.getSource().type();
        if (!left.isString() && !right.isString()) {
            return super.sourceType();
        }
        if (left.isVoid() || right.isVoid()) {
            return this.unknownType();
        }
        return left.isString() ? left : right;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

