/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Access;
import AST.BodyDecl;
import AST.BooleanLiteral;
import AST.CodeGeneration;
import AST.Constant;
import AST.ConstantPool;
import AST.Expr;
import AST.List;
import AST.Literal;
import AST.Modifiers;
import AST.Opt;
import AST.PrimitiveType;
import AST.TypeDecl;
import beaver.Symbol;

public class BooleanType
extends PrimitiveType
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
        this.typeDescriptor_computed = false;
        this.typeDescriptor_value = null;
        this.jvmName_computed = false;
        this.jvmName_value = null;
        this.boxed_computed = false;
        this.boxed_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public BooleanType clone() throws CloneNotSupportedException {
        BooleanType node = (BooleanType)super.clone();
        node.typeDescriptor_computed = false;
        node.typeDescriptor_value = null;
        node.jvmName_computed = false;
        node.jvmName_value = null;
        node.boxed_computed = false;
        node.boxed_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public BooleanType copy() {
        try {
            BooleanType node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    @Override
    public BooleanType fullCopy() {
        BooleanType res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("boolean");
    }

    @Override
    public int addConstant(ConstantPool p, Constant c) {
        return p.addConstant(c.booleanValue() ? 1 : 0);
    }

    @Override
    void logNot(CodeGeneration gen) {
        gen.emit((byte)4).emit((byte)-126);
    }

    @Override
    void bitand(CodeGeneration gen) {
        gen.emit((byte)126);
    }

    @Override
    void bitor(CodeGeneration gen) {
        gen.emit((byte)-128);
    }

    @Override
    void bitxor(CodeGeneration gen) {
        gen.emit((byte)-126);
    }

    @Override
    public void branchEQ(CodeGeneration gen, int label) {
        gen.emitCompare((byte)-97, label);
    }

    @Override
    public void branchNE(CodeGeneration gen, int label) {
        gen.emitCompare((byte)-96, label);
    }

    public BooleanType() {
        this.setChild(new Opt(), 1);
        this.setChild(new List(), 2);
    }

    public BooleanType(Modifiers p0, String p1, Opt<Access> p2, List<BodyDecl> p3) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
    }

    public BooleanType(Modifiers p0, Symbol p1, Opt<Access> p2, List<BodyDecl> p3) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
    }

    @Override
    protected int numChildren() {
        return 3;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setModifiers(Modifiers node) {
        this.setChild(node, 0);
    }

    @Override
    public Modifiers getModifiers() {
        return (Modifiers)this.getChild(0);
    }

    @Override
    public Modifiers getModifiersNoTransform() {
        return (Modifiers)this.getChildNoTransform(0);
    }

    @Override
    public void setID(String value) {
        this.tokenString_ID = value;
    }

    @Override
    public void setID(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol.value;
        this.IDstart = symbol.getStart();
        this.IDend = symbol.getEnd();
    }

    @Override
    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    @Override
    public void setSuperClassAccessOpt(Opt<Access> opt) {
        this.setChild(opt, 1);
    }

    @Override
    public boolean hasSuperClassAccess() {
        return this.getSuperClassAccessOpt().getNumChild() != 0;
    }

    @Override
    public Access getSuperClassAccess() {
        return (Access)this.getSuperClassAccessOpt().getChild(0);
    }

    @Override
    public void setSuperClassAccess(Access node) {
        this.getSuperClassAccessOpt().setChild(node, 0);
    }

    @Override
    public Opt<Access> getSuperClassAccessOpt() {
        return (Opt)this.getChild(1);
    }

    @Override
    public Opt<Access> getSuperClassAccessOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    @Override
    public void setBodyDeclList(List<BodyDecl> list) {
        this.setChild(list, 2);
    }

    @Override
    public int getNumBodyDecl() {
        return this.getBodyDeclList().getNumChild();
    }

    @Override
    public BodyDecl getBodyDecl(int i) {
        return (BodyDecl)this.getBodyDeclList().getChild(i);
    }

    @Override
    public void addBodyDecl(BodyDecl node) {
        List<BodyDecl> list = this.parent == null || state == null ? this.getBodyDeclListNoTransform() : this.getBodyDeclList();
        list.addChild(node);
    }

    @Override
    public void addBodyDeclNoTransform(BodyDecl node) {
        List<BodyDecl> list = this.getBodyDeclListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setBodyDecl(BodyDecl node, int i) {
        List<BodyDecl> list = this.getBodyDeclList();
        list.setChild(node, i);
    }

    @Override
    public List<BodyDecl> getBodyDecls() {
        return this.getBodyDeclList();
    }

    @Override
    public List<BodyDecl> getBodyDeclsNoTransform() {
        return this.getBodyDeclListNoTransform();
    }

    @Override
    public List<BodyDecl> getBodyDeclList() {
        List list = (List)this.getChild(2);
        list.getNumChild();
        return list;
    }

    @Override
    public List<BodyDecl> getBodyDeclListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    @Override
    void emitCastTo(CodeGeneration gen, TypeDecl type) {
        if (type.unboxed() == this || type.isObject()) {
            this.boxed().emitBoxingOperation(gen);
        }
    }

    @Override
    public Constant cast(Constant c) {
        ASTNode$State state = this.state();
        Constant cast_Constant_value = this.cast_compute(c);
        return cast_Constant_value;
    }

    private Constant cast_compute(Constant c) {
        return Constant.create(c.booleanValue());
    }

    @Override
    public Constant andBitwise(Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        Constant andBitwise_Constant_Constant_value = this.andBitwise_compute(c1, c2);
        return andBitwise_Constant_Constant_value;
    }

    private Constant andBitwise_compute(Constant c1, Constant c2) {
        return Constant.create(c1.booleanValue() & c2.booleanValue());
    }

    @Override
    public Constant xorBitwise(Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        Constant xorBitwise_Constant_Constant_value = this.xorBitwise_compute(c1, c2);
        return xorBitwise_Constant_Constant_value;
    }

    private Constant xorBitwise_compute(Constant c1, Constant c2) {
        return Constant.create(c1.booleanValue() ^ c2.booleanValue());
    }

    @Override
    public Constant orBitwise(Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        Constant orBitwise_Constant_Constant_value = this.orBitwise_compute(c1, c2);
        return orBitwise_Constant_Constant_value;
    }

    private Constant orBitwise_compute(Constant c1, Constant c2) {
        return Constant.create(c1.booleanValue() | c2.booleanValue());
    }

    @Override
    public Constant questionColon(Constant cond, Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        Constant questionColon_Constant_Constant_Constant_value = this.questionColon_compute(cond, c1, c2);
        return questionColon_Constant_Constant_Constant_value;
    }

    private Constant questionColon_compute(Constant cond, Constant c1, Constant c2) {
        return Constant.create(cond.booleanValue() ? c1.booleanValue() : c2.booleanValue());
    }

    @Override
    public boolean eqIsTrue(Expr left, Expr right) {
        ASTNode$State state = this.state();
        boolean eqIsTrue_Expr_Expr_value = this.eqIsTrue_compute(left, right);
        return eqIsTrue_Expr_Expr_value;
    }

    private boolean eqIsTrue_compute(Expr left, Expr right) {
        return left.isTrue() && right.isTrue() || left.isFalse() && right.isFalse();
    }

    @Override
    public boolean isBoolean() {
        ASTNode$State state = this.state();
        boolean isBoolean_value = this.isBoolean_compute();
        return isBoolean_value;
    }

    private boolean isBoolean_compute() {
        return true;
    }

    @Override
    public byte arrayLoad() {
        ASTNode$State state = this.state();
        byte arrayLoad_value = this.arrayLoad_compute();
        return arrayLoad_value;
    }

    private byte arrayLoad_compute() {
        return 51;
    }

    @Override
    public byte arrayStore() {
        ASTNode$State state = this.state();
        byte arrayStore_value = this.arrayStore_compute();
        return arrayStore_value;
    }

    private byte arrayStore_compute() {
        return 84;
    }

    @Override
    public String typeDescriptor() {
        if (this.typeDescriptor_computed) {
            return this.typeDescriptor_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeDescriptor_value = this.typeDescriptor_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeDescriptor_computed = true;
        }
        return this.typeDescriptor_value;
    }

    private String typeDescriptor_compute() {
        return "Z";
    }

    @Override
    public int arrayPrimitiveTypeDescriptor() {
        ASTNode$State state = this.state();
        int arrayPrimitiveTypeDescriptor_value = this.arrayPrimitiveTypeDescriptor_compute();
        return arrayPrimitiveTypeDescriptor_value;
    }

    private int arrayPrimitiveTypeDescriptor_compute() {
        return 4;
    }

    @Override
    public String jvmName() {
        if (this.jvmName_computed) {
            return this.jvmName_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.jvmName_value = this.jvmName_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.jvmName_computed = true;
        }
        return this.jvmName_value;
    }

    private String jvmName_compute() {
        return "Z";
    }

    @Override
    public String primitiveClassName() {
        ASTNode$State state = this.state();
        String primitiveClassName_value = this.primitiveClassName_compute();
        return primitiveClassName_value;
    }

    private String primitiveClassName_compute() {
        return "Boolean";
    }

    @Override
    public TypeDecl boxed() {
        if (this.boxed_computed) {
            return this.boxed_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.boxed_value = this.boxed_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.boxed_computed = true;
        }
        return this.boxed_value;
    }

    private TypeDecl boxed_compute() {
        return this.lookupType("java.lang", "Boolean");
    }

    @Override
    public Literal defaultValue() {
        ASTNode$State state = this.state();
        Literal defaultValue_value = this.defaultValue_compute();
        return defaultValue_value;
    }

    private Literal defaultValue_compute() {
        return new BooleanLiteral(false);
    }

    @Override
    public Literal initVal() {
        ASTNode$State state = this.state();
        Literal initVal_value = this.initVal_compute();
        return initVal_value;
    }

    private Literal initVal_compute() {
        return new BooleanLiteral(false);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

