/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.Bytecode;
import java.io.PrintStream;

public class BytecodeDebug
extends Bytecode {
    public static int stackChange(byte b) {
        int change = 0;
        switch (b) {
            case -124: 
            case -122: 
            case -118: 
            case -117: 
            case -113: 
            case -111: 
            case -110: 
            case -109: 
            case -89: 
            case -88: 
            case -87: 
            case -79: 
            case -68: 
            case -67: 
            case -66: 
            case -64: 
            case -63: 
            case -60: 
            case -56: 
            case -55: 
            case -54: 
            case -2: 
            case -1: 
            case 0: 
            case 47: 
            case 49: 
            case 95: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                change = 0;
                break;
            }
            case -123: 
            case -121: 
            case -116: 
            case -115: 
            case -69: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 89: 
            case 90: 
            case 91: {
                change = 1;
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 92: 
            case 93: 
            case 94: {
                change = 2;
                break;
            }
            case -128: 
            case -126: 
            case -120: 
            case -119: 
            case -114: 
            case -112: 
            case -107: 
            case -106: 
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -86: 
            case -85: 
            case -84: 
            case -82: 
            case -80: 
            case -65: 
            case -62: 
            case -61: 
            case -58: 
            case -57: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 87: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                change = -1;
                break;
            }
            case -127: 
            case -125: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -83: 
            case -81: 
            case 55: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 88: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 127: {
                change = -2;
                break;
            }
            case -108: 
            case -105: 
            case -104: 
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                change = -3;
                break;
            }
            case 80: 
            case 82: {
                change = -4;
                break;
            }
            default: {
                throw new Error("Can not compute stack change for bytecode: " + b);
            }
        }
        return change;
    }

    public static String toString(byte code) {
        String res = "";
        switch (code) {
            case 0: {
                res = "nop";
                break;
            }
            case 1: {
                res = "aconst_null";
                break;
            }
            case 2: {
                res = "iconst_m1";
                break;
            }
            case 3: {
                res = "iconst_0";
                break;
            }
            case 4: {
                res = "iconst_1";
                break;
            }
            case 5: {
                res = "iconst_2";
                break;
            }
            case 6: {
                res = "iconst_3";
                break;
            }
            case 7: {
                res = "iconst_4";
                break;
            }
            case 8: {
                res = "iconst_5";
                break;
            }
            case 9: {
                res = "lconst_0";
                break;
            }
            case 10: {
                res = "lconst_1";
                break;
            }
            case 11: {
                res = "fconst_0";
                break;
            }
            case 12: {
                res = "fconst_1";
                break;
            }
            case 13: {
                res = "fconst_2";
                break;
            }
            case 14: {
                res = "dconst_0";
                break;
            }
            case 15: {
                res = "dconst_1";
                break;
            }
            case 16: {
                res = "bipush";
                break;
            }
            case 17: {
                res = "sipush";
                break;
            }
            case 18: {
                res = "ldc";
                break;
            }
            case 19: {
                res = "ldc_w";
                break;
            }
            case 20: {
                res = "ldc2_w";
                break;
            }
            case 21: {
                res = "iload";
                break;
            }
            case 22: {
                res = "lload";
                break;
            }
            case 23: {
                res = "fload";
                break;
            }
            case 24: {
                res = "dload";
                break;
            }
            case 25: {
                res = "aload";
                break;
            }
            case 26: {
                res = "iload_0";
                break;
            }
            case 27: {
                res = "iload_1";
                break;
            }
            case 28: {
                res = "iload_2";
                break;
            }
            case 29: {
                res = "iload_3";
                break;
            }
            case 30: {
                res = "lload_0";
                break;
            }
            case 31: {
                res = "lload_1";
                break;
            }
            case 32: {
                res = "lload_2";
                break;
            }
            case 33: {
                res = "lload_3";
                break;
            }
            case 34: {
                res = "fload_0";
                break;
            }
            case 35: {
                res = "fload_1";
                break;
            }
            case 36: {
                res = "fload_2";
                break;
            }
            case 37: {
                res = "fload_3";
                break;
            }
            case 38: {
                res = "dload_0";
                break;
            }
            case 39: {
                res = "dload_1";
                break;
            }
            case 40: {
                res = "dload_2";
                break;
            }
            case 41: {
                res = "dload_3";
                break;
            }
            case 42: {
                res = "aload_0";
                break;
            }
            case 43: {
                res = "aload_1";
                break;
            }
            case 44: {
                res = "aload_2";
                break;
            }
            case 45: {
                res = "aload_3";
                break;
            }
            case 46: {
                res = "iaload";
                break;
            }
            case 47: {
                res = "laload";
                break;
            }
            case 48: {
                res = "faload";
                break;
            }
            case 49: {
                res = "daload";
                break;
            }
            case 50: {
                res = "aaload";
                break;
            }
            case 51: {
                res = "baload";
                break;
            }
            case 52: {
                res = "caload";
                break;
            }
            case 53: {
                res = "saload";
                break;
            }
            case 54: {
                res = "istore";
                break;
            }
            case 55: {
                res = "lstore";
                break;
            }
            case 56: {
                res = "fstore";
                break;
            }
            case 57: {
                res = "dstore";
                break;
            }
            case 58: {
                res = "astore";
                break;
            }
            case 59: {
                res = "istore_0";
                break;
            }
            case 60: {
                res = "istore_1";
                break;
            }
            case 61: {
                res = "istore_2";
                break;
            }
            case 62: {
                res = "istore_3";
                break;
            }
            case 63: {
                res = "lstore_0";
                break;
            }
            case 64: {
                res = "lstore_1";
                break;
            }
            case 65: {
                res = "lstore_2";
                break;
            }
            case 66: {
                res = "lstore_3";
                break;
            }
            case 67: {
                res = "fstore_0";
                break;
            }
            case 68: {
                res = "fstore_1";
                break;
            }
            case 69: {
                res = "fstore_2";
                break;
            }
            case 70: {
                res = "fstore_3";
                break;
            }
            case 71: {
                res = "dstore_0";
                break;
            }
            case 72: {
                res = "dstore_1";
                break;
            }
            case 73: {
                res = "dstore_2";
                break;
            }
            case 74: {
                res = "dstore_3";
                break;
            }
            case 75: {
                res = "astore_0";
                break;
            }
            case 76: {
                res = "astore_1";
                break;
            }
            case 77: {
                res = "astore_2";
                break;
            }
            case 78: {
                res = "astore_3";
                break;
            }
            case 79: {
                res = "iastore";
                break;
            }
            case 80: {
                res = "lastore";
                break;
            }
            case 81: {
                res = "fastore";
                break;
            }
            case 82: {
                res = "dastore";
                break;
            }
            case 83: {
                res = "aastore";
                break;
            }
            case 84: {
                res = "bastore";
                break;
            }
            case 85: {
                res = "castore";
                break;
            }
            case 86: {
                res = "sastore";
                break;
            }
            case 87: {
                res = "pop";
                break;
            }
            case 88: {
                res = "pop2";
                break;
            }
            case 89: {
                res = "dup";
                break;
            }
            case 90: {
                res = "dup_x1";
                break;
            }
            case 91: {
                res = "dup_x2";
                break;
            }
            case 92: {
                res = "dup2";
                break;
            }
            case 93: {
                res = "dup2_x1";
                break;
            }
            case 94: {
                res = "dup2_x2";
                break;
            }
            case 95: {
                res = "swap";
                break;
            }
            case 96: {
                res = "iadd";
                break;
            }
            case 97: {
                res = "ladd";
                break;
            }
            case 98: {
                res = "fadd";
                break;
            }
            case 99: {
                res = "dadd";
                break;
            }
            case 100: {
                res = "isub";
                break;
            }
            case 101: {
                res = "lsub";
                break;
            }
            case 102: {
                res = "fsub";
                break;
            }
            case 103: {
                res = "dsub";
                break;
            }
            case 104: {
                res = "imul";
                break;
            }
            case 105: {
                res = "lmul";
                break;
            }
            case 106: {
                res = "fmul";
                break;
            }
            case 107: {
                res = "dmul";
                break;
            }
            case 108: {
                res = "idiv";
                break;
            }
            case 109: {
                res = "ldiv";
                break;
            }
            case 110: {
                res = "fdiv";
                break;
            }
            case 111: {
                res = "ddiv";
                break;
            }
            case 112: {
                res = "irem";
                break;
            }
            case 113: {
                res = "lrem";
                break;
            }
            case 114: {
                res = "frem";
                break;
            }
            case 115: {
                res = "drem";
                break;
            }
            case 116: {
                res = "ineg";
                break;
            }
            case 117: {
                res = "lneg";
                break;
            }
            case 118: {
                res = "fneg";
                break;
            }
            case 119: {
                res = "dneg";
                break;
            }
            case 120: {
                res = "ishl";
                break;
            }
            case 121: {
                res = "lshl";
                break;
            }
            case 122: {
                res = "ishr";
                break;
            }
            case 123: {
                res = "lshr";
                break;
            }
            case 124: {
                res = "iushr";
                break;
            }
            case 125: {
                res = "lushr";
                break;
            }
            case 126: {
                res = "iand";
                break;
            }
            case 127: {
                res = "land";
                break;
            }
            case -128: {
                res = "ior";
                break;
            }
            case -127: {
                res = "lor";
                break;
            }
            case -126: {
                res = "ixor";
                break;
            }
            case -125: {
                res = "lxor";
                break;
            }
            case -124: {
                res = "iinc";
                break;
            }
            case -123: {
                res = "i2l";
                break;
            }
            case -122: {
                res = "i2f";
                break;
            }
            case -121: {
                res = "i2d";
                break;
            }
            case -120: {
                res = "l2i";
                break;
            }
            case -119: {
                res = "l2f";
                break;
            }
            case -118: {
                res = "l2d";
                break;
            }
            case -117: {
                res = "f2i";
                break;
            }
            case -116: {
                res = "f2l";
                break;
            }
            case -115: {
                res = "f2d";
                break;
            }
            case -114: {
                res = "d2i";
                break;
            }
            case -113: {
                res = "d2l";
                break;
            }
            case -112: {
                res = "d2f";
                break;
            }
            case -111: {
                res = "i2b";
                break;
            }
            case -110: {
                res = "i2c";
                break;
            }
            case -109: {
                res = "i2s";
                break;
            }
            case -108: {
                res = "lcmp";
                break;
            }
            case -107: {
                res = "fcmpl";
                break;
            }
            case -106: {
                res = "fcmpg";
                break;
            }
            case -105: {
                res = "dcmpl";
                break;
            }
            case -104: {
                res = "dcmpg";
                break;
            }
            case -103: {
                res = "ifeq";
                break;
            }
            case -102: {
                res = "ifne";
                break;
            }
            case -101: {
                res = "iflt";
                break;
            }
            case -100: {
                res = "ifge";
                break;
            }
            case -99: {
                res = "ifgt";
                break;
            }
            case -98: {
                res = "ifle";
                break;
            }
            case -97: {
                res = "if_icmpeq";
                break;
            }
            case -96: {
                res = "if_icmpne";
                break;
            }
            case -95: {
                res = "if_icmplt";
                break;
            }
            case -94: {
                res = "if_icmpge";
                break;
            }
            case -93: {
                res = "if_icmpgt";
                break;
            }
            case -92: {
                res = "if_icmple";
                break;
            }
            case -91: {
                res = "if_acmpeq";
                break;
            }
            case -90: {
                res = "if_acmpne";
                break;
            }
            case -89: {
                res = "goto";
                break;
            }
            case -88: {
                res = "jsr";
                break;
            }
            case -87: {
                res = "ret";
                break;
            }
            case -86: {
                res = "tableswitch";
                break;
            }
            case -85: {
                res = "lookupswitch";
                break;
            }
            case -84: {
                res = "ireturn";
                break;
            }
            case -83: {
                res = "lreturn";
                break;
            }
            case -82: {
                res = "freturn";
                break;
            }
            case -81: {
                res = "dreturn";
                break;
            }
            case -80: {
                res = "areturn";
                break;
            }
            case -79: {
                res = "return";
                break;
            }
            case -78: {
                res = "getstatic";
                break;
            }
            case -77: {
                res = "putstatic";
                break;
            }
            case -76: {
                res = "getfield";
                break;
            }
            case -75: {
                res = "putfield";
                break;
            }
            case -74: {
                res = "invokevirtual";
                break;
            }
            case -73: {
                res = "invokespecial";
                break;
            }
            case -72: {
                res = "invokestatic";
                break;
            }
            case -71: {
                res = "invokeinterface";
                break;
            }
            case -69: {
                res = "new";
                break;
            }
            case -68: {
                res = "newarray";
                break;
            }
            case -67: {
                res = "anewarray";
                break;
            }
            case -66: {
                res = "arraylength";
                break;
            }
            case -65: {
                res = "athrow";
                break;
            }
            case -64: {
                res = "checkcast";
                break;
            }
            case -63: {
                res = "instanceof";
                break;
            }
            case -62: {
                res = "monitorenter";
                break;
            }
            case -61: {
                res = "monitorexit";
                break;
            }
            case -60: {
                res = "wide";
                break;
            }
            case -59: {
                res = "multianewarray";
                break;
            }
            case -58: {
                res = "ifnull";
                break;
            }
            case -57: {
                res = "ifnonnull";
                break;
            }
            case -56: {
                res = "goto_w";
                break;
            }
            case -55: {
                res = "jsr_w";
                break;
            }
            case -54: {
                res = "breakpoint";
                break;
            }
            case -2: {
                res = "impdep1";
                break;
            }
            case -1: {
                res = "impdep2";
                break;
            }
            default: {
                res = "<UNKNOWN BYTECODE:" + code + ">";
            }
        }
        return res;
    }

    private static String getByteOperand(byte[] codes, int index) {
        return Integer.toString(codes[index]);
    }

    private static String getCharOperand(byte[] codes, int index) {
        int hi = codes[index + 0] << 8;
        int lo = (codes[index + 1] & 0xFF) << 0;
        return Integer.toString(hi + lo);
    }

    private static String getIntOperand(byte[] codes, int index) {
        int hh = codes[index + 0] << 24;
        int hl = (codes[index + 1] & 0xFF) << 16;
        int lh = (codes[index + 2] & 0xFF) << 8;
        int ll = (codes[index + 3] & 0xFF) << 0;
        return Integer.toString(hh + hl + lh + ll);
    }

    public static String getOperands(byte[] codes, int index) {
        String res = "";
        switch (codes[index]) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 17: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case 18: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 19: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case 20: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case 21: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 22: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 23: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 24: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 25: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                break;
            }
            case 44: {
                break;
            }
            case 45: {
                break;
            }
            case 46: {
                break;
            }
            case 47: {
                break;
            }
            case 48: {
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                break;
            }
            case 51: {
                break;
            }
            case 52: {
                break;
            }
            case 53: {
                break;
            }
            case 54: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 55: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 56: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 57: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 58: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case 59: {
                break;
            }
            case 60: {
                break;
            }
            case 61: {
                break;
            }
            case 62: {
                break;
            }
            case 63: {
                break;
            }
            case 64: {
                break;
            }
            case 65: {
                break;
            }
            case 66: {
                break;
            }
            case 67: {
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                break;
            }
            case 70: {
                break;
            }
            case 71: {
                break;
            }
            case 72: {
                break;
            }
            case 73: {
                break;
            }
            case 74: {
                break;
            }
            case 75: {
                break;
            }
            case 76: {
                break;
            }
            case 77: {
                break;
            }
            case 78: {
                break;
            }
            case 79: {
                break;
            }
            case 80: {
                break;
            }
            case 81: {
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                break;
            }
            case 84: {
                break;
            }
            case 85: {
                break;
            }
            case 86: {
                break;
            }
            case 87: {
                break;
            }
            case 88: {
                break;
            }
            case 89: {
                break;
            }
            case 90: {
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                break;
            }
            case 93: {
                break;
            }
            case 94: {
                break;
            }
            case 95: {
                break;
            }
            case 96: {
                break;
            }
            case 97: {
                break;
            }
            case 98: {
                break;
            }
            case 99: {
                break;
            }
            case 100: {
                break;
            }
            case 101: {
                break;
            }
            case 102: {
                break;
            }
            case 103: {
                break;
            }
            case 104: {
                break;
            }
            case 105: {
                break;
            }
            case 106: {
                break;
            }
            case 107: {
                break;
            }
            case 108: {
                break;
            }
            case 109: {
                break;
            }
            case 110: {
                break;
            }
            case 111: {
                break;
            }
            case 112: {
                break;
            }
            case 113: {
                break;
            }
            case 114: {
                break;
            }
            case 115: {
                break;
            }
            case 116: {
                break;
            }
            case 117: {
                break;
            }
            case 118: {
                break;
            }
            case 119: {
                break;
            }
            case 120: {
                break;
            }
            case 121: {
                break;
            }
            case 122: {
                break;
            }
            case 123: {
                break;
            }
            case 124: {
                break;
            }
            case 125: {
                break;
            }
            case 126: {
                break;
            }
            case 127: {
                break;
            }
            case -128: {
                break;
            }
            case -127: {
                break;
            }
            case -126: {
                break;
            }
            case -125: {
                break;
            }
            case -124: {
                res = String.valueOf(BytecodeDebug.getByteOperand(codes, index + 1)) + " " + BytecodeDebug.getByteOperand(codes, index + 2);
                break;
            }
            case -123: {
                break;
            }
            case -122: {
                break;
            }
            case -121: {
                break;
            }
            case -120: {
                break;
            }
            case -119: {
                break;
            }
            case -118: {
                break;
            }
            case -117: {
                break;
            }
            case -116: {
                break;
            }
            case -115: {
                break;
            }
            case -114: {
                break;
            }
            case -113: {
                break;
            }
            case -112: {
                break;
            }
            case -111: {
                break;
            }
            case -110: {
                break;
            }
            case -109: {
                break;
            }
            case -108: {
                break;
            }
            case -107: {
                break;
            }
            case -106: {
                break;
            }
            case -105: {
                break;
            }
            case -104: {
                break;
            }
            case -103: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -102: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -101: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -100: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -99: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -98: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -97: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -96: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -95: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -94: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -93: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -92: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -91: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -90: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -89: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -88: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -87: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case -86: {
                int db = (index + 4) / 4 * 4;
                int val = BytecodeDebug.fourByteToInt(codes, db);
                res = "defaultbytes:" + val;
                int low = BytecodeDebug.fourByteToInt(codes, db += 4);
                res = String.valueOf(res) + ", low:" + low;
                int high = BytecodeDebug.fourByteToInt(codes, db += 4);
                db += 4;
                res = String.valueOf(res) + ", high:" + high;
                int i = 0;
                while (i < high - low + 1) {
                    res = String.valueOf(res) + "\n\toffset:" + BytecodeDebug.fourByteToInt(codes, db + i * 4);
                    ++i;
                }
                break;
            }
            case -85: {
                int db = (index + 4) / 4 * 4;
                int val = BytecodeDebug.fourByteToInt(codes, db);
                res = "defaultbytes:" + val;
                int npairs = BytecodeDebug.fourByteToInt(codes, db += 4);
                db += 4;
                res = String.valueOf(res) + ", npairs:" + npairs;
                int i = 0;
                while (i < npairs) {
                    res = String.valueOf(res) + "\n\tmatch:" + BytecodeDebug.fourByteToInt(codes, db + i * 8) + ", offset:" + BytecodeDebug.fourByteToInt(codes, db + i * 8 + 4);
                    ++i;
                }
                break;
            }
            case -84: {
                break;
            }
            case -83: {
                break;
            }
            case -82: {
                break;
            }
            case -81: {
                break;
            }
            case -80: {
                break;
            }
            case -79: {
                break;
            }
            case -78: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -77: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -76: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -75: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -74: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -73: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -72: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -71: {
                res = String.valueOf(BytecodeDebug.getCharOperand(codes, index + 1)) + " " + BytecodeDebug.getByteOperand(codes, index + 3);
                break;
            }
            case -69: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -68: {
                res = BytecodeDebug.getByteOperand(codes, index + 1);
                break;
            }
            case -67: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -66: {
                break;
            }
            case -65: {
                break;
            }
            case -64: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -63: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -62: {
                break;
            }
            case -61: {
                break;
            }
            case -60: {
                res = "XXX";
                break;
            }
            case -59: {
                res = String.valueOf(BytecodeDebug.getCharOperand(codes, index + 1)) + " " + BytecodeDebug.getByteOperand(codes, index + 3);
                break;
            }
            case -58: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -57: {
                res = BytecodeDebug.getCharOperand(codes, index + 1);
                break;
            }
            case -56: {
                res = BytecodeDebug.getIntOperand(codes, index + 1);
                break;
            }
            case -55: {
                res = BytecodeDebug.getIntOperand(codes, index + 1);
                break;
            }
            case -54: {
                break;
            }
            case -2: {
                break;
            }
            case -1: {
                break;
            }
            default: {
                res = "<UNKNOWN BYTECODE:" + codes[index] + ">";
            }
        }
        return res;
    }

    public static int fourByteToInt(byte[] codes, int pos) {
        byte b1 = codes[pos + 0];
        byte b2 = codes[pos + 1];
        byte b3 = codes[pos + 2];
        byte b4 = codes[pos + 3];
        int val = b1 << 24 | b2 << 16 | b3 << 8 | b4;
        return val;
    }

    public static int stepBytecode(byte[] codes, int index) {
        int res = 0;
        block0 : switch (codes[index]) {
            case 0: {
                ++res;
                break;
            }
            case 1: {
                ++res;
                break;
            }
            case 19: 
            case 20: {
                res += 3;
                break;
            }
            case 18: {
                res += 2;
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                ++res;
                break;
            }
            case 16: {
                res += 2;
                break;
            }
            case 17: {
                res += 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                ++res;
                break;
            }
            case 46: 
            case 48: 
            case 51: 
            case 52: 
            case 53: {
                ++res;
                break;
            }
            case 47: 
            case 49: {
                ++res;
                break;
            }
            case 50: {
                ++res;
                break;
            }
            case 21: 
            case 23: 
            case 54: 
            case 56: {
                res += 2;
                break;
            }
            case 26: 
            case 34: 
            case 59: 
            case 67: {
                ++res;
                break;
            }
            case 27: 
            case 35: 
            case 60: 
            case 68: {
                ++res;
                break;
            }
            case 28: 
            case 36: 
            case 61: 
            case 69: {
                ++res;
                break;
            }
            case 29: 
            case 37: 
            case 62: 
            case 70: {
                ++res;
                break;
            }
            case 22: 
            case 24: 
            case 55: 
            case 57: {
                res += 2;
                break;
            }
            case 30: 
            case 38: 
            case 63: 
            case 71: {
                ++res;
                break;
            }
            case 31: 
            case 39: 
            case 64: 
            case 72: {
                ++res;
                break;
            }
            case 32: 
            case 40: 
            case 65: 
            case 73: {
                ++res;
                break;
            }
            case 33: 
            case 41: 
            case 66: 
            case 74: {
                ++res;
                break;
            }
            case 25: 
            case 58: {
                res += 2;
                break;
            }
            case 42: 
            case 75: {
                ++res;
                break;
            }
            case 43: 
            case 76: {
                ++res;
                break;
            }
            case 44: 
            case 77: {
                ++res;
                break;
            }
            case 45: 
            case 78: {
                ++res;
                break;
            }
            case 79: 
            case 81: {
                ++res;
                break;
            }
            case 80: 
            case 82: {
                ++res;
                break;
            }
            case 83: {
                ++res;
                break;
            }
            case 84: {
                ++res;
                break;
            }
            case 85: 
            case 86: {
                ++res;
                break;
            }
            case 87: {
                ++res;
                break;
            }
            case 88: {
                ++res;
                break;
            }
            case 89: {
                ++res;
                break;
            }
            case 90: {
                ++res;
                break;
            }
            case 91: {
                ++res;
                break;
            }
            case 92: {
                ++res;
                break;
            }
            case 93: {
                ++res;
                break;
            }
            case 94: {
                ++res;
                break;
            }
            case 95: {
                ++res;
                break;
            }
            case 96: {
                ++res;
                break;
            }
            case 98: {
                ++res;
                break;
            }
            case 99: {
                ++res;
                break;
            }
            case 97: {
                ++res;
                break;
            }
            case 100: {
                ++res;
                break;
            }
            case 102: {
                ++res;
                break;
            }
            case 103: {
                ++res;
                break;
            }
            case 101: {
                ++res;
                break;
            }
            case 104: {
                ++res;
                break;
            }
            case 105: {
                ++res;
                break;
            }
            case 107: {
                ++res;
                break;
            }
            case 106: {
                ++res;
                break;
            }
            case 108: {
                ++res;
                break;
            }
            case 109: {
                ++res;
                break;
            }
            case 111: {
                ++res;
                break;
            }
            case 110: {
                ++res;
                break;
            }
            case 112: {
                ++res;
                break;
            }
            case 113: {
                ++res;
                break;
            }
            case 115: {
                ++res;
                break;
            }
            case 114: {
                ++res;
                break;
            }
            case 116: {
                ++res;
                break;
            }
            case 117: {
                ++res;
                break;
            }
            case 119: {
                ++res;
                break;
            }
            case 118: {
                ++res;
                break;
            }
            case 120: {
                ++res;
                break;
            }
            case 121: {
                ++res;
                break;
            }
            case 122: {
                ++res;
                break;
            }
            case 123: {
                ++res;
                break;
            }
            case 124: {
                ++res;
                break;
            }
            case 125: {
                ++res;
                break;
            }
            case 126: {
                ++res;
                break;
            }
            case 127: {
                ++res;
                break;
            }
            case -128: {
                ++res;
                break;
            }
            case -127: {
                ++res;
                break;
            }
            case -126: {
                ++res;
                break;
            }
            case -125: {
                ++res;
                break;
            }
            case -124: {
                res += 3;
                break;
            }
            case -123: {
                ++res;
                break;
            }
            case -122: {
                ++res;
                break;
            }
            case -121: {
                ++res;
                break;
            }
            case -120: {
                ++res;
                break;
            }
            case -119: {
                ++res;
                break;
            }
            case -118: {
                ++res;
                break;
            }
            case -117: {
                ++res;
                break;
            }
            case -116: {
                ++res;
                break;
            }
            case -115: {
                ++res;
                break;
            }
            case -114: {
                ++res;
                break;
            }
            case -113: {
                ++res;
                break;
            }
            case -112: {
                ++res;
                break;
            }
            case -111: {
                ++res;
                break;
            }
            case -110: {
                ++res;
                break;
            }
            case -109: {
                ++res;
                break;
            }
            case -108: {
                ++res;
                break;
            }
            case -107: {
                ++res;
                break;
            }
            case -106: {
                ++res;
                break;
            }
            case -105: {
                ++res;
                break;
            }
            case -104: {
                ++res;
                break;
            }
            case -103: {
                res += 3;
                break;
            }
            case -102: {
                res += 3;
                break;
            }
            case -101: {
                res += 3;
                break;
            }
            case -100: {
                res += 3;
                break;
            }
            case -99: {
                res += 3;
                break;
            }
            case -98: {
                res += 3;
                break;
            }
            case -97: {
                res += 3;
                break;
            }
            case -96: {
                res += 3;
                break;
            }
            case -95: {
                res += 3;
                break;
            }
            case -94: {
                res += 3;
                break;
            }
            case -93: {
                res += 3;
                break;
            }
            case -92: {
                res += 3;
                break;
            }
            case -91: {
                res += 3;
                break;
            }
            case -90: {
                res += 3;
                break;
            }
            case -89: {
                res += 3;
                break;
            }
            case -88: {
                res += 3;
                break;
            }
            case -87: {
                res += 2;
                break;
            }
            case -86: {
                int db = (index + 4) / 4 * 4;
                int low = BytecodeDebug.fourByteToInt(codes, db += 4);
                int high = BytecodeDebug.fourByteToInt(codes, db += 4);
                db += 4;
                res = db += (high - low + 1) * 4;
                break;
            }
            case -85: {
                int db = (index + 4) / 4 * 4;
                int np = BytecodeDebug.fourByteToInt(codes, db += 4);
                db += 4;
                res = db += np * 8;
                break;
            }
            case -84: 
            case -82: {
                ++res;
                break;
            }
            case -83: 
            case -81: {
                ++res;
                break;
            }
            case -80: {
                ++res;
                break;
            }
            case -79: {
                ++res;
                break;
            }
            case -78: 
            case -77: 
            case -76: 
            case -75: {
                res += 3;
                break;
            }
            case -74: {
                res += 3;
                break;
            }
            case -73: {
                res += 3;
                break;
            }
            case -72: {
                res += 3;
                break;
            }
            case -71: {
                res += 5;
                break;
            }
            case -69: {
                res += 3;
                break;
            }
            case -68: {
                res += 2;
                break;
            }
            case -67: {
                res += 3;
                break;
            }
            case -66: {
                ++res;
                break;
            }
            case -65: {
                ++res;
                break;
            }
            case -64: {
                res += 3;
                break;
            }
            case -63: {
                res += 3;
                break;
            }
            case -62: {
                ++res;
                break;
            }
            case -61: {
                ++res;
                break;
            }
            case -60: {
                switch (codes[index + 1]) {
                    case 21: {
                        res += 4;
                        break block0;
                    }
                    case 23: {
                        res += 4;
                        break block0;
                    }
                    case 25: {
                        res += 4;
                        break block0;
                    }
                    case 22: {
                        res += 4;
                        break block0;
                    }
                    case 24: {
                        res += 4;
                        break block0;
                    }
                    case 54: {
                        res += 4;
                        break block0;
                    }
                    case 56: {
                        res += 4;
                        break block0;
                    }
                    case 58: {
                        res += 4;
                        break block0;
                    }
                    case 55: {
                        res += 4;
                        break block0;
                    }
                    case 57: {
                        res += 4;
                        break block0;
                    }
                    case -87: {
                        res += 4;
                        break block0;
                    }
                    case -124: {
                        res += 6;
                        break block0;
                    }
                }
                System.err.println("ERROR_INVALID_OPCODE in stepBytecode (wide)");
                break;
            }
            case -59: {
                res += 4;
                break;
            }
            case -58: {
                res += 3;
                break;
            }
            case -57: {
                res += 3;
                break;
            }
            case -56: {
                res += 5;
                break;
            }
            case -55: {
                res += 5;
                break;
            }
            default: {
                ++res;
                System.err.println("INVALID BYTECODE " + codes[index] + " IN stepBytecode");
            }
        }
        return res;
    }

    public static void printBytecode(PrintStream p, byte[] codes, int index) {
        p.print(String.valueOf(BytecodeDebug.toString(codes[index])) + " " + BytecodeDebug.getOperands(codes, index));
    }

    public static void printBytecodes(PrintStream p, byte[] codes) {
        int i = 0;
        int cnt = 1;
        while (i < codes.length) {
            p.print("\t" + i + "\t" + cnt + "\t");
            BytecodeDebug.printBytecode(p, codes, i);
            p.println();
            i += BytecodeDebug.stepBytecode(codes, i);
            ++cnt;
        }
    }

    public static void appendBytecodes(StringBuffer p, byte[] codes) {
        int i = 0;
        int cnt = 1;
        while (i < codes.length) {
            p.append(" " + i + " " + cnt + "\t");
            p.append(String.valueOf(BytecodeDebug.toString(codes[i])) + " " + BytecodeDebug.getOperands(codes, i));
            p.append("\n");
            i += BytecodeDebug.stepBytecode(codes, i);
            ++cnt;
        }
    }
}

