/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Access;
import AST.CodeGeneration;
import AST.Constant;
import AST.Expr;
import AST.Literal;
import AST.NameType;
import AST.TypeDecl;
import AST.Variable;
import jpe.Environment;

public class CastExpr
extends Expr
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public CastExpr clone() throws CloneNotSupportedException {
        CastExpr node = (CastExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public CastExpr copy() {
        try {
            CastExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public CastExpr fullCopy() {
        CastExpr res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("(");
        this.getTypeAccess().toString(s);
        s.append(")");
        this.getExpr().toString(s);
    }

    @Override
    public void typeCheck() {
        TypeDecl expr = this.getExpr().type();
        TypeDecl type = this.getTypeAccess().type();
        if (!expr.isUnknown()) {
            if (!expr.castingConversionTo(type)) {
                this.error(String.valueOf(expr.typeName()) + " can not be cast into " + type.typeName());
            }
            if (!this.getTypeAccess().isTypeAccess()) {
                this.error(this.getTypeAccess() + " is not a type access in cast expression");
            }
        }
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        this.getExpr().createBCode(gen);
        this.getExpr().type().emitCastTo(gen, this.type());
    }

    public CastExpr() {
    }

    public CastExpr(Access p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setTypeAccess(Access node) {
        this.setChild(node, 0);
    }

    public Access getTypeAccess() {
        return (Access)this.getChild(0);
    }

    public Access getTypeAccessNoTransform() {
        return (Access)this.getChildNoTransform(0);
    }

    public void setExpr(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(1);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        Constant constant_value = this.constant_compute();
        return constant_value;
    }

    private Constant constant_compute() {
        return this.type().cast(this.getExpr().constant());
    }

    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        boolean isConstant_value = this.isConstant_compute();
        return isConstant_value;
    }

    private boolean isConstant_compute() {
        return this.getExpr().isConstant() && (this.getTypeAccess().type().isPrimitive() || this.getTypeAccess().type().isString());
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getExpr().isDAafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getExpr().isDUafter(v);
    }

    @Override
    public boolean isSuperAccess() {
        ASTNode$State state = this.state();
        boolean isSuperAccess_value = this.isSuperAccess_compute();
        return isSuperAccess_value;
    }

    private boolean isSuperAccess_compute() {
        return this.getExpr().isSuperAccess();
    }

    @Override
    public boolean isThisAccess() {
        ASTNode$State state = this.state();
        boolean isThisAccess_value = this.isThisAccess_compute();
        return isThisAccess_value;
    }

    private boolean isThisAccess_compute() {
        return this.getExpr().isThisAccess();
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getTypeAccess().type();
    }

    @Override
    public boolean staticContextQualifier() {
        ASTNode$State state = this.state();
        boolean staticContextQualifier_value = this.staticContextQualifier_compute();
        return staticContextQualifier_value;
    }

    private boolean staticContextQualifier_compute() {
        return this.getExpr().staticContextQualifier();
    }

    @Override
    public Expr pe(Environment env) {
        ASTNode$State state = this.state();
        Expr pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private Expr pe_compute(Environment env) {
        CastExpr ce = this.fullCopy();
        Expr e = this.getExpr().pe(env);
        if (e instanceof Literal) {
            return e;
        }
        ce.setExpr(e);
        return ce;
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeAccessNoTransform()) {
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

