/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.CodeGeneration;
import AST.Constant;
import AST.Literal;
import AST.TypeDecl;
import beaver.Symbol;

public class CharacterLiteral
extends Literal
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.constant_computed = false;
        this.constant_value = null;
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public CharacterLiteral clone() throws CloneNotSupportedException {
        CharacterLiteral node = (CharacterLiteral)super.clone();
        node.constant_computed = false;
        node.constant_value = null;
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public CharacterLiteral copy() {
        try {
            CharacterLiteral node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public CharacterLiteral fullCopy() {
        CharacterLiteral res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("'" + CharacterLiteral.escape(this.getLITERAL()) + "'");
    }

    @Override
    public void emitPushConstant(CodeGeneration gen) {
        this.type().emitPushConstant(gen, this.constant().intValue());
    }

    public CharacterLiteral() {
    }

    public CharacterLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public CharacterLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    @Override
    public void setLITERAL(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol.value;
        this.LITERALstart = symbol.getStart();
        this.LITERALend = symbol.getEnd();
    }

    @Override
    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        return Constant.create(this.getLITERAL().charAt(0));
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeChar();
    }

    @Override
    public Object literalValueObject() {
        ASTNode$State state = this.state();
        Object literalValueObject_value = this.literalValueObject_compute();
        return literalValueObject_value;
    }

    private Object literalValueObject_compute() {
        return new Character((char)this.constant().intValue());
    }

    @Override
    public Class<?> literalValueClass() {
        ASTNode$State state = this.state();
        Class<?> literalValueClass_value = this.literalValueClass_compute();
        return literalValueClass_value;
    }

    private Class<?> literalValueClass_compute() {
        return Character.TYPE;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

