/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Access;
import AST.CodeGeneration;
import AST.FieldDeclaration;
import AST.GenericClassDecl;
import AST.MethodDecl;
import AST.NameType;
import AST.SimpleSet;
import AST.StringLiteral;
import AST.TypeDecl;
import java.util.ArrayList;

public class ClassAccess
extends Access
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ClassAccess clone() throws CloneNotSupportedException {
        ClassAccess node = (ClassAccess)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ClassAccess copy() {
        try {
            ClassAccess node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ClassAccess fullCopy() {
        ClassAccess res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void nameCheck() {
        if (this.isQualified() && !this.qualifier().isTypeAccess()) {
            this.error("class literal may only contain type names");
        }
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("class");
    }

    public void refined_CreateBCode_ClassAccess_createBCode(CodeGeneration gen) {
        if (this.prevExpr().type().isPrimitiveType() || this.prevExpr().type().isVoid()) {
            TypeDecl typeDecl = this.lookupType("java.lang", this.prevExpr().type().primitiveClassName());
            SimpleSet c = typeDecl.memberFields("TYPE");
            FieldDeclaration f = (FieldDeclaration)c.iterator().next();
            f.emitLoadField(gen, typeDecl);
        } else {
            FieldDeclaration f = this.hostType().topLevelType().createStaticClassField(this.prevExpr().type().referenceClassFieldName());
            MethodDecl m = this.hostType().topLevelType().createStaticClassMethod();
            int next_label = this.hostType().constantPool().newLabel();
            int end_label = this.hostType().constantPool().newLabel();
            f.emitLoadField(gen, this.hostType());
            gen.emitBranchNonNull(next_label);
            StringLiteral.push(gen, this.prevExpr().type().jvmName());
            m.emitInvokeMethod(gen, this.hostType());
            gen.emitDup();
            f.emitStoreField(gen, this.hostType());
            gen.emitGoto(end_label);
            gen.addLabel(next_label);
            gen.changeStackDepth(-1);
            f.emitLoadField(gen, this.hostType());
            gen.addLabel(end_label);
        }
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        if (this.prevExpr().type().isPrimitiveType() || this.prevExpr().type().isVoid()) {
            this.refined_CreateBCode_ClassAccess_createBCode(gen);
        } else {
            int index = gen.constantPool().addClass(this.prevExpr().type().jvmName());
            if (index < 256) {
                gen.emit((byte)18).add(index);
            } else {
                gen.emit((byte)19).add2(index);
            }
        }
    }

    @Override
    public void transformation() {
        super.transformation();
    }

    private TypeDecl refined_TypeAnalysis_ClassAccess_type() {
        return this.lookupType("java.lang", "Class");
    }

    @Override
    public boolean isClassAccess() {
        ASTNode$State state = this.state();
        boolean isClassAccess_value = this.isClassAccess_compute();
        return isClassAccess_value;
    }

    private boolean isClassAccess_compute() {
        return true;
    }

    @Override
    public NameType predNameType() {
        ASTNode$State state = this.state();
        NameType predNameType_value = this.predNameType_compute();
        return predNameType_value;
    }

    private NameType predNameType_compute() {
        return NameType.TYPE_NAME;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        GenericClassDecl d = (GenericClassDecl)this.refined_TypeAnalysis_ClassAccess_type();
        TypeDecl type = this.qualifier().type();
        if (type.isPrimitive()) {
            type = type.boxed();
        }
        ArrayList<TypeDecl> list = new ArrayList<TypeDecl>();
        list.add(type);
        return d.lookupParTypeDecl(list);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

