/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.CodeGeneration;
import AST.Constant;
import AST.Expr;
import AST.TypeDecl;
import AST.Variable;
import java.util.ArrayList;
import jpe.Environment;

public class ConditionalExpr
extends Expr
implements Cloneable {
    protected boolean constant_computed = false;
    protected Constant constant_value;
    protected boolean isConstant_computed = false;
    protected boolean isConstant_value;
    protected boolean booleanOperator_computed = false;
    protected boolean booleanOperator_value;
    protected boolean type_computed = false;
    protected TypeDecl type_value;
    protected boolean else_branch_label_computed = false;
    protected int else_branch_label_value;
    protected boolean then_branch_label_computed = false;
    protected int then_branch_label_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.constant_computed = false;
        this.constant_value = null;
        this.isConstant_computed = false;
        this.booleanOperator_computed = false;
        this.type_computed = false;
        this.type_value = null;
        this.else_branch_label_computed = false;
        this.then_branch_label_computed = false;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ConditionalExpr clone() throws CloneNotSupportedException {
        ConditionalExpr node = (ConditionalExpr)super.clone();
        node.constant_computed = false;
        node.constant_value = null;
        node.isConstant_computed = false;
        node.booleanOperator_computed = false;
        node.type_computed = false;
        node.type_value = null;
        node.else_branch_label_computed = false;
        node.then_branch_label_computed = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ConditionalExpr copy() {
        try {
            ConditionalExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ConditionalExpr fullCopy() {
        ConditionalExpr res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        this.getCondition().toString(s);
        s.append(" ? ");
        this.getTrueExpr().toString(s);
        s.append(" : ");
        this.getFalseExpr().toString(s);
    }

    @Override
    public void typeCheck() {
        if (!this.getCondition().type().isBoolean()) {
            this.error("*** First expression must be a boolean in conditional operator");
        }
        if (this.type().isUnknown() && !this.getTrueExpr().type().isUnknown() && !this.getFalseExpr().type().isUnknown()) {
            this.error("*** Operands in conditional operator does not match");
        }
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        if (this.type().isBoolean()) {
            this.emitBooleanCondition(gen);
        } else {
            int endBranch = this.hostType().constantPool().newLabel();
            this.getCondition().emitEvalBranch(gen);
            if (this.getCondition().canBeTrue()) {
                gen.addLabel(this.then_branch_label());
                this.getTrueExpr().createBCode(gen);
                this.getTrueExpr().type().emitCastTo(gen, this.type());
                if (this.getCondition().canBeFalse()) {
                    gen.changeStackDepth(-this.type().variableSize());
                    gen.emitGoto(endBranch);
                }
            }
            if (this.getCondition().canBeFalse()) {
                gen.addLabel(this.else_branch_label());
                this.getFalseExpr().createBCode(gen);
                this.getFalseExpr().type().emitCastTo(gen, this.type());
            }
            gen.addLabel(endBranch);
        }
    }

    @Override
    public void emitEvalBranch(CodeGeneration gen) {
        int endBranch = this.hostType().constantPool().newLabel();
        this.getCondition().emitEvalBranch(gen);
        gen.addLabel(this.then_branch_label());
        if (this.getCondition().canBeTrue()) {
            this.getTrueExpr().emitEvalBranch(gen);
            gen.emitGoto(this.true_label());
        }
        gen.addLabel(this.else_branch_label());
        if (this.getCondition().canBeFalse()) {
            this.getFalseExpr().emitEvalBranch(gen);
            gen.emitGoto(this.true_label());
        }
    }

    @Override
    public void emitBooleanCondition(CodeGeneration gen) {
        super.emitBooleanCondition(gen);
        if (this.type().isReferenceType()) {
            this.type().emitBoxingOperation(gen);
        }
    }

    public ConditionalExpr() {
    }

    public ConditionalExpr(Expr p0, Expr p1, Expr p2) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
        this.setChild(p2, 2);
    }

    @Override
    protected int numChildren() {
        return 3;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setCondition(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getCondition() {
        return (Expr)this.getChild(0);
    }

    public Expr getConditionNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setTrueExpr(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getTrueExpr() {
        return (Expr)this.getChild(1);
    }

    public Expr getTrueExprNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    public void setFalseExpr(Expr node) {
        this.setChild(node, 2);
    }

    public Expr getFalseExpr() {
        return (Expr)this.getChild(2);
    }

    public Expr getFalseExprNoTransform() {
        return (Expr)this.getChildNoTransform(2);
    }

    private TypeDecl refined_TypeAnalysis_ConditionalExpr_type() {
        TypeDecl falseType;
        TypeDecl trueType = this.getTrueExpr().type();
        if (trueType == (falseType = this.getFalseExpr().type())) {
            return trueType;
        }
        if (trueType.isNumericType() && falseType.isNumericType()) {
            if (trueType.isByte() && falseType.isShort()) {
                return falseType;
            }
            if (trueType.isShort() && falseType.isByte()) {
                return trueType;
            }
            if ((trueType.isByte() || trueType.isShort() || trueType.isChar()) && falseType.isInt() && this.getFalseExpr().isConstant() && this.getFalseExpr().representableIn(trueType)) {
                return trueType;
            }
            if ((falseType.isByte() || falseType.isShort() || falseType.isChar()) && trueType.isInt() && this.getTrueExpr().isConstant() && this.getTrueExpr().representableIn(falseType)) {
                return falseType;
            }
            return trueType.binaryNumericPromotion(falseType);
        }
        if (trueType.isBoolean() && falseType.isBoolean()) {
            return trueType;
        }
        if (trueType.isReferenceType() && falseType.isNull()) {
            return trueType;
        }
        if (trueType.isNull() && falseType.isReferenceType()) {
            return falseType;
        }
        if (trueType.isReferenceType() && falseType.isReferenceType()) {
            if (trueType.assignConversionTo(falseType, null)) {
                return falseType;
            }
            if (falseType.assignConversionTo(trueType, null)) {
                return trueType;
            }
            return this.unknownType();
        }
        return this.unknownType();
    }

    private TypeDecl refined_AutoBoxing_ConditionalExpr_type() {
        TypeDecl trueType = this.getTrueExpr().type();
        TypeDecl falseType = this.getFalseExpr().type();
        if (trueType.isBoolean() && falseType.isBoolean()) {
            if (trueType == falseType) {
                return trueType;
            }
            if (trueType.isReferenceType()) {
                return trueType.unboxed();
            }
            return trueType;
        }
        return this.refined_TypeAnalysis_ConditionalExpr_type();
    }

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        return this.type().questionColon(this.getCondition().constant(), this.getTrueExpr().constant(), this.getFalseExpr().constant());
    }

    @Override
    public boolean isConstant() {
        if (this.isConstant_computed) {
            return this.isConstant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isConstant_value = this.isConstant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isConstant_computed = true;
        }
        return this.isConstant_value;
    }

    private boolean isConstant_compute() {
        return this.getCondition().isConstant() && this.getTrueExpr().isConstant() && this.getFalseExpr().isConstant();
    }

    public boolean booleanOperator() {
        if (this.booleanOperator_computed) {
            return this.booleanOperator_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.booleanOperator_value = this.booleanOperator_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.booleanOperator_computed = true;
        }
        return this.booleanOperator_value;
    }

    private boolean booleanOperator_compute() {
        return this.getTrueExpr().type().isBoolean() && this.getFalseExpr().type().isBoolean();
    }

    @Override
    public boolean isDAafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafterTrue_Variable_value = this.isDAafterTrue_compute(v);
        return isDAafterTrue_Variable_value;
    }

    private boolean isDAafterTrue_compute(Variable v) {
        return this.getTrueExpr().isDAafterTrue(v) && this.getFalseExpr().isDAafterTrue(v) || this.isFalse();
    }

    @Override
    public boolean isDAafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafterFalse_Variable_value = this.isDAafterFalse_compute(v);
        return isDAafterFalse_Variable_value;
    }

    private boolean isDAafterFalse_compute(Variable v) {
        return this.getTrueExpr().isDAafterFalse(v) && this.getFalseExpr().isDAafterFalse(v) || this.isTrue();
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.booleanOperator() ? this.isDAafterTrue(v) && this.isDAafterFalse(v) : this.getTrueExpr().isDAafter(v) && this.getFalseExpr().isDAafter(v);
    }

    @Override
    public boolean isDUafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafterTrue_Variable_value = this.isDUafterTrue_compute(v);
        return isDUafterTrue_Variable_value;
    }

    private boolean isDUafterTrue_compute(Variable v) {
        return this.getTrueExpr().isDUafterTrue(v) && this.getFalseExpr().isDUafterTrue(v);
    }

    @Override
    public boolean isDUafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafterFalse_Variable_value = this.isDUafterFalse_compute(v);
        return isDUafterFalse_Variable_value;
    }

    private boolean isDUafterFalse_compute(Variable v) {
        return this.getTrueExpr().isDUafterFalse(v) && this.getFalseExpr().isDUafterFalse(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.booleanOperator() ? this.isDUafterTrue(v) && this.isDUafterFalse(v) : this.getTrueExpr().isDUafter(v) && this.getFalseExpr().isDUafter(v);
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        TypeDecl type = this.refined_AutoBoxing_ConditionalExpr_type();
        TypeDecl trueType = this.getTrueExpr().type();
        TypeDecl falseType = this.getFalseExpr().type();
        if (type.isUnknown() && (trueType.isReferenceType() || falseType.isReferenceType())) {
            if (!trueType.isReferenceType() && !trueType.boxed().isUnknown()) {
                trueType = trueType.boxed();
            }
            if (!falseType.isReferenceType() && !falseType.boxed().isUnknown()) {
                falseType = falseType.boxed();
            }
            if (trueType.isReferenceType() && falseType.isReferenceType()) {
                ArrayList<TypeDecl> list = new ArrayList<TypeDecl>();
                list.add(trueType);
                list.add(falseType);
                return type.lookupLUBType(list);
            }
        }
        return type;
    }

    @Override
    public boolean definesLabel() {
        ASTNode$State state = this.state();
        boolean definesLabel_value = this.definesLabel_compute();
        return definesLabel_value;
    }

    private boolean definesLabel_compute() {
        return true;
    }

    @Override
    public boolean canBeTrue() {
        ASTNode$State state = this.state();
        boolean canBeTrue_value = this.canBeTrue_compute();
        return canBeTrue_value;
    }

    private boolean canBeTrue_compute() {
        return this.type().isBoolean() && (this.getTrueExpr().canBeTrue() && this.getFalseExpr().canBeTrue() || this.getCondition().isTrue() && this.getTrueExpr().canBeTrue() || this.getCondition().isFalse() && this.getFalseExpr().canBeTrue());
    }

    @Override
    public boolean canBeFalse() {
        ASTNode$State state = this.state();
        boolean canBeFalse_value = this.canBeFalse_compute();
        return canBeFalse_value;
    }

    private boolean canBeFalse_compute() {
        return this.type().isBoolean() && (this.getTrueExpr().canBeFalse() && this.getFalseExpr().canBeFalse() || this.getCondition().isTrue() && this.getTrueExpr().canBeFalse() || this.getCondition().isFalse() && this.getFalseExpr().canBeFalse());
    }

    public int else_branch_label() {
        if (this.else_branch_label_computed) {
            return this.else_branch_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.else_branch_label_value = this.else_branch_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.else_branch_label_computed = true;
        }
        return this.else_branch_label_value;
    }

    private int else_branch_label_compute() {
        return this.hostType().constantPool().newLabel();
    }

    public int then_branch_label() {
        if (this.then_branch_label_computed) {
            return this.then_branch_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.then_branch_label_value = this.then_branch_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.then_branch_label_computed = true;
        }
        return this.then_branch_label_value;
    }

    private int then_branch_label_compute() {
        return this.hostType().constantPool().newLabel();
    }

    @Override
    public Expr pe(Environment env) {
        ASTNode$State state = this.state();
        Expr pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private Expr pe_compute(Environment env) {
        ConditionalExpr ce = this.fullCopy();
        ce.setCondition(this.getCondition().pe(env));
        ce.setTrueExpr(this.getTrueExpr().pe(env));
        ce.setFalseExpr(this.getFalseExpr().pe(env));
        return ce;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getFalseExprNoTransform()) {
            return this.getCondition().isDAafterFalse(v);
        }
        if (caller == this.getTrueExprNoTransform()) {
            return this.getCondition().isDAafterTrue(v);
        }
        if (caller == this.getConditionNoTransform()) {
            return this.isDAbefore(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getFalseExprNoTransform()) {
            return this.getCondition().isDUafterFalse(v);
        }
        if (caller == this.getTrueExprNoTransform()) {
            return this.getCondition().isDUafterTrue(v);
        }
        if (caller == this.getConditionNoTransform()) {
            return this.isDUbefore(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public int Define_int_condition_false_label(ASTNode caller, ASTNode child) {
        if (caller == this.getFalseExprNoTransform()) {
            return this.false_label();
        }
        if (caller == this.getTrueExprNoTransform()) {
            return this.false_label();
        }
        if (caller == this.getConditionNoTransform()) {
            return this.else_branch_label();
        }
        return this.getParent().Define_int_condition_false_label(this, caller);
    }

    @Override
    public int Define_int_condition_true_label(ASTNode caller, ASTNode child) {
        if (caller == this.getFalseExprNoTransform()) {
            return this.true_label();
        }
        if (caller == this.getTrueExprNoTransform()) {
            return this.true_label();
        }
        if (caller == this.getConditionNoTransform()) {
            return this.then_branch_label();
        }
        return this.getParent().Define_int_condition_true_label(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

