/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Annotation;
import AST.Attribute;
import AST.ElementValue;
import AST.EnumConstant;
import AST.Expr;
import AST.NameType;
import AST.TypeDecl;
import AST.Variable;

public class ElementConstantValue
extends ElementValue
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ElementConstantValue clone() throws CloneNotSupportedException {
        ElementConstantValue node = (ElementConstantValue)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ElementConstantValue copy() {
        try {
            ElementConstantValue node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ElementConstantValue fullCopy() {
        ElementConstantValue res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void nameCheck() {
        Variable v;
        if (this.enclosingAnnotationDecl().fullName().equals("java.lang.annotation.Target") && (v = this.getExpr().varDecl()) != null && v.hostType().fullName().equals("java.lang.annotation.ElementType") && this.lookupElementTypeValue(v.name()) != this) {
            this.error("repeated annotation target");
        }
    }

    @Override
    public void toString(StringBuffer s) {
        this.getExpr().toString(s);
    }

    @Override
    public void appendAsAttributeTo(Attribute buf) {
        if (this.getExpr().isConstant() && !this.getExpr().type().isEnumDecl()) {
            int tag = this.getExpr().type().isString() ? 115 : (int)this.getExpr().type().typeDescriptor().charAt(0);
            int const_value_index = this.getExpr().type().addConstant(this.hostType().constantPool(), this.getExpr().constant());
            buf.u1(tag);
            buf.u2(const_value_index);
        } else if (this.getExpr().isClassAccess()) {
            int const_class_index = this.hostType().constantPool().addUtf8(this.getExpr().type().typeDescriptor());
            buf.u1(99);
            buf.u2(const_class_index);
        } else {
            Variable v = this.getExpr().varDecl();
            if (v == null) {
                throw new Error("Expected Enumeration constant");
            }
            int type_name_index = this.hostType().constantPool().addUtf8(v.type().typeDescriptor());
            int const_name_index = this.hostType().constantPool().addUtf8(v.name());
            buf.u1(101);
            buf.u2(type_name_index);
            buf.u2(const_name_index);
        }
    }

    public ElementConstantValue() {
    }

    public ElementConstantValue(Expr p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setExpr(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(0);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public boolean validTarget(Annotation a) {
        ASTNode$State state = this.state();
        boolean validTarget_Annotation_value = this.validTarget_compute(a);
        return validTarget_Annotation_value;
    }

    private boolean validTarget_compute(Annotation a) {
        Variable v = this.getExpr().varDecl();
        if (v == null) {
            return true;
        }
        return v.hostType().fullName().equals("java.lang.annotation.ElementType") && a.mayUseAnnotationTarget(v.name());
    }

    @Override
    public ElementValue definesElementTypeValue(String name) {
        ASTNode$State state = this.state();
        ElementValue definesElementTypeValue_String_value = this.definesElementTypeValue_compute(name);
        return definesElementTypeValue_String_value;
    }

    private ElementValue definesElementTypeValue_compute(String name) {
        Variable v = this.getExpr().varDecl();
        if (v != null && v.hostType().fullName().equals("java.lang.annotation.ElementType") && v.name().equals(name)) {
            return this;
        }
        return null;
    }

    @Override
    public boolean hasValue(String s) {
        ASTNode$State state = this.state();
        boolean hasValue_String_value = this.hasValue_compute(s);
        return hasValue_String_value;
    }

    private boolean hasValue_compute(String s) {
        return this.getExpr().type().isString() && this.getExpr().isConstant() && this.getExpr().constant().stringValue().equals(s);
    }

    @Override
    public boolean commensurateWithTypeDecl(TypeDecl type) {
        ASTNode$State state = this.state();
        boolean commensurateWithTypeDecl_TypeDecl_value = this.commensurateWithTypeDecl_compute(type);
        return commensurateWithTypeDecl_TypeDecl_value;
    }

    private boolean commensurateWithTypeDecl_compute(TypeDecl type) {
        Expr v = this.getExpr();
        if (!v.type().assignConversionTo(type, v)) {
            return false;
        }
        if ((type.isPrimitive() || type.isString()) && !v.isConstant()) {
            return false;
        }
        if (v.type().isNull()) {
            return false;
        }
        if (type.fullName().equals("java.lang.Class") && !v.isClassAccess()) {
            return false;
        }
        return !type.isEnumDecl() || v.varDecl() != null && v.varDecl() instanceof EnumConstant;
    }

    @Override
    public TypeDecl type() {
        ASTNode$State state = this.state();
        TypeDecl type_value = this.type_compute();
        return type_value;
    }

    private TypeDecl type_compute() {
        return this.getExpr().type();
    }

    public ElementValue lookupElementTypeValue(String name) {
        ASTNode$State state = this.state();
        ElementValue lookupElementTypeValue_String_value = this.getParent().Define_ElementValue_lookupElementTypeValue(this, null, name);
        return lookupElementTypeValue_String_value;
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return NameType.AMBIGUOUS_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public String Define_String_methodHost(ASTNode caller, ASTNode child) {
        if (caller == this.getExprNoTransform()) {
            return this.enclosingAnnotationDecl().typeName();
        }
        return this.getParent().Define_String_methodHost(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

