/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.ElementArrayValue;
import AST.ElementConstantValue;
import AST.ElementValue;
import AST.List;
import AST.MethodDecl;
import AST.TypeDecl;
import beaver.Symbol;
import java.util.Iterator;

public class ElementValuePair
extends ASTNode<ASTNode>
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ElementValuePair clone() throws CloneNotSupportedException {
        ElementValuePair node = (ElementValuePair)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ElementValuePair copy() {
        try {
            ElementValuePair node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ElementValuePair fullCopy() {
        ElementValuePair res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void typeCheck() {
        if (!this.type().commensurateWith(this.getElementValue())) {
            this.error(String.valueOf(this.type().typeName()) + " is not commensurate with " + this.getElementValue().type().typeName());
        }
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(String.valueOf(this.getName()) + " = ");
        this.getElementValue().toString(s);
    }

    public ElementValuePair() {
    }

    public ElementValuePair(String p0, ElementValue p1) {
        this.setName(p0);
        this.setChild(p1, 0);
    }

    public ElementValuePair(Symbol p0, ElementValue p1) {
        this.setName(p0);
        this.setChild(p1, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setElementValue(ElementValue node) {
        this.setChild(node, 0);
    }

    public ElementValue getElementValue() {
        return (ElementValue)this.getChild(0);
    }

    public ElementValue getElementValueNoTransform() {
        return (ElementValue)this.getChildNoTransform(0);
    }

    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        Iterator iter = this.enclosingAnnotationDecl().memberMethods(this.getName()).iterator();
        if (iter.hasNext()) {
            MethodDecl m = (MethodDecl)iter.next();
            return m.type();
        }
        return this.unknownType();
    }

    public TypeDecl unknownType() {
        ASTNode$State state = this.state();
        TypeDecl unknownType_value = this.getParent().Define_TypeDecl_unknownType(this, null);
        return unknownType_value;
    }

    public TypeDecl enclosingAnnotationDecl() {
        ASTNode$State state = this.state();
        TypeDecl enclosingAnnotationDecl_value = this.getParent().Define_TypeDecl_enclosingAnnotationDecl(this, null);
        return enclosingAnnotationDecl_value;
    }

    @Override
    public ASTNode rewriteTo() {
        if (this.type().isArrayDecl() && this.getElementValue() instanceof ElementConstantValue) {
            ++this.state().duringAnnotations;
            ElementValuePair result = this.rewriteRule0();
            --this.state().duringAnnotations;
            return result;
        }
        return super.rewriteTo();
    }

    private ElementValuePair rewriteRule0() {
        this.setElementValue(new ElementArrayValue(new List<ElementValue>().add(this.getElementValue())));
        return this;
    }
}

