/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Access;
import AST.BodyDecl;
import AST.CodeGeneration;
import AST.Constant;
import AST.ConstantPool;
import AST.Expr;
import AST.FloatingPointLiteral;
import AST.FloatingPointType;
import AST.List;
import AST.Literal;
import AST.Modifiers;
import AST.Opt;
import AST.TypeDecl;
import beaver.Symbol;

public class FloatType
extends FloatingPointType
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
        this.typeDescriptor_computed = false;
        this.typeDescriptor_value = null;
        this.jvmName_computed = false;
        this.jvmName_value = null;
        this.boxed_computed = false;
        this.boxed_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public FloatType clone() throws CloneNotSupportedException {
        FloatType node = (FloatType)super.clone();
        node.typeDescriptor_computed = false;
        node.typeDescriptor_value = null;
        node.jvmName_computed = false;
        node.jvmName_value = null;
        node.boxed_computed = false;
        node.boxed_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public FloatType copy() {
        try {
            FloatType node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    @Override
    public FloatType fullCopy() {
        FloatType res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("float");
    }

    @Override
    public int addConstant(ConstantPool p, Constant c) {
        return p.addConstant(c.floatValue());
    }

    @Override
    public void emitPushConstant(CodeGeneration gen, int value) {
        FloatingPointLiteral.push(gen, value);
    }

    @Override
    public void emitReturn(CodeGeneration gen) {
        gen.emit((byte)-82);
    }

    @Override
    public void emitLoadLocal(CodeGeneration gen, int pos) {
        gen.maxLocals = Math.max(gen.maxLocals, pos + 1);
        if (pos == 0) {
            gen.emit((byte)34);
        } else if (pos == 1) {
            gen.emit((byte)35);
        } else if (pos == 2) {
            gen.emit((byte)36);
        } else if (pos == 3) {
            gen.emit((byte)37);
        } else if (pos < 256) {
            gen.emit((byte)23).add(pos);
        } else {
            gen.emit((byte)-60).emit((byte)23).add2(pos);
        }
    }

    @Override
    public void emitStoreLocal(CodeGeneration gen, int pos) {
        gen.maxLocals = Math.max(gen.maxLocals, pos + 1);
        if (pos == 0) {
            gen.emit((byte)67);
        } else if (pos == 1) {
            gen.emit((byte)68);
        } else if (pos == 2) {
            gen.emit((byte)69);
        } else if (pos == 3) {
            gen.emit((byte)70);
        } else if (pos < 256) {
            gen.emit((byte)56).add(pos);
        } else {
            gen.emit((byte)-60).emit((byte)56).add2(pos);
        }
    }

    @Override
    void emitCastTo(CodeGeneration gen, TypeDecl type) {
        type.floatToThis(gen);
    }

    @Override
    void intToThis(CodeGeneration gen) {
        gen.emit((byte)-122);
    }

    @Override
    void floatToThis(CodeGeneration gen) {
    }

    @Override
    void doubleToThis(CodeGeneration gen) {
        gen.emit((byte)-112);
    }

    @Override
    void longToThis(CodeGeneration gen) {
        gen.emit((byte)-119);
    }

    @Override
    void byteToThis(CodeGeneration gen) {
        gen.emit((byte)-122);
    }

    @Override
    void charToThis(CodeGeneration gen) {
        gen.emit((byte)-122);
    }

    @Override
    void shortToThis(CodeGeneration gen) {
        gen.emit((byte)-122);
    }

    @Override
    void neg(CodeGeneration gen) {
        gen.emit((byte)118);
    }

    @Override
    void add(CodeGeneration gen) {
        gen.emit((byte)98);
    }

    @Override
    void sub(CodeGeneration gen) {
        gen.emit((byte)102);
    }

    @Override
    void mul(CodeGeneration gen) {
        gen.emit((byte)106);
    }

    @Override
    void div(CodeGeneration gen) {
        gen.emit((byte)110);
    }

    @Override
    void rem(CodeGeneration gen) {
        gen.emit((byte)114);
    }

    @Override
    public void branchLT(CodeGeneration gen, int label) {
        gen.emit((byte)-106).emitCompare((byte)-101, label);
    }

    @Override
    public void branchLE(CodeGeneration gen, int label) {
        gen.emit((byte)-106).emitCompare((byte)-98, label);
    }

    @Override
    public void branchGE(CodeGeneration gen, int label) {
        gen.emit((byte)-107).emitCompare((byte)-100, label);
    }

    @Override
    public void branchGT(CodeGeneration gen, int label) {
        gen.emit((byte)-107).emitCompare((byte)-99, label);
    }

    @Override
    public void branchEQ(CodeGeneration gen, int label) {
        gen.emit((byte)-107).emitCompare((byte)-103, label);
    }

    @Override
    public void branchNE(CodeGeneration gen, int label) {
        gen.emit((byte)-107).emitCompare((byte)-102, label);
    }

    public FloatType() {
        this.setChild(new Opt(), 1);
        this.setChild(new List(), 2);
    }

    public FloatType(Modifiers p0, String p1, Opt<Access> p2, List<BodyDecl> p3) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
    }

    public FloatType(Modifiers p0, Symbol p1, Opt<Access> p2, List<BodyDecl> p3) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
    }

    @Override
    protected int numChildren() {
        return 3;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setModifiers(Modifiers node) {
        this.setChild(node, 0);
    }

    @Override
    public Modifiers getModifiers() {
        return (Modifiers)this.getChild(0);
    }

    @Override
    public Modifiers getModifiersNoTransform() {
        return (Modifiers)this.getChildNoTransform(0);
    }

    @Override
    public void setID(String value) {
        this.tokenString_ID = value;
    }

    @Override
    public void setID(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol.value;
        this.IDstart = symbol.getStart();
        this.IDend = symbol.getEnd();
    }

    @Override
    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    @Override
    public void setSuperClassAccessOpt(Opt<Access> opt) {
        this.setChild(opt, 1);
    }

    @Override
    public boolean hasSuperClassAccess() {
        return this.getSuperClassAccessOpt().getNumChild() != 0;
    }

    @Override
    public Access getSuperClassAccess() {
        return (Access)this.getSuperClassAccessOpt().getChild(0);
    }

    @Override
    public void setSuperClassAccess(Access node) {
        this.getSuperClassAccessOpt().setChild(node, 0);
    }

    @Override
    public Opt<Access> getSuperClassAccessOpt() {
        return (Opt)this.getChild(1);
    }

    @Override
    public Opt<Access> getSuperClassAccessOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    @Override
    public void setBodyDeclList(List<BodyDecl> list) {
        this.setChild(list, 2);
    }

    @Override
    public int getNumBodyDecl() {
        return this.getBodyDeclList().getNumChild();
    }

    @Override
    public BodyDecl getBodyDecl(int i) {
        return (BodyDecl)this.getBodyDeclList().getChild(i);
    }

    @Override
    public void addBodyDecl(BodyDecl node) {
        List<BodyDecl> list = this.parent == null || state == null ? this.getBodyDeclListNoTransform() : this.getBodyDeclList();
        list.addChild(node);
    }

    @Override
    public void addBodyDeclNoTransform(BodyDecl node) {
        List<BodyDecl> list = this.getBodyDeclListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setBodyDecl(BodyDecl node, int i) {
        List<BodyDecl> list = this.getBodyDeclList();
        list.setChild(node, i);
    }

    @Override
    public List<BodyDecl> getBodyDecls() {
        return this.getBodyDeclList();
    }

    @Override
    public List<BodyDecl> getBodyDeclsNoTransform() {
        return this.getBodyDeclListNoTransform();
    }

    @Override
    public List<BodyDecl> getBodyDeclList() {
        List list = (List)this.getChild(2);
        list.getNumChild();
        return list;
    }

    @Override
    public List<BodyDecl> getBodyDeclListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    @Override
    public Constant cast(Constant c) {
        ASTNode$State state = this.state();
        Constant cast_Constant_value = this.cast_compute(c);
        return cast_Constant_value;
    }

    private Constant cast_compute(Constant c) {
        return Constant.create(c.floatValue());
    }

    @Override
    public Constant plus(Constant c) {
        ASTNode$State state = this.state();
        Constant plus_Constant_value = this.plus_compute(c);
        return plus_Constant_value;
    }

    private Constant plus_compute(Constant c) {
        return c;
    }

    @Override
    public Constant minus(Constant c) {
        ASTNode$State state = this.state();
        Constant minus_Constant_value = this.minus_compute(c);
        return minus_Constant_value;
    }

    private Constant minus_compute(Constant c) {
        return Constant.create(-c.floatValue());
    }

    @Override
    public Constant mul(Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        Constant mul_Constant_Constant_value = this.mul_compute(c1, c2);
        return mul_Constant_Constant_value;
    }

    private Constant mul_compute(Constant c1, Constant c2) {
        return Constant.create(c1.floatValue() * c2.floatValue());
    }

    @Override
    public Constant div(Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        Constant div_Constant_Constant_value = this.div_compute(c1, c2);
        return div_Constant_Constant_value;
    }

    private Constant div_compute(Constant c1, Constant c2) {
        return Constant.create(c1.floatValue() / c2.floatValue());
    }

    @Override
    public Constant mod(Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        Constant mod_Constant_Constant_value = this.mod_compute(c1, c2);
        return mod_Constant_Constant_value;
    }

    private Constant mod_compute(Constant c1, Constant c2) {
        return Constant.create(c1.floatValue() % c2.floatValue());
    }

    @Override
    public Constant add(Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        Constant add_Constant_Constant_value = this.add_compute(c1, c2);
        return add_Constant_Constant_value;
    }

    private Constant add_compute(Constant c1, Constant c2) {
        return Constant.create(c1.floatValue() + c2.floatValue());
    }

    @Override
    public Constant sub(Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        Constant sub_Constant_Constant_value = this.sub_compute(c1, c2);
        return sub_Constant_Constant_value;
    }

    private Constant sub_compute(Constant c1, Constant c2) {
        return Constant.create(c1.floatValue() - c2.floatValue());
    }

    @Override
    public Constant questionColon(Constant cond, Constant c1, Constant c2) {
        ASTNode$State state = this.state();
        Constant questionColon_Constant_Constant_Constant_value = this.questionColon_compute(cond, c1, c2);
        return questionColon_Constant_Constant_Constant_value;
    }

    private Constant questionColon_compute(Constant cond, Constant c1, Constant c2) {
        return Constant.create(cond.booleanValue() ? c1.floatValue() : c2.floatValue());
    }

    @Override
    public boolean eqIsTrue(Expr left, Expr right) {
        ASTNode$State state = this.state();
        boolean eqIsTrue_Expr_Expr_value = this.eqIsTrue_compute(left, right);
        return eqIsTrue_Expr_Expr_value;
    }

    private boolean eqIsTrue_compute(Expr left, Expr right) {
        return left.constant().floatValue() == right.constant().floatValue();
    }

    @Override
    public boolean ltIsTrue(Expr left, Expr right) {
        ASTNode$State state = this.state();
        boolean ltIsTrue_Expr_Expr_value = this.ltIsTrue_compute(left, right);
        return ltIsTrue_Expr_Expr_value;
    }

    private boolean ltIsTrue_compute(Expr left, Expr right) {
        return left.constant().floatValue() < right.constant().floatValue();
    }

    @Override
    public boolean leIsTrue(Expr left, Expr right) {
        ASTNode$State state = this.state();
        boolean leIsTrue_Expr_Expr_value = this.leIsTrue_compute(left, right);
        return leIsTrue_Expr_Expr_value;
    }

    private boolean leIsTrue_compute(Expr left, Expr right) {
        return left.constant().floatValue() <= right.constant().floatValue();
    }

    @Override
    public boolean isFloat() {
        ASTNode$State state = this.state();
        boolean isFloat_value = this.isFloat_compute();
        return isFloat_value;
    }

    private boolean isFloat_compute() {
        return true;
    }

    @Override
    public byte arrayLoad() {
        ASTNode$State state = this.state();
        byte arrayLoad_value = this.arrayLoad_compute();
        return arrayLoad_value;
    }

    private byte arrayLoad_compute() {
        return 48;
    }

    @Override
    public byte arrayStore() {
        ASTNode$State state = this.state();
        byte arrayStore_value = this.arrayStore_compute();
        return arrayStore_value;
    }

    private byte arrayStore_compute() {
        return 81;
    }

    @Override
    public String typeDescriptor() {
        if (this.typeDescriptor_computed) {
            return this.typeDescriptor_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeDescriptor_value = this.typeDescriptor_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeDescriptor_computed = true;
        }
        return this.typeDescriptor_value;
    }

    private String typeDescriptor_compute() {
        return "F";
    }

    @Override
    public int arrayPrimitiveTypeDescriptor() {
        ASTNode$State state = this.state();
        int arrayPrimitiveTypeDescriptor_value = this.arrayPrimitiveTypeDescriptor_compute();
        return arrayPrimitiveTypeDescriptor_value;
    }

    private int arrayPrimitiveTypeDescriptor_compute() {
        return 6;
    }

    @Override
    public String jvmName() {
        if (this.jvmName_computed) {
            return this.jvmName_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.jvmName_value = this.jvmName_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.jvmName_computed = true;
        }
        return this.jvmName_value;
    }

    private String jvmName_compute() {
        return "F";
    }

    @Override
    public String primitiveClassName() {
        ASTNode$State state = this.state();
        String primitiveClassName_value = this.primitiveClassName_compute();
        return primitiveClassName_value;
    }

    private String primitiveClassName_compute() {
        return "Float";
    }

    @Override
    public TypeDecl boxed() {
        if (this.boxed_computed) {
            return this.boxed_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.boxed_value = this.boxed_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.boxed_computed = true;
        }
        return this.boxed_value;
    }

    private TypeDecl boxed_compute() {
        return this.lookupType("java.lang", "Float");
    }

    @Override
    public Literal defaultValue() {
        ASTNode$State state = this.state();
        Literal defaultValue_value = this.defaultValue_compute();
        return defaultValue_value;
    }

    private Literal defaultValue_compute() {
        return new FloatingPointLiteral("0");
    }

    @Override
    public Literal initVal() {
        ASTNode$State state = this.state();
        Literal initVal_value = this.initVal_compute();
        return initVal_value;
    }

    private Literal initVal_compute() {
        return new FloatingPointLiteral("0.0f");
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

