/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.BooleanLiteral;
import AST.CodeGeneration;
import AST.EmptyStmt;
import AST.Expr;
import AST.MethodAccess;
import AST.Opt;
import AST.Stmt;
import AST.TypeDecl;
import AST.Variable;
import java.util.HashMap;
import java.util.Map;
import jpe.Environment;
import jpe.Util;

public class IfStmt
extends Stmt
implements Cloneable {
    protected boolean else_branch_label_computed = false;
    protected int else_branch_label_value;
    protected boolean then_branch_label_computed = false;
    protected int then_branch_label_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
        this.canCompleteNormally_computed = false;
        this.else_branch_label_computed = false;
        this.then_branch_label_computed = false;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public IfStmt clone() throws CloneNotSupportedException {
        IfStmt node = (IfStmt)super.clone();
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.canCompleteNormally_computed = false;
        node.else_branch_label_computed = false;
        node.then_branch_label_computed = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public IfStmt copy() {
        try {
            IfStmt node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public IfStmt fullCopy() {
        IfStmt res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public IfStmt(Expr cond, Stmt thenBranch) {
        this(cond, thenBranch, new Opt<Stmt>());
    }

    public IfStmt(Expr cond, Stmt thenBranch, Stmt elseBranch) {
        this(cond, thenBranch, new Opt<Stmt>(elseBranch));
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.indent());
        s.append("if(");
        this.getCondition().toString(s);
        s.append(") ");
        this.getThen().toString(s);
        if (this.hasElse()) {
            s.append(this.indent());
            s.append("else ");
            this.getElse().toString(s);
        }
    }

    @Override
    public void typeCheck() {
        TypeDecl cond = this.getCondition().type();
        if (!cond.isBoolean()) {
            this.error("the type of \"" + this.getCondition() + "\" is " + cond.name() + " which is not boolean");
        }
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        super.createBCode(gen);
        int elseBranch = this.else_branch_label();
        int thenBranch = this.then_branch_label();
        int endBranch = this.hostType().constantPool().newLabel();
        this.getCondition().emitEvalBranch(gen);
        gen.addLabel(thenBranch);
        this.getThen().createBCode(gen);
        if (this.getThen().canCompleteNormally() && this.hasElse()) {
            gen.emitGoto(endBranch);
        }
        gen.addLabel(elseBranch);
        if (this.hasElse()) {
            this.getElse().createBCode(gen);
        }
        gen.addLabel(endBranch);
    }

    @Override
    public boolean canRemove(Map<String, Boolean> usedVars) {
        Map<String, Boolean> eUsedVars = usedVars;
        if (this.hasElse()) {
            eUsedVars = Util.clone(usedVars);
        }
        boolean canRemove = this.getThen().canRemove(usedVars);
        if (this.hasElse()) {
            canRemove &= this.getElse().canRemove(eUsedVars);
            Util.unify(usedVars, eUsedVars);
        }
        if (canRemove) {
            return this.getCondition().canRemove(usedVars);
        }
        this.getCondition().addUsedVars(usedVars);
        return false;
    }

    @Override
    public void addUsedVars(Map<String, Boolean> usedVars) {
        this.getCondition().addUsedVars(usedVars);
        this.getThen().addUsedVars(usedVars);
        if (this.hasElse()) {
            this.getElse().addUsedVars(usedVars);
        }
    }

    public IfStmt() {
        this.setChild(new Opt(), 2);
    }

    public IfStmt(Expr p0, Stmt p1, Opt<Stmt> p2) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
        this.setChild(p2, 2);
    }

    @Override
    protected int numChildren() {
        return 3;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setCondition(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getCondition() {
        return (Expr)this.getChild(0);
    }

    public Expr getConditionNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setThen(Stmt node) {
        this.setChild(node, 1);
    }

    public Stmt getThen() {
        return (Stmt)this.getChild(1);
    }

    public Stmt getThenNoTransform() {
        return (Stmt)this.getChildNoTransform(1);
    }

    public void setElseOpt(Opt<Stmt> opt) {
        this.setChild(opt, 2);
    }

    public boolean hasElse() {
        return this.getElseOpt().getNumChild() != 0;
    }

    public Stmt getElse() {
        return (Stmt)this.getElseOpt().getChild(0);
    }

    public void setElse(Stmt node) {
        this.getElseOpt().setChild(node, 0);
    }

    public Opt<Stmt> getElseOpt() {
        return (Opt)this.getChild(2);
    }

    public Opt<Stmt> getElseOptNoTransform() {
        return (Opt)this.getChildNoTransform(2);
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.hasElse() ? this.getThen().isDAafter(v) && this.getElse().isDAafter(v) : this.getThen().isDAafter(v) && this.getCondition().isDAafterFalse(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.hasElse() ? this.getThen().isDUafter(v) && this.getElse().isDUafter(v) : this.getThen().isDUafter(v) && this.getCondition().isDUafterFalse(v);
    }

    @Override
    public boolean canCompleteNormally() {
        if (this.canCompleteNormally_computed) {
            return this.canCompleteNormally_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.canCompleteNormally_value = this.canCompleteNormally_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.canCompleteNormally_computed = true;
        }
        return this.canCompleteNormally_value;
    }

    private boolean canCompleteNormally_compute() {
        return this.reachable() && !this.hasElse() || this.getThen().canCompleteNormally() || this.hasElse() && this.getElse().canCompleteNormally();
    }

    @Override
    public boolean definesLabel() {
        ASTNode$State state = this.state();
        boolean definesLabel_value = this.definesLabel_compute();
        return definesLabel_value;
    }

    private boolean definesLabel_compute() {
        return true;
    }

    public int else_branch_label() {
        if (this.else_branch_label_computed) {
            return this.else_branch_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.else_branch_label_value = this.else_branch_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.else_branch_label_computed = true;
        }
        return this.else_branch_label_value;
    }

    private int else_branch_label_compute() {
        return this.hostType().constantPool().newLabel();
    }

    public int then_branch_label() {
        if (this.then_branch_label_computed) {
            return this.then_branch_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.then_branch_label_value = this.then_branch_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.then_branch_label_computed = true;
        }
        return this.then_branch_label_value;
    }

    private int then_branch_label_compute() {
        return this.hostType().constantPool().newLabel();
    }

    @Override
    public Stmt pe(Environment env) {
        ASTNode$State state = this.state();
        Stmt pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private Stmt pe_compute(Environment env) {
        Expr pec = this.getCondition().peCatch(env);
        if (pec instanceof BooleanLiteral) {
            BooleanLiteral bc = (BooleanLiteral)pec;
            boolean bcv = bc.constant().booleanValue();
            if (bcv) {
                return this.getThen().peCatch(env);
            }
            if (this.hasElse()) {
                return this.getElse().peCatch(env);
            }
            return new EmptyStmt();
        }
        Stmt thenStmt = this.getThen().peCatch(env);
        Opt<Stmt> elseStmt = new Opt<Stmt>();
        if (this.hasElse()) {
            elseStmt.setChild(this.getElse().peCatch(env), 0);
        }
        return new IfStmt(pec, thenStmt, elseStmt);
    }

    @Override
    public Stmt rewriteReturns(MethodAccess m) {
        ASTNode$State state = this.state();
        Stmt rewriteReturns_MethodAccess_value = this.rewriteReturns_compute(m);
        return rewriteReturns_MethodAccess_value;
    }

    private Stmt rewriteReturns_compute(MethodAccess m) {
        this.setThen(this.getThen().rewriteReturns(m));
        if (this.hasElse()) {
            this.setElse(this.getElse().rewriteReturns(m));
        }
        return this;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getElseOptNoTransform()) {
            return this.getCondition().isDAafterFalse(v);
        }
        if (caller == this.getThenNoTransform()) {
            return this.getCondition().isDAafterTrue(v);
        }
        if (caller == this.getConditionNoTransform()) {
            return this.isDAbefore(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getElseOptNoTransform()) {
            return this.getCondition().isDUafterFalse(v);
        }
        if (caller == this.getThenNoTransform()) {
            return this.getCondition().isDUafterTrue(v);
        }
        if (caller == this.getConditionNoTransform()) {
            return this.isDUbefore(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        if (caller == this.getElseOptNoTransform()) {
            return this.reachable();
        }
        if (caller == this.getThenNoTransform()) {
            return this.reachable();
        }
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    @Override
    public boolean Define_boolean_reportUnreachable(ASTNode caller, ASTNode child) {
        if (caller == this.getElseOptNoTransform()) {
            return this.reachable();
        }
        if (caller == this.getThenNoTransform()) {
            return this.reachable();
        }
        return this.getParent().Define_boolean_reportUnreachable(this, caller);
    }

    @Override
    public int Define_int_condition_false_label(ASTNode caller, ASTNode child) {
        if (caller == this.getConditionNoTransform()) {
            return this.else_branch_label();
        }
        return this.getParent().Define_int_condition_false_label(this, caller);
    }

    @Override
    public int Define_int_condition_true_label(ASTNode caller, ASTNode child) {
        if (caller == this.getConditionNoTransform()) {
            return this.then_branch_label();
        }
        return this.getParent().Define_int_condition_true_label(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

