/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Access;
import AST.BooleanLiteral;
import AST.CodeGeneration;
import AST.Expr;
import AST.NameType;
import AST.ObjectLiteral;
import AST.TypeAccess;
import AST.TypeDecl;
import AST.Variable;
import jpe.Environment;
import jpe.Util;

public class InstanceOfExpr
extends Expr
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public InstanceOfExpr clone() throws CloneNotSupportedException {
        InstanceOfExpr node = (InstanceOfExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public InstanceOfExpr copy() {
        try {
            InstanceOfExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public InstanceOfExpr fullCopy() {
        InstanceOfExpr res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        this.getExpr().toString(s);
        s.append(" instanceof ");
        this.getTypeAccess().toString(s);
    }

    @Override
    public void typeCheck() {
        TypeDecl relationalExpr = this.getExpr().type();
        TypeDecl referenceType = this.getTypeAccess().type();
        if (!relationalExpr.isUnknown()) {
            if (!relationalExpr.isReferenceType() && !relationalExpr.isNull()) {
                this.error("The relational expression in instance of must be reference or null type");
            }
            if (!referenceType.isReferenceType()) {
                this.error("The reference expression in instance of must be reference type");
            }
            if (!relationalExpr.castingConversionTo(referenceType)) {
                this.error("The type " + relationalExpr.typeName() + " of the relational expression " + this.getExpr() + " can not be cast into the type " + referenceType.typeName());
            }
            if (this.getExpr().isTypeAccess()) {
                this.error("The relational expression " + this.getExpr() + " must not be a type name");
            }
        }
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        this.getExpr().createBCode(gen);
        gen.emitInstanceof(this.getTypeAccess().type());
    }

    public InstanceOfExpr() {
    }

    public InstanceOfExpr(Expr p0, Access p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setExpr(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(0);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setTypeAccess(Access node) {
        this.setChild(node, 1);
    }

    public Access getTypeAccess() {
        return (Access)this.getChild(1);
    }

    public Access getTypeAccessNoTransform() {
        return (Access)this.getChildNoTransform(1);
    }

    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        boolean isConstant_value = this.isConstant_compute();
        return isConstant_value;
    }

    private boolean isConstant_compute() {
        return false;
    }

    @Override
    public boolean isDAafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafterFalse_Variable_value = this.isDAafterFalse_compute(v);
        return isDAafterFalse_Variable_value;
    }

    private boolean isDAafterFalse_compute(Variable v) {
        return this.isDAafter(v);
    }

    @Override
    public boolean isDAafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafterTrue_Variable_value = this.isDAafterTrue_compute(v);
        return isDAafterTrue_Variable_value;
    }

    private boolean isDAafterTrue_compute(Variable v) {
        return this.isDAafter(v);
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getExpr().isDAafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getExpr().isDUafter(v);
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeBoolean();
    }

    @Override
    public Expr pe(Environment env) {
        ASTNode$State state = this.state();
        Expr pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private Expr pe_compute(Environment env) {
        Expr e = this.getExpr().pe(env);
        try {
            if (e instanceof ObjectLiteral) {
                Object o = ((ObjectLiteral)e).getObject();
                TypeDecl td = ((TypeAccess)this.getTypeAccess()).decl();
                Class<?> c = Util.getClassForType(td.fullName());
                if (c.isInstance(o)) {
                    return new BooleanLiteral(true);
                }
                return new BooleanLiteral(false);
            }
        }
        catch (ClassNotFoundException o) {
            // empty catch block
        }
        InstanceOfExpr i = this.fullCopy();
        i.setExpr(e);
        return i;
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeAccessNoTransform()) {
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

