/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.CodeGeneration;
import AST.Constant;
import AST.Literal;
import AST.TypeDecl;
import beaver.Symbol;

public class IntegerLiteral
extends Literal
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.constant_computed = false;
        this.constant_value = null;
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public IntegerLiteral clone() throws CloneNotSupportedException {
        IntegerLiteral node = (IntegerLiteral)super.clone();
        node.constant_computed = false;
        node.constant_value = null;
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public IntegerLiteral copy() {
        try {
            IntegerLiteral node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public IntegerLiteral fullCopy() {
        IntegerLiteral res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public IntegerLiteral(int i) {
        this(Integer.toString(i));
    }

    @Override
    public void typeCheck() {
        if (this.constant().error) {
            this.error("The value of an int literal must be a decimal value in the range -2147483648..2147483647 or a hexadecimal or octal literal that fits in 32 bits.");
        }
    }

    public static void push(CodeGeneration gen, int value) {
        switch (value) {
            case -1: {
                gen.emit((byte)2);
                break;
            }
            case 0: {
                gen.emit((byte)3);
                break;
            }
            case 1: {
                gen.emit((byte)4);
                break;
            }
            case 2: {
                gen.emit((byte)5);
                break;
            }
            case 3: {
                gen.emit((byte)6);
                break;
            }
            case 4: {
                gen.emit((byte)7);
                break;
            }
            case 5: {
                gen.emit((byte)8);
                break;
            }
            default: {
                if (value >= -128 && value <= 127) {
                    gen.emit((byte)16).add(value);
                    break;
                }
                if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
                    gen.emit((byte)17).add2(value);
                    break;
                }
                int index = gen.constantPool().addConstant(value);
                if (index < 256) {
                    gen.emit((byte)18).add(index);
                    break;
                }
                gen.emit((byte)19).add2(index);
            }
        }
    }

    @Override
    public void emitPushConstant(CodeGeneration gen) {
        this.type().emitPushConstant(gen, this.constant().intValue());
    }

    public IntegerLiteral() {
    }

    public IntegerLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public IntegerLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    @Override
    public void setLITERAL(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol.value;
        this.LITERALstart = symbol.getStart();
        this.LITERALend = symbol.getEnd();
    }

    @Override
    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    public boolean isHex() {
        ASTNode$State state = this.state();
        boolean isHex_value = this.isHex_compute();
        return isHex_value;
    }

    private boolean isHex_compute() {
        return this.getLITERAL().toLowerCase().startsWith("0x");
    }

    public boolean isOctal() {
        ASTNode$State state = this.state();
        boolean isOctal_value = this.isOctal_compute();
        return isOctal_value;
    }

    private boolean isOctal_compute() {
        return this.getLITERAL().startsWith("0");
    }

    public boolean isDecimal() {
        ASTNode$State state = this.state();
        boolean isDecimal_value = this.isDecimal_compute();
        return isDecimal_value;
    }

    private boolean isDecimal_compute() {
        return !this.isHex() && !this.isOctal();
    }

    @Override
    public boolean isPositive() {
        ASTNode$State state = this.state();
        boolean isPositive_value = this.isPositive_compute();
        return isPositive_value;
    }

    private boolean isPositive_compute() {
        return !this.getLITERAL().startsWith("-");
    }

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        long l = 0L;
        try {
            l = Literal.parseLong(this.getLITERAL());
        }
        catch (NumberFormatException e) {
            Constant c = Constant.create(0L);
            c.error = true;
            return c;
        }
        Constant c = Constant.create((int)l);
        if (this.isDecimal() && l != (long)((int)l)) {
            c.error = true;
        }
        if (this.isOctal() && l > 0xFFFFFFFFL) {
            c.error = true;
        }
        if (this.isHex() && l > 0xFFFFFFFFL) {
            c.error = true;
        }
        return c;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeInt();
    }

    @Override
    public Object literalValueObject() {
        ASTNode$State state = this.state();
        Object literalValueObject_value = this.literalValueObject_compute();
        return literalValueObject_value;
    }

    private Object literalValueObject_compute() {
        return new Integer(this.constant().intValue());
    }

    @Override
    public Class<?> literalValueClass() {
        ASTNode$State state = this.state();
        Class<?> literalValueClass_value = this.literalValueClass_compute();
        return literalValueClass_value;
    }

    private Class<?> literalValueClass_compute() {
        return Integer.TYPE;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

