/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Access;
import AST.ArrayDecl;
import AST.Attribute;
import AST.BodyDecl;
import AST.ClassDecl;
import AST.ConstantPool;
import AST.FieldDeclaration;
import AST.GenericInterfaceDecl;
import AST.InterfaceDeclSubstituted;
import AST.List;
import AST.MethodDecl;
import AST.MethodDeclSubstituted;
import AST.Modifier;
import AST.Modifiers;
import AST.NameType;
import AST.Opt;
import AST.Parameterization;
import AST.ReferenceType;
import AST.Signatures;
import AST.SimpleSet;
import AST.TypeDecl;
import AST.TypeVariable;
import beaver.Symbol;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class InterfaceDecl
extends ReferenceType
implements Cloneable {
    private TypeDecl methodHolder = null;

    @Override
    public void flushCache() {
        super.flushCache();
        this.methodsSignatureMap_computed = false;
        this.methodsSignatureMap_value = null;
        this.ancestorMethods_String_values = null;
        this.memberTypes_String_values = null;
        this.memberFieldsMap_computed = false;
        this.memberFieldsMap_value = null;
        this.memberFields_String_values = null;
        this.isStatic_computed = false;
        this.castingConversionTo_TypeDecl_values = null;
        this.instanceOf_TypeDecl_values = null;
        this.isCircular_visited = -1;
        this.isCircular_computed = false;
        this.isCircular_initialized = false;
        this.typeDescriptor_computed = false;
        this.typeDescriptor_value = null;
        this.implementedInterfaces_computed = false;
        this.implementedInterfaces_value = null;
        this.subtype_TypeDecl_values = null;
        this.needsSignatureAttribute_computed = false;
        this.classSignature_computed = false;
        this.classSignature_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public InterfaceDecl clone() throws CloneNotSupportedException {
        InterfaceDecl node = (InterfaceDecl)super.clone();
        node.methodsSignatureMap_computed = false;
        node.methodsSignatureMap_value = null;
        node.ancestorMethods_String_values = null;
        node.memberTypes_String_values = null;
        node.memberFieldsMap_computed = false;
        node.memberFieldsMap_value = null;
        node.memberFields_String_values = null;
        node.isStatic_computed = false;
        node.castingConversionTo_TypeDecl_values = null;
        node.instanceOf_TypeDecl_values = null;
        node.isCircular_visited = -1;
        node.isCircular_computed = false;
        node.isCircular_initialized = false;
        node.typeDescriptor_computed = false;
        node.typeDescriptor_value = null;
        node.implementedInterfaces_computed = false;
        node.implementedInterfaces_value = null;
        node.subtype_TypeDecl_values = null;
        node.needsSignatureAttribute_computed = false;
        node.classSignature_computed = false;
        node.classSignature_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public InterfaceDecl copy() {
        try {
            InterfaceDecl node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public InterfaceDecl fullCopy() {
        InterfaceDecl res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void accessControl() {
        super.accessControl();
        if (!this.isCircular()) {
            HashSet<TypeDecl> set = new HashSet<TypeDecl>();
            int i = 0;
            while (i < this.getNumSuperInterfaceId()) {
                TypeDecl decl = this.getSuperInterfaceId(i).type();
                if (!decl.isInterfaceDecl() && !decl.isUnknown()) {
                    this.error("interface " + this.fullName() + " tries to extend non interface type " + decl.fullName());
                }
                if (!decl.isCircular() && !decl.accessibleFrom(this)) {
                    this.error("interface " + this.fullName() + " can not extend non accessible type " + decl.fullName());
                }
                if (set.contains(decl)) {
                    this.error("extended interface " + decl.fullName() + " mentionened multiple times in extends clause");
                }
                set.add(decl);
                ++i;
            }
        }
    }

    @Override
    public void checkModifiers() {
        super.checkModifiers();
    }

    @Override
    public void toString(StringBuffer s) {
        int i;
        s.append(this.indent());
        this.getModifiers().toString(s);
        s.append("interface " + this.name());
        if (this.getNumSuperInterfaceId() > 0) {
            s.append(" extends ");
            this.getSuperInterfaceId(0).toString(s);
            i = 1;
            while (i < this.getNumSuperInterfaceId()) {
                s.append(", ");
                this.getSuperInterfaceId(i).toString(s);
                ++i;
            }
        }
        s.append(" {");
        i = 0;
        while (i < this.getNumBodyDecl()) {
            this.getBodyDecl(i).toString(s);
            ++i;
        }
        s.append(String.valueOf(this.indent()) + "}");
    }

    public Iterator superinterfacesIterator() {
        return new Iterator(){
            private int index = 0;
            private TypeDecl current = null;

            @Override
            public boolean hasNext() {
                this.computeNextCurrent();
                return this.current != null;
            }

            public Object next() {
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            /*
             * Unable to fully structure code
             */
            private void computeNextCurrent() {
                this.current = null;
                if (!InterfaceDecl.this.isCircular()) ** GOTO lbl7
                return;
lbl-1000:
                // 1 sources

                {
                    if ((typeDecl = InterfaceDecl.this.getSuperInterfaceId(this.index++).type()).isCircular() || !typeDecl.isInterfaceDecl()) continue;
                    this.current = typeDecl;
                    return;
lbl7:
                    // 2 sources

                    ** while (this.index < InterfaceDecl.this.getNumSuperInterfaceId())
                }
lbl8:
                // 1 sources

            }
        };
    }

    @Override
    public void nameCheck() {
        super.nameCheck();
        if (this.isCircular()) {
            this.error("circular inheritance dependency in " + this.typeName());
        } else {
            int i = 0;
            while (i < this.getNumSuperInterfaceId()) {
                TypeDecl typeDecl = this.getSuperInterfaceId(i).type();
                if (typeDecl.isCircular()) {
                    this.error("circular inheritance dependency in " + this.typeName());
                }
                ++i;
            }
        }
        for (SimpleSet set : this.methodsSignatureMap().values()) {
            if (set.size() <= 1) continue;
            Iterator i2 = set.iterator();
            MethodDecl m = (MethodDecl)i2.next();
            while (i2.hasNext()) {
                MethodDecl n = (MethodDecl)i2.next();
                if (n.mayOverrideReturn(m) || m.mayOverrideReturn(n)) continue;
                this.error("multiply inherited methods with the same signature must have the same return type");
            }
        }
    }

    @Override
    public void generateClassfile() {
        super.generateClassfile();
        String fileName = String.valueOf(this.destinationPath()) + File.separator + this.constantPoolName() + ".class";
        if (this.options().verbose()) {
            System.out.println("Writing class file to " + fileName);
        }
        try {
            Iterator itera;
            File dest;
            File parentFile;
            ConstantPool cp = this.constantPool();
            cp.addClass(this.constantPoolName());
            cp.addClass("java/lang/Object");
            int i = 0;
            while (i < this.getNumSuperInterfaceId()) {
                cp.addClass(this.getSuperInterfaceId(i).type().constantPoolName());
                ++i;
            }
            for (FieldDeclaration field : this.bcFields()) {
                cp.addUtf8(field.name());
                cp.addUtf8(field.type().typeDescriptor());
                field.attributes();
            }
            for (Object obj : this.bcMethods()) {
                if (!(obj instanceof MethodDecl)) continue;
                MethodDecl m = (MethodDecl)obj;
                cp.addUtf8(m.name());
                cp.addUtf8(m.descName());
                m.attributes();
            }
            this.attributes();
            if (this.hasClinit()) {
                cp.addUtf8("<clinit>");
                cp.addUtf8("()V");
                this.clinit_attributes();
            }
            if ((parentFile = (dest = new File(fileName)).getParentFile()) != null) {
                parentFile.mkdirs();
            }
            FileOutputStream f = new FileOutputStream(fileName);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(f));
            out.writeInt(this.magicHeader());
            out.writeChar(this.minorVersion());
            out.writeChar(this.majorVersion());
            cp.emit(out);
            int flags = this.flags();
            if (this.isNestedType()) {
                flags = this.mangledFlags(flags);
            }
            if (this.isInterfaceDecl()) {
                flags |= 0x200;
            }
            out.writeChar(flags);
            out.writeChar(cp.addClass(this.constantPoolName()));
            out.writeChar(cp.addClass("java/lang/Object"));
            if (this.getNumSuperInterfaceId() == 1 && this.getSuperInterfaceId(0).type().isObject()) {
                out.writeChar(0);
            } else {
                out.writeChar(this.getNumSuperInterfaceId());
            }
            int i2 = 0;
            while (i2 < this.getNumSuperInterfaceId()) {
                TypeDecl typeDecl = this.getSuperInterfaceId(i2).type();
                if (typeDecl.isInterfaceDecl()) {
                    out.writeChar(cp.addClass(typeDecl.constantPoolName()));
                }
                ++i2;
            }
            Collection fields = this.bcFields();
            out.writeChar(fields.size());
            for (FieldDeclaration field : fields) {
                out.writeChar(field.flags());
                out.writeChar(cp.addUtf8(field.name()));
                out.writeChar(cp.addUtf8(field.type().typeDescriptor()));
                out.writeChar(field.attributes().size());
                Iterator itera2 = field.attributes().iterator();
                while (itera2.hasNext()) {
                    ((Attribute)itera2.next()).emit(out);
                }
            }
            Collection methods = this.bcMethods();
            out.writeChar(methods.size() + (this.hasClinit() ? 1 : 0));
            for (BodyDecl b : methods) {
                b.generateMethod(out, cp);
            }
            if (this.hasClinit()) {
                out.writeChar(8);
                out.writeChar(cp.addUtf8("<clinit>"));
                out.writeChar(cp.addUtf8("()V"));
                out.writeChar(this.clinit_attributes().size());
                itera = this.clinit_attributes().iterator();
                while (itera.hasNext()) {
                    ((Attribute)itera.next()).emit(out);
                }
            }
            out.writeChar(this.attributes().size());
            itera = this.attributes().iterator();
            while (itera.hasNext()) {
                ((Attribute)itera.next()).emit(out);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public FieldDeclaration createStaticClassField(String name) {
        return this.methodHolder().createStaticClassField(name);
    }

    @Override
    public MethodDecl createStaticClassMethod() {
        return this.methodHolder().createStaticClassMethod();
    }

    public TypeDecl methodHolder() {
        if (this.methodHolder != null) {
            return this.methodHolder;
        }
        String name = "$" + this.nextAnonymousIndex();
        ClassDecl c = this.addMemberClass(new ClassDecl(new Modifiers(new List<Modifier>()), name, new Opt<Access>(), new List<Access>(), new List<BodyDecl>()));
        this.methodHolder = c;
        return c;
    }

    @Override
    public TypeDecl makeGeneric(Signatures.ClassSignature s) {
        if (s.hasFormalTypeParameters()) {
            ASTNode node = this.getParent();
            int index = node.getIndexOfChild(this);
            node.setChild(new GenericInterfaceDecl(this.getModifiersNoTransform(), this.getID(), s.hasSuperinterfaceSignature() ? s.superinterfaceSignature() : this.getSuperInterfaceIdListNoTransform(), this.getBodyDeclListNoTransform(), (List<TypeVariable>)s.typeParameters()), index);
            return (TypeDecl)node.getChildNoTransform(index);
        }
        if (s.hasSuperinterfaceSignature()) {
            this.setSuperInterfaceIdList(s.superinterfaceSignature());
        }
        return this;
    }

    public InterfaceDecl p(Parameterization parTypeDecl) {
        InterfaceDeclSubstituted c = new InterfaceDeclSubstituted(this.getModifiers().fullCopy(), this.getID(), (List<Access>)this.getSuperInterfaceIdList().substitute(parTypeDecl), new List<BodyDecl>(), (TypeDecl)this);
        return c;
    }

    public InterfaceDecl() {
        this.setChild(new List(), 1);
        this.setChild(new List(), 2);
    }

    public InterfaceDecl(Modifiers p0, String p1, List<Access> p2, List<BodyDecl> p3) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
    }

    public InterfaceDecl(Modifiers p0, Symbol p1, List<Access> p2, List<BodyDecl> p3) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
    }

    @Override
    protected int numChildren() {
        return 3;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setModifiers(Modifiers node) {
        this.setChild(node, 0);
    }

    @Override
    public Modifiers getModifiers() {
        return (Modifiers)this.getChild(0);
    }

    @Override
    public Modifiers getModifiersNoTransform() {
        return (Modifiers)this.getChildNoTransform(0);
    }

    @Override
    public void setID(String value) {
        this.tokenString_ID = value;
    }

    @Override
    public void setID(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol.value;
        this.IDstart = symbol.getStart();
        this.IDend = symbol.getEnd();
    }

    @Override
    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    public void setSuperInterfaceIdList(List<Access> list) {
        this.setChild(list, 1);
    }

    public int getNumSuperInterfaceId() {
        return this.getSuperInterfaceIdList().getNumChild();
    }

    public Access getSuperInterfaceId(int i) {
        return (Access)this.getSuperInterfaceIdList().getChild(i);
    }

    public void addSuperInterfaceId(Access node) {
        List<Access> list = this.parent == null || state == null ? this.getSuperInterfaceIdListNoTransform() : this.getSuperInterfaceIdList();
        list.addChild(node);
    }

    public void addSuperInterfaceIdNoTransform(Access node) {
        List<Access> list = this.getSuperInterfaceIdListNoTransform();
        list.addChild(node);
    }

    public void setSuperInterfaceId(Access node, int i) {
        List<Access> list = this.getSuperInterfaceIdList();
        list.setChild(node, i);
    }

    public List<Access> getSuperInterfaceIds() {
        return this.getSuperInterfaceIdList();
    }

    public List<Access> getSuperInterfaceIdsNoTransform() {
        return this.getSuperInterfaceIdListNoTransform();
    }

    public List<Access> getSuperInterfaceIdList() {
        List list = (List)this.getChild(1);
        list.getNumChild();
        return list;
    }

    public List<Access> getSuperInterfaceIdListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    @Override
    public void setBodyDeclList(List<BodyDecl> list) {
        this.setChild(list, 2);
    }

    @Override
    public int getNumBodyDecl() {
        return this.getBodyDeclList().getNumChild();
    }

    @Override
    public BodyDecl getBodyDecl(int i) {
        return (BodyDecl)this.getBodyDeclList().getChild(i);
    }

    @Override
    public void addBodyDecl(BodyDecl node) {
        List<BodyDecl> list = this.parent == null || state == null ? this.getBodyDeclListNoTransform() : this.getBodyDeclList();
        list.addChild(node);
    }

    @Override
    public void addBodyDeclNoTransform(BodyDecl node) {
        List<BodyDecl> list = this.getBodyDeclListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setBodyDecl(BodyDecl node, int i) {
        List<BodyDecl> list = this.getBodyDeclList();
        list.setChild(node, i);
    }

    @Override
    public List<BodyDecl> getBodyDecls() {
        return this.getBodyDeclList();
    }

    @Override
    public List<BodyDecl> getBodyDeclsNoTransform() {
        return this.getBodyDeclListNoTransform();
    }

    @Override
    public List<BodyDecl> getBodyDeclList() {
        List list = (List)this.getChild(2);
        list.getNumChild();
        return list;
    }

    @Override
    public List<BodyDecl> getBodyDeclListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    private boolean refined_Generics_InterfaceDecl_castingConversionTo_TypeDecl(TypeDecl type) {
        InterfaceDecl S = this;
        TypeDecl T = type;
        if (T.isArrayDecl()) {
            return T.instanceOf(S);
        }
        if (T.isReferenceType() && !T.isFinal()) {
            return true;
        }
        return T.instanceOf(S);
    }

    @Override
    public Collection lookupSuperConstructor() {
        ASTNode$State state = this.state();
        Collection lookupSuperConstructor_value = this.lookupSuperConstructor_compute();
        return lookupSuperConstructor_value;
    }

    private Collection lookupSuperConstructor_compute() {
        return this.typeObject().constructors();
    }

    @Override
    public HashMap methodsSignatureMap() {
        if (this.methodsSignatureMap_computed) {
            return this.methodsSignatureMap_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.methodsSignatureMap_value = this.methodsSignatureMap_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.methodsSignatureMap_computed = true;
        }
        return this.methodsSignatureMap_value;
    }

    private HashMap methodsSignatureMap_compute() {
        HashMap map = new HashMap(this.localMethodsSignatureMap());
        Iterator outerIter = this.superinterfacesIterator();
        while (outerIter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)outerIter.next();
            Iterator iter = typeDecl.methodsIterator();
            while (iter.hasNext()) {
                MethodDecl m = (MethodDecl)iter.next();
                if (m.isPrivate() || !m.accessibleFrom(this) || this.localMethodsSignatureMap().containsKey(m.signature()) || m instanceof MethodDeclSubstituted && this.localMethodsSignatureMap().containsKey(m.sourceMethodDecl().signature())) continue;
                InterfaceDecl.putSimpleSetElement(map, m.signature(), m);
            }
        }
        Iterator iter = this.typeObject().methodsIterator();
        while (iter.hasNext()) {
            MethodDecl m = (MethodDecl)iter.next();
            if (!m.isPublic() || map.containsKey(m.signature())) continue;
            InterfaceDecl.putSimpleSetElement(map, m.signature(), m);
        }
        return map;
    }

    @Override
    public SimpleSet ancestorMethods(String signature) {
        String _parameters = signature;
        if (this.ancestorMethods_String_values == null) {
            this.ancestorMethods_String_values = new HashMap(4);
        }
        if (this.ancestorMethods_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.ancestorMethods_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet ancestorMethods_String_value = this.ancestorMethods_compute(signature);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.ancestorMethods_String_values.put(_parameters, ancestorMethods_String_value);
        }
        return ancestorMethods_String_value;
    }

    private SimpleSet ancestorMethods_compute(String signature) {
        SimpleSet set = SimpleSet.emptySet;
        Iterator outerIter = this.superinterfacesIterator();
        while (outerIter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)outerIter.next();
            Iterator iter = typeDecl.methodsSignature(signature).iterator();
            while (iter.hasNext()) {
                MethodDecl m = (MethodDecl)iter.next();
                set = set.add(m);
            }
        }
        if (!this.superinterfacesIterator().hasNext()) {
            Iterator iter = this.typeObject().methodsSignature(signature).iterator();
            while (iter.hasNext()) {
                MethodDecl m = (MethodDecl)iter.next();
                if (!m.isPublic()) continue;
                set = set.add(m);
            }
        }
        return set;
    }

    @Override
    public SimpleSet memberTypes(String name) {
        String _parameters = name;
        if (this.memberTypes_String_values == null) {
            this.memberTypes_String_values = new HashMap(4);
        }
        if (this.memberTypes_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.memberTypes_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet memberTypes_String_value = this.memberTypes_compute(name);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.memberTypes_String_values.put(_parameters, memberTypes_String_value);
        }
        return memberTypes_String_value;
    }

    private SimpleSet memberTypes_compute(String name) {
        SimpleSet set = this.localTypeDecls(name);
        if (!set.isEmpty()) {
            return set;
        }
        Iterator outerIter = this.superinterfacesIterator();
        while (outerIter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)outerIter.next();
            Iterator iter = typeDecl.memberTypes(name).iterator();
            while (iter.hasNext()) {
                TypeDecl decl = (TypeDecl)iter.next();
                if (decl.isPrivate()) continue;
                set = set.add(decl);
            }
        }
        return set;
    }

    @Override
    public HashMap memberFieldsMap() {
        if (this.memberFieldsMap_computed) {
            return this.memberFieldsMap_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.memberFieldsMap_value = this.memberFieldsMap_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.memberFieldsMap_computed = true;
        }
        return this.memberFieldsMap_value;
    }

    private HashMap memberFieldsMap_compute() {
        HashMap map = new HashMap(this.localFieldsMap());
        Iterator outerIter = this.superinterfacesIterator();
        while (outerIter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)outerIter.next();
            Iterator iter = typeDecl.fieldsIterator();
            while (iter.hasNext()) {
                FieldDeclaration f = (FieldDeclaration)iter.next();
                if (!f.accessibleFrom(this) || f.isPrivate() || this.localFieldsMap().containsKey(f.name())) continue;
                InterfaceDecl.putSimpleSetElement(map, f.name(), f);
            }
        }
        return map;
    }

    @Override
    public SimpleSet memberFields(String name) {
        String _parameters = name;
        if (this.memberFields_String_values == null) {
            this.memberFields_String_values = new HashMap(4);
        }
        if (this.memberFields_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.memberFields_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet memberFields_String_value = this.memberFields_compute(name);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.memberFields_String_values.put(_parameters, memberFields_String_value);
        }
        return memberFields_String_value;
    }

    private SimpleSet memberFields_compute(String name) {
        SimpleSet fields = this.localFields(name);
        if (!fields.isEmpty()) {
            return fields;
        }
        Iterator outerIter = this.superinterfacesIterator();
        while (outerIter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)outerIter.next();
            Iterator iter = typeDecl.memberFields(name).iterator();
            while (iter.hasNext()) {
                FieldDeclaration f = (FieldDeclaration)iter.next();
                if (!f.accessibleFrom(this) || f.isPrivate()) continue;
                fields = fields.add(f);
            }
        }
        return fields;
    }

    @Override
    public boolean isAbstract() {
        ASTNode$State state = this.state();
        boolean isAbstract_value = this.isAbstract_compute();
        return isAbstract_value;
    }

    private boolean isAbstract_compute() {
        return true;
    }

    @Override
    public boolean isStatic() {
        if (this.isStatic_computed) {
            return this.isStatic_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isStatic_value = this.isStatic_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isStatic_computed = true;
        }
        return this.isStatic_value;
    }

    private boolean isStatic_compute() {
        return this.getModifiers().isStatic() || this.isMemberType();
    }

    @Override
    public boolean castingConversionTo(TypeDecl type) {
        TypeDecl _parameters = type;
        if (this.castingConversionTo_TypeDecl_values == null) {
            this.castingConversionTo_TypeDecl_values = new HashMap(4);
        }
        if (this.castingConversionTo_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.castingConversionTo_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean castingConversionTo_TypeDecl_value = this.castingConversionTo_compute(type);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.castingConversionTo_TypeDecl_values.put(_parameters, castingConversionTo_TypeDecl_value);
        }
        return castingConversionTo_TypeDecl_value;
    }

    private boolean castingConversionTo_compute(TypeDecl type) {
        boolean canUnboxType;
        if (this.refined_Generics_InterfaceDecl_castingConversionTo_TypeDecl(type)) {
            return true;
        }
        boolean canUnboxThis = !this.unboxed().isUnknown();
        boolean bl = canUnboxType = !type.unboxed().isUnknown();
        if (canUnboxThis && !canUnboxType) {
            return this.unboxed().wideningConversionTo(type);
        }
        return false;
    }

    @Override
    public boolean isInterfaceDecl() {
        ASTNode$State state = this.state();
        boolean isInterfaceDecl_value = this.isInterfaceDecl_compute();
        return isInterfaceDecl_value;
    }

    private boolean isInterfaceDecl_compute() {
        return true;
    }

    @Override
    public boolean instanceOf(TypeDecl type) {
        TypeDecl _parameters = type;
        if (this.instanceOf_TypeDecl_values == null) {
            this.instanceOf_TypeDecl_values = new HashMap(4);
        }
        if (this.instanceOf_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.instanceOf_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean instanceOf_TypeDecl_value = this.instanceOf_compute(type);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.instanceOf_TypeDecl_values.put(_parameters, instanceOf_TypeDecl_value);
        }
        return instanceOf_TypeDecl_value;
    }

    private boolean instanceOf_compute(TypeDecl type) {
        return this.subtype(type);
    }

    @Override
    public boolean isSupertypeOfClassDecl(ClassDecl type) {
        ASTNode$State state = this.state();
        boolean isSupertypeOfClassDecl_ClassDecl_value = this.isSupertypeOfClassDecl_compute(type);
        return isSupertypeOfClassDecl_ClassDecl_value;
    }

    private boolean isSupertypeOfClassDecl_compute(ClassDecl type) {
        if (super.isSupertypeOfClassDecl(type)) {
            return true;
        }
        Iterator iter = type.interfacesIterator();
        while (iter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)iter.next();
            if (!typeDecl.instanceOf(this)) continue;
            return true;
        }
        return type.hasSuperclass() && type.superclass() != null && type.superclass().instanceOf(this);
    }

    @Override
    public boolean isSupertypeOfInterfaceDecl(InterfaceDecl type) {
        ASTNode$State state = this.state();
        boolean isSupertypeOfInterfaceDecl_InterfaceDecl_value = this.isSupertypeOfInterfaceDecl_compute(type);
        return isSupertypeOfInterfaceDecl_InterfaceDecl_value;
    }

    private boolean isSupertypeOfInterfaceDecl_compute(InterfaceDecl type) {
        if (super.isSupertypeOfInterfaceDecl(type)) {
            return true;
        }
        Iterator iter = type.superinterfacesIterator();
        while (iter.hasNext()) {
            TypeDecl superinterface = (TypeDecl)iter.next();
            if (!superinterface.instanceOf(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSupertypeOfArrayDecl(ArrayDecl type) {
        ASTNode$State state = this.state();
        boolean isSupertypeOfArrayDecl_ArrayDecl_value = this.isSupertypeOfArrayDecl_compute(type);
        return isSupertypeOfArrayDecl_ArrayDecl_value;
    }

    private boolean isSupertypeOfArrayDecl_compute(ArrayDecl type) {
        if (super.isSupertypeOfArrayDecl(type)) {
            return true;
        }
        Iterator iter = type.interfacesIterator();
        while (iter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)iter.next();
            if (!typeDecl.instanceOf(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCircular() {
        if (this.isCircular_computed) {
            return this.isCircular_value;
        }
        ASTNode$State state = this.state();
        if (!this.isCircular_initialized) {
            this.isCircular_initialized = true;
            this.isCircular_value = true;
        }
        if (!state.IN_CIRCLE) {
            state.IN_CIRCLE = true;
            int num = state.boundariesCrossed;
            boolean isFinal = this.is$Final();
            do {
                this.isCircular_visited = state.CIRCLE_INDEX;
                state.CHANGE = false;
                boolean new_isCircular_value = this.isCircular_compute();
                if (new_isCircular_value != this.isCircular_value) {
                    state.CHANGE = true;
                }
                this.isCircular_value = new_isCircular_value;
                ++state.CIRCLE_INDEX;
            } while (state.CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.isCircular_computed = true;
            } else {
                state.RESET_CYCLE = true;
                this.isCircular_compute();
                state.RESET_CYCLE = false;
                this.isCircular_computed = false;
                this.isCircular_initialized = false;
            }
            state.IN_CIRCLE = false;
            return this.isCircular_value;
        }
        if (this.isCircular_visited != state.CIRCLE_INDEX) {
            this.isCircular_visited = state.CIRCLE_INDEX;
            if (state.RESET_CYCLE) {
                this.isCircular_computed = false;
                this.isCircular_initialized = false;
                this.isCircular_visited = -1;
                return this.isCircular_value;
            }
            boolean new_isCircular_value = this.isCircular_compute();
            if (new_isCircular_value != this.isCircular_value) {
                state.CHANGE = true;
            }
            this.isCircular_value = new_isCircular_value;
            return this.isCircular_value;
        }
        return this.isCircular_value;
    }

    private boolean isCircular_compute() {
        int i = 0;
        while (i < this.getNumSuperInterfaceId()) {
            Access a = this.getSuperInterfaceId(i).lastAccess();
            while (a != null) {
                if (a.type().isCircular()) {
                    return true;
                }
                Access access = a = a.isQualified() && a.qualifier().isTypeAccess() ? (Access)a.qualifier() : null;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String typeDescriptor() {
        if (this.typeDescriptor_computed) {
            return this.typeDescriptor_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeDescriptor_value = this.typeDescriptor_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeDescriptor_computed = true;
        }
        return this.typeDescriptor_value;
    }

    private String typeDescriptor_compute() {
        return "L" + this.constantPoolName() + ";";
    }

    @Override
    public String arrayTypeDescriptor() {
        ASTNode$State state = this.state();
        String arrayTypeDescriptor_value = this.arrayTypeDescriptor_compute();
        return arrayTypeDescriptor_value;
    }

    private String arrayTypeDescriptor_compute() {
        return this.constantPoolName();
    }

    @Override
    public HashSet implementedInterfaces() {
        if (this.implementedInterfaces_computed) {
            return this.implementedInterfaces_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.implementedInterfaces_value = this.implementedInterfaces_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.implementedInterfaces_computed = true;
        }
        return this.implementedInterfaces_value;
    }

    private HashSet implementedInterfaces_compute() {
        HashSet<InterfaceDecl> set = new HashSet<InterfaceDecl>();
        set.addAll(this.typeObject().implementedInterfaces());
        Iterator iter = this.superinterfacesIterator();
        while (iter.hasNext()) {
            InterfaceDecl decl = (InterfaceDecl)iter.next();
            set.add(decl);
            set.addAll(decl.implementedInterfaces());
        }
        return set;
    }

    @Override
    public boolean subtype(TypeDecl type) {
        ASTNode$State.CircularValue _value;
        TypeDecl _parameters = type;
        if (this.subtype_TypeDecl_values == null) {
            this.subtype_TypeDecl_values = new HashMap(4);
        }
        if (this.subtype_TypeDecl_values.containsKey(_parameters)) {
            Object _o = this.subtype_TypeDecl_values.get(_parameters);
            if (!(_o instanceof ASTNode$State.CircularValue)) {
                return (Boolean)_o;
            }
            _value = (ASTNode$State.CircularValue)_o;
        } else {
            _value = new ASTNode$State.CircularValue();
            this.subtype_TypeDecl_values.put(_parameters, _value);
            _value.value = true;
        }
        ASTNode$State state = this.state();
        if (!state.IN_CIRCLE) {
            boolean new_subtype_TypeDecl_value;
            state.IN_CIRCLE = true;
            int num = state.boundariesCrossed;
            boolean isFinal = this.is$Final();
            do {
                _value.visited = new Integer(state.CIRCLE_INDEX);
                state.CHANGE = false;
                new_subtype_TypeDecl_value = this.subtype_compute(type);
                if (new_subtype_TypeDecl_value != (Boolean)_value.value) {
                    state.CHANGE = true;
                    _value.value = new_subtype_TypeDecl_value;
                }
                ++state.CIRCLE_INDEX;
            } while (state.CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.subtype_TypeDecl_values.put(_parameters, new_subtype_TypeDecl_value);
            } else {
                this.subtype_TypeDecl_values.remove(_parameters);
                state.RESET_CYCLE = true;
                this.subtype_compute(type);
                state.RESET_CYCLE = false;
            }
            state.IN_CIRCLE = false;
            return new_subtype_TypeDecl_value;
        }
        if (!new Integer(state.CIRCLE_INDEX).equals(_value.visited)) {
            _value.visited = new Integer(state.CIRCLE_INDEX);
            boolean new_subtype_TypeDecl_value = this.subtype_compute(type);
            if (state.RESET_CYCLE) {
                this.subtype_TypeDecl_values.remove(_parameters);
            } else if (new_subtype_TypeDecl_value != (Boolean)_value.value) {
                state.CHANGE = true;
                _value.value = new_subtype_TypeDecl_value;
            }
            return new_subtype_TypeDecl_value;
        }
        return (Boolean)_value.value;
    }

    private boolean subtype_compute(TypeDecl type) {
        return type.supertypeInterfaceDecl(this);
    }

    @Override
    public boolean supertypeClassDecl(ClassDecl type) {
        ASTNode$State state = this.state();
        boolean supertypeClassDecl_ClassDecl_value = this.supertypeClassDecl_compute(type);
        return supertypeClassDecl_ClassDecl_value;
    }

    private boolean supertypeClassDecl_compute(ClassDecl type) {
        if (super.supertypeClassDecl(type)) {
            return true;
        }
        Iterator iter = type.interfacesIterator();
        while (iter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)iter.next();
            if (!typeDecl.subtype(this)) continue;
            return true;
        }
        return type.hasSuperclass() && type.superclass() != null && type.superclass().subtype(this);
    }

    @Override
    public boolean supertypeInterfaceDecl(InterfaceDecl type) {
        ASTNode$State state = this.state();
        boolean supertypeInterfaceDecl_InterfaceDecl_value = this.supertypeInterfaceDecl_compute(type);
        return supertypeInterfaceDecl_InterfaceDecl_value;
    }

    private boolean supertypeInterfaceDecl_compute(InterfaceDecl type) {
        if (super.supertypeInterfaceDecl(type)) {
            return true;
        }
        Iterator iter = type.superinterfacesIterator();
        while (iter.hasNext()) {
            TypeDecl superinterface = (TypeDecl)iter.next();
            if (!superinterface.subtype(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supertypeArrayDecl(ArrayDecl type) {
        ASTNode$State state = this.state();
        boolean supertypeArrayDecl_ArrayDecl_value = this.supertypeArrayDecl_compute(type);
        return supertypeArrayDecl_ArrayDecl_value;
    }

    private boolean supertypeArrayDecl_compute(ArrayDecl type) {
        if (super.supertypeArrayDecl(type)) {
            return true;
        }
        Iterator iter = type.interfacesIterator();
        while (iter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)iter.next();
            if (!typeDecl.subtype(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SimpleSet bridgeCandidates(String signature) {
        ASTNode$State state = this.state();
        SimpleSet bridgeCandidates_String_value = this.bridgeCandidates_compute(signature);
        return bridgeCandidates_String_value;
    }

    private SimpleSet bridgeCandidates_compute(String signature) {
        return this.ancestorMethods(signature);
    }

    @Override
    public boolean needsSignatureAttribute() {
        if (this.needsSignatureAttribute_computed) {
            return this.needsSignatureAttribute_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.needsSignatureAttribute_value = this.needsSignatureAttribute_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.needsSignatureAttribute_computed = true;
        }
        return this.needsSignatureAttribute_value;
    }

    private boolean needsSignatureAttribute_compute() {
        Iterator iter = this.superinterfacesIterator();
        while (iter.hasNext()) {
            if (!((TypeDecl)iter.next()).needsSignatureAttribute()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String classSignature() {
        if (this.classSignature_computed) {
            return this.classSignature_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.classSignature_value = this.classSignature_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.classSignature_computed = true;
        }
        return this.classSignature_value;
    }

    private String classSignature_compute() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.typeObject().classTypeSignature());
        Iterator iter = this.superinterfacesIterator();
        while (iter.hasNext()) {
            buf.append(((TypeDecl)iter.next()).classTypeSignature());
        }
        return buf.toString();
    }

    public MethodDecl unknownMethod() {
        ASTNode$State state = this.state();
        MethodDecl unknownMethod_value = this.getParent().Define_MethodDecl_unknownMethod(this, null);
        return unknownMethod_value;
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getSuperInterfaceIdListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return NameType.TYPE_NAME;
        }
        return super.Define_NameType_nameType(caller, child);
    }

    @Override
    public TypeDecl Define_TypeDecl_hostType(ASTNode caller, ASTNode child) {
        if (caller == this.getSuperInterfaceIdListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.hostType();
        }
        return super.Define_TypeDecl_hostType(caller, child);
    }

    @Override
    public boolean Define_boolean_withinSuppressWarnings(ASTNode caller, ASTNode child, String s) {
        if (caller == this.getSuperInterfaceIdListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.hasAnnotationSuppressWarnings(s) || this.withinSuppressWarnings(s);
        }
        return super.Define_boolean_withinSuppressWarnings(caller, child, s);
    }

    @Override
    public boolean Define_boolean_withinDeprecatedAnnotation(ASTNode caller, ASTNode child) {
        if (caller == this.getSuperInterfaceIdListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.isDeprecated() || this.withinDeprecatedAnnotation();
        }
        return super.Define_boolean_withinDeprecatedAnnotation(caller, child);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

