/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.BranchTargetStmt;
import AST.BreakStmt;
import AST.CodeGeneration;
import AST.ContinueStmt;
import AST.Stmt;
import AST.Variable;
import beaver.Symbol;
import java.util.HashMap;
import java.util.Map;
import jpe.Environment;

public class LabeledStmt
extends BranchTargetStmt
implements Cloneable {
    protected String tokenString_Label;
    public int Labelstart;
    public int Labelend;
    protected Map targetOf_ContinueStmt_values;
    protected Map targetOf_BreakStmt_values;
    protected boolean label_computed = false;
    protected int label_value;
    protected boolean end_label_computed = false;
    protected int end_label_value;
    protected Map lookupLabel_String_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.targetOf_ContinueStmt_values = null;
        this.targetOf_BreakStmt_values = null;
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
        this.canCompleteNormally_computed = false;
        this.label_computed = false;
        this.end_label_computed = false;
        this.lookupLabel_String_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public LabeledStmt clone() throws CloneNotSupportedException {
        LabeledStmt node = (LabeledStmt)super.clone();
        node.targetOf_ContinueStmt_values = null;
        node.targetOf_BreakStmt_values = null;
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.canCompleteNormally_computed = false;
        node.label_computed = false;
        node.end_label_computed = false;
        node.lookupLabel_String_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public LabeledStmt copy() {
        try {
            LabeledStmt node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public LabeledStmt fullCopy() {
        LabeledStmt res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void nameCheck() {
        LabeledStmt stmt = this.lookupLabel(this.getLabel());
        if (stmt != null && stmt.enclosingBodyDecl() == this.enclosingBodyDecl()) {
            this.error("Labels can not shadow labels in the same member");
        }
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.indent());
        s.append(String.valueOf(this.getLabel()) + ":");
        this.getStmt().toString(s);
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        super.createBCode(gen);
        gen.addLabel(this.label());
        this.getStmt().createBCode(gen);
        gen.addLabel(this.end_label());
    }

    @Override
    public boolean canRemove(Map<String, Boolean> usedVars) {
        this.addUsedVars(usedVars);
        this.getStmt().canRemove(usedVars);
        return false;
    }

    @Override
    public void addUsedVars(Map<String, Boolean> usedVars) {
        this.getStmt().addUsedVars(usedVars);
    }

    public LabeledStmt() {
    }

    public LabeledStmt(String p0, Stmt p1) {
        this.setLabel(p0);
        this.setChild(p1, 0);
    }

    public LabeledStmt(Symbol p0, Stmt p1) {
        this.setLabel(p0);
        this.setChild(p1, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLabel(String value) {
        this.tokenString_Label = value;
    }

    public void setLabel(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLabel is only valid for String lexemes");
        }
        this.tokenString_Label = (String)symbol.value;
        this.Labelstart = symbol.getStart();
        this.Labelend = symbol.getEnd();
    }

    public String getLabel() {
        return this.tokenString_Label != null ? this.tokenString_Label : "";
    }

    public void setStmt(Stmt node) {
        this.setChild(node, 0);
    }

    public Stmt getStmt() {
        return (Stmt)this.getChild(0);
    }

    public Stmt getStmtNoTransform() {
        return (Stmt)this.getChildNoTransform(0);
    }

    @Override
    public boolean targetOf(ContinueStmt stmt) {
        ContinueStmt _parameters = stmt;
        if (this.targetOf_ContinueStmt_values == null) {
            this.targetOf_ContinueStmt_values = new HashMap(4);
        }
        if (this.targetOf_ContinueStmt_values.containsKey(_parameters)) {
            return (Boolean)this.targetOf_ContinueStmt_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean targetOf_ContinueStmt_value = this.targetOf_compute(stmt);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.targetOf_ContinueStmt_values.put(_parameters, targetOf_ContinueStmt_value);
        }
        return targetOf_ContinueStmt_value;
    }

    private boolean targetOf_compute(ContinueStmt stmt) {
        return stmt.hasLabel() && stmt.getLabel().equals(this.getLabel());
    }

    @Override
    public boolean targetOf(BreakStmt stmt) {
        BreakStmt _parameters = stmt;
        if (this.targetOf_BreakStmt_values == null) {
            this.targetOf_BreakStmt_values = new HashMap(4);
        }
        if (this.targetOf_BreakStmt_values.containsKey(_parameters)) {
            return (Boolean)this.targetOf_BreakStmt_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean targetOf_BreakStmt_value = this.targetOf_compute(stmt);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.targetOf_BreakStmt_values.put(_parameters, targetOf_BreakStmt_value);
        }
        return targetOf_BreakStmt_value;
    }

    private boolean targetOf_compute(BreakStmt stmt) {
        return stmt.hasLabel() && stmt.getLabel().equals(this.getLabel());
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        if (!this.getStmt().isDAafter(v)) {
            return false;
        }
        for (BreakStmt stmt : this.targetBreaks()) {
            if (stmt.isDAafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        if (!this.getStmt().isDUafter(v)) {
            return false;
        }
        for (BreakStmt stmt : this.targetBreaks()) {
            if (stmt.isDUafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canCompleteNormally() {
        if (this.canCompleteNormally_computed) {
            return this.canCompleteNormally_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.canCompleteNormally_value = this.canCompleteNormally_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.canCompleteNormally_computed = true;
        }
        return this.canCompleteNormally_value;
    }

    private boolean canCompleteNormally_compute() {
        return this.getStmt().canCompleteNormally() || this.reachableBreak();
    }

    public int label() {
        if (this.label_computed) {
            return this.label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.label_value = this.label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.label_computed = true;
        }
        return this.label_value;
    }

    private int label_compute() {
        return this.hostType().constantPool().newLabel();
    }

    public int end_label() {
        if (this.end_label_computed) {
            return this.end_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.end_label_value = this.end_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.end_label_computed = true;
        }
        return this.end_label_value;
    }

    private int end_label_compute() {
        return this.hostType().constantPool().newLabel();
    }

    @Override
    public int break_label() {
        ASTNode$State state = this.state();
        int break_label_value = this.break_label_compute();
        return break_label_value;
    }

    private int break_label_compute() {
        return this.end_label();
    }

    @Override
    public int continue_label() {
        ASTNode$State state = this.state();
        int continue_label_value = this.continue_label_compute();
        return continue_label_value;
    }

    private int continue_label_compute() {
        return this.getStmt().continue_label();
    }

    @Override
    public Stmt pe(Environment env) {
        ASTNode$State state = this.state();
        Stmt pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private Stmt pe_compute(Environment env) {
        LabeledStmt newLabeledStmt = this.fullCopy();
        newLabeledStmt.setStmt(this.getStmt().pe(env));
        return newLabeledStmt;
    }

    public LabeledStmt lookupLabel(String name) {
        String _parameters = name;
        if (this.lookupLabel_String_values == null) {
            this.lookupLabel_String_values = new HashMap(4);
        }
        if (this.lookupLabel_String_values.containsKey(_parameters)) {
            return (LabeledStmt)this.lookupLabel_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        LabeledStmt lookupLabel_String_value = this.getParent().Define_LabeledStmt_lookupLabel(this, null, name);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.lookupLabel_String_values.put(_parameters, lookupLabel_String_value);
        }
        return lookupLabel_String_value;
    }

    @Override
    public LabeledStmt Define_LabeledStmt_lookupLabel(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getStmtNoTransform()) {
            return name.equals(this.getLabel()) ? this : this.lookupLabel(name);
        }
        return this.getParent().Define_LabeledStmt_lookupLabel(this, caller, name);
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getStmtNoTransform()) {
            return this.isDAbefore(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getStmtNoTransform()) {
            return this.isDUbefore(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        if (caller == this.getStmtNoTransform()) {
            return this.reachable();
        }
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

