/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.CodeGeneration;
import AST.Constant;
import AST.Expr;
import AST.TypeDecl;
import AST.Unary;
import AST.Variable;

public class LogNotExpr
extends Unary
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public LogNotExpr clone() throws CloneNotSupportedException {
        LogNotExpr node = (LogNotExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public LogNotExpr copy() {
        try {
            LogNotExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public LogNotExpr fullCopy() {
        LogNotExpr res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void typeCheck() {
        if (!this.getOperand().type().isBoolean()) {
            this.error("unary ! only operates on boolean types");
        }
    }

    @Override
    void emitOperation(CodeGeneration gen) {
        this.type().logNot(gen);
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        this.emitBooleanCondition(gen);
    }

    @Override
    public void emitEvalBranch(CodeGeneration gen) {
        this.getOperand().emitEvalBranch(gen);
    }

    public LogNotExpr() {
    }

    public LogNotExpr(Expr p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        boolean isConstant_value = this.isConstant_compute();
        return isConstant_value;
    }

    private boolean isConstant_compute() {
        return this.getOperand().isConstant();
    }

    @Override
    public Constant constant() {
        ASTNode$State state = this.state();
        Constant constant_value = this.constant_compute();
        return constant_value;
    }

    private Constant constant_compute() {
        return Constant.create(!this.getOperand().constant().booleanValue());
    }

    @Override
    public boolean isDAafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafterTrue_Variable_value = this.isDAafterTrue_compute(v);
        return isDAafterTrue_Variable_value;
    }

    private boolean isDAafterTrue_compute(Variable v) {
        return this.getOperand().isDAafterFalse(v) || this.isFalse();
    }

    @Override
    public boolean isDAafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafterFalse_Variable_value = this.isDAafterFalse_compute(v);
        return isDAafterFalse_Variable_value;
    }

    private boolean isDAafterFalse_compute(Variable v) {
        return this.getOperand().isDAafterTrue(v) || this.isTrue();
    }

    @Override
    public boolean isDAafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.isDAafterTrue(v) && this.isDAafterFalse(v);
    }

    @Override
    public boolean isDUafterTrue(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafterTrue_Variable_value = this.isDUafterTrue_compute(v);
        return isDUafterTrue_Variable_value;
    }

    private boolean isDUafterTrue_compute(Variable v) {
        return this.getOperand().isDUafterFalse(v);
    }

    @Override
    public boolean isDUafterFalse(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafterFalse_Variable_value = this.isDUafterFalse_compute(v);
        return isDUafterFalse_Variable_value;
    }

    private boolean isDUafterFalse_compute(Variable v) {
        return this.getOperand().isDUafterTrue(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        ASTNode$State state = this.state();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.isDUafterTrue(v) && this.isDUafterFalse(v);
    }

    @Override
    public String printPreOp() {
        ASTNode$State state = this.state();
        String printPreOp_value = this.printPreOp_compute();
        return printPreOp_value;
    }

    private String printPreOp_compute() {
        return "!";
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeBoolean();
    }

    @Override
    public boolean definesLabel() {
        ASTNode$State state = this.state();
        boolean definesLabel_value = this.definesLabel_compute();
        return definesLabel_value;
    }

    private boolean definesLabel_compute() {
        return true;
    }

    @Override
    public boolean canBeTrue() {
        ASTNode$State state = this.state();
        boolean canBeTrue_value = this.canBeTrue_compute();
        return canBeTrue_value;
    }

    private boolean canBeTrue_compute() {
        return this.getOperand().canBeFalse();
    }

    @Override
    public boolean canBeFalse() {
        ASTNode$State state = this.state();
        boolean canBeFalse_value = this.canBeFalse_compute();
        return canBeFalse_value;
    }

    private boolean canBeFalse_compute() {
        return this.getOperand().canBeTrue();
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getOperandNoTransform()) {
            return this.isDAbefore(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getOperandNoTransform()) {
            return this.isDUbefore(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public int Define_int_condition_false_label(ASTNode caller, ASTNode child) {
        if (caller == this.getOperandNoTransform()) {
            return this.true_label();
        }
        return this.getParent().Define_int_condition_false_label(this, caller);
    }

    @Override
    public int Define_int_condition_true_label(ASTNode caller, ASTNode child) {
        if (caller == this.getOperandNoTransform()) {
            return this.false_label();
        }
        return this.getParent().Define_int_condition_true_label(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

