/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Binary;
import AST.CodeGeneration;
import AST.Expr;
import AST.TypeDecl;

public abstract class LogicalExpr
extends Binary
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public LogicalExpr clone() throws CloneNotSupportedException {
        LogicalExpr node = (LogicalExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public void typeCheck() {
        if (!this.getLeftOperand().type().isBoolean()) {
            this.error(String.valueOf(this.getLeftOperand().type().typeName()) + " is not boolean");
        }
        if (!this.getRightOperand().type().isBoolean()) {
            this.error(String.valueOf(this.getRightOperand().type().typeName()) + " is not boolean");
        }
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        this.emitBooleanCondition(gen);
    }

    public LogicalExpr() {
    }

    public LogicalExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLeftOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getLeftOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getLeftOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public void setRightOperand(Expr node) {
        this.setChild(node, 1);
    }

    @Override
    public Expr getRightOperand() {
        return (Expr)this.getChild(1);
    }

    @Override
    public Expr getRightOperandNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeBoolean();
    }

    @Override
    public boolean definesLabel() {
        ASTNode$State state = this.state();
        boolean definesLabel_value = this.definesLabel_compute();
        return definesLabel_value;
    }

    private boolean definesLabel_compute() {
        return true;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

