/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.CodeGeneration;
import AST.Constant;
import AST.Literal;
import AST.TypeDecl;
import beaver.Symbol;

public class LongLiteral
extends Literal
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.constant_computed = false;
        this.constant_value = null;
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public LongLiteral clone() throws CloneNotSupportedException {
        LongLiteral node = (LongLiteral)super.clone();
        node.constant_computed = false;
        node.constant_value = null;
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public LongLiteral copy() {
        try {
            LongLiteral node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public LongLiteral fullCopy() {
        LongLiteral res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.getLITERAL());
        s.append("L");
    }

    @Override
    public void typeCheck() {
        if (this.constant().error) {
            this.error("The value of the long literal " + this.getLITERAL() + " is not legal");
        }
    }

    public static void push(CodeGeneration gen, long value) {
        if (value == 0L) {
            gen.emit((byte)9);
        } else if (value == 1L) {
            gen.emit((byte)10);
        } else {
            int index = gen.constantPool().addConstant(value);
            gen.emit((byte)20).add2(index);
        }
    }

    @Override
    public void emitPushConstant(CodeGeneration gen) {
        LongLiteral.push(gen, this.constant().longValue());
    }

    public LongLiteral() {
    }

    public LongLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public LongLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    @Override
    public void setLITERAL(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol.value;
        this.LITERALstart = symbol.getStart();
        this.LITERALend = symbol.getEnd();
    }

    @Override
    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    public boolean isHex() {
        ASTNode$State state = this.state();
        boolean isHex_value = this.isHex_compute();
        return isHex_value;
    }

    private boolean isHex_compute() {
        return this.getLITERAL().toLowerCase().startsWith("0x");
    }

    public boolean isOctal() {
        ASTNode$State state = this.state();
        boolean isOctal_value = this.isOctal_compute();
        return isOctal_value;
    }

    private boolean isOctal_compute() {
        return this.getLITERAL().startsWith("0");
    }

    public boolean isDecimal() {
        ASTNode$State state = this.state();
        boolean isDecimal_value = this.isDecimal_compute();
        return isDecimal_value;
    }

    private boolean isDecimal_compute() {
        return !this.isHex() && !this.isOctal();
    }

    @Override
    public boolean isPositive() {
        ASTNode$State state = this.state();
        boolean isPositive_value = this.isPositive_compute();
        return isPositive_value;
    }

    private boolean isPositive_compute() {
        return !this.getLITERAL().startsWith("-");
    }

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        try {
            return Constant.create(Literal.parseLong(this.getLITERAL()));
        }
        catch (NumberFormatException e) {
            Constant c = Constant.create(0L);
            c.error = true;
            return c;
        }
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeLong();
    }

    @Override
    public Object literalValueObject() {
        ASTNode$State state = this.state();
        Object literalValueObject_value = this.literalValueObject_compute();
        return literalValueObject_value;
    }

    private Object literalValueObject_compute() {
        return new Long(this.constant().longValue());
    }

    @Override
    public Class<?> literalValueClass() {
        ASTNode$State state = this.state();
        Class<?> literalValueClass_value = this.literalValueClass_compute();
        return literalValueClass_value;
    }

    private Class<?> literalValueClass_compute() {
        return Long.TYPE;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

