/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Access;
import AST.Attribute;
import AST.Block;
import AST.BodyDecl;
import AST.BoundMethodAccess;
import AST.BridgeMethodDecl;
import AST.CastExpr;
import AST.ClassDecl;
import AST.CodeAttribute;
import AST.CodeGeneration;
import AST.ConstantPool;
import AST.ExceptionHolder;
import AST.ExceptionsAttribute;
import AST.Expr;
import AST.ExprStmt;
import AST.List;
import AST.MemberDecl;
import AST.MethodAccess;
import AST.MethodDeclSubstituted;
import AST.Modifier;
import AST.Modifiers;
import AST.NameType;
import AST.ObjectLiteral;
import AST.Opt;
import AST.ParameterAnnotationsAttribute;
import AST.ParameterDeclaration;
import AST.Parameterization;
import AST.Program;
import AST.ReturnStmt;
import AST.SignatureAttribute;
import AST.SimpleSet;
import AST.Stmt;
import AST.SuperAccess;
import AST.SyntheticAttribute;
import AST.ThisAccess;
import AST.TypeDecl;
import AST.VarAccess;
import AST.Variable;
import AST.VariableDeclaration;
import AST.VoidType;
import beaver.Symbol;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import jpe.Environment;
import jpe.Util;

public class MethodDecl
extends MemberDecl
implements Cloneable,
SimpleSet,
Iterator,
ExceptionHolder {
    private MethodDecl iterElem;
    public boolean rewritten = false;
    private int numAccess = 1;
    protected String tokenString_ID;
    public int IDstart;
    public int IDend;
    protected Map accessibleFrom_TypeDecl_values;
    protected Map throwsException_TypeDecl_values;
    protected boolean signature_computed = false;
    protected String signature_value;
    protected Map moreSpecificThan_MethodDecl_values;
    protected Map overrides_MethodDecl_values;
    protected Map hides_MethodDecl_values;
    protected Map parameterDeclaration_String_values;
    protected boolean type_computed = false;
    protected TypeDecl type_value;
    protected boolean descName_computed = false;
    protected String descName_value;
    protected Map bytecodes_ConstantPool_values;
    protected boolean flags_computed = false;
    protected int flags_value;
    protected boolean offsetBeforeParameters_computed = false;
    protected int offsetBeforeParameters_value;
    protected boolean offsetAfterParameters_computed = false;
    protected int offsetAfterParameters_value;
    protected boolean resultOffset_computed = false;
    protected int resultOffset_value;
    protected boolean usesTypeVariable_computed = false;
    protected boolean usesTypeVariable_value;
    protected boolean sourceMethodDecl_computed = false;
    protected MethodDecl sourceMethodDecl_value;
    protected Map handlesException_TypeDecl_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.accessibleFrom_TypeDecl_values = null;
        this.throwsException_TypeDecl_values = null;
        this.signature_computed = false;
        this.signature_value = null;
        this.moreSpecificThan_MethodDecl_values = null;
        this.overrides_MethodDecl_values = null;
        this.hides_MethodDecl_values = null;
        this.parameterDeclaration_String_values = null;
        this.type_computed = false;
        this.type_value = null;
        this.attributes_computed = false;
        this.attributes_value = null;
        this.descName_computed = false;
        this.descName_value = null;
        this.bytecodes_ConstantPool_values = null;
        this.flags_computed = false;
        this.offsetBeforeParameters_computed = false;
        this.offsetAfterParameters_computed = false;
        this.resultOffset_computed = false;
        this.usesTypeVariable_computed = false;
        this.sourceMethodDecl_computed = false;
        this.sourceMethodDecl_value = null;
        this.handlesException_TypeDecl_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public MethodDecl clone() throws CloneNotSupportedException {
        MethodDecl node = (MethodDecl)super.clone();
        node.accessibleFrom_TypeDecl_values = null;
        node.throwsException_TypeDecl_values = null;
        node.signature_computed = false;
        node.signature_value = null;
        node.moreSpecificThan_MethodDecl_values = null;
        node.overrides_MethodDecl_values = null;
        node.hides_MethodDecl_values = null;
        node.parameterDeclaration_String_values = null;
        node.type_computed = false;
        node.type_value = null;
        node.attributes_computed = false;
        node.attributes_value = null;
        node.descName_computed = false;
        node.descName_value = null;
        node.bytecodes_ConstantPool_values = null;
        node.flags_computed = false;
        node.offsetBeforeParameters_computed = false;
        node.offsetAfterParameters_computed = false;
        node.resultOffset_computed = false;
        node.usesTypeVariable_computed = false;
        node.sourceMethodDecl_computed = false;
        node.sourceMethodDecl_value = null;
        node.handlesException_TypeDecl_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public MethodDecl copy() {
        try {
            MethodDecl node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public MethodDecl fullCopy() {
        MethodDecl res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public Access createBoundAccess(List args) {
        if (this.isStatic()) {
            return this.hostType().createQualifiedAccess().qualifiesAccess(new BoundMethodAccess(this.name(), args, this));
        }
        return new BoundMethodAccess(this.name(), args, this);
    }

    @Override
    public SimpleSet add(Object o) {
        return new SimpleSet.SimpleSetImpl().add(this).add(o);
    }

    @Override
    public Iterator iterator() {
        this.iterElem = this;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iterElem != null;
    }

    public Object next() {
        MethodDecl o = this.iterElem;
        this.iterElem = null;
        return o;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkModifiers() {
        super.checkModifiers();
        if (this.hostType().isClassDecl()) {
            if (this.isAbstract() && !this.hostType().isAbstract()) {
                this.error("class must be abstract to include abstract methods");
            }
            if (this.isAbstract() && this.isPrivate()) {
                this.error("method may not be abstract and private");
            }
            if (this.isAbstract() && this.isStatic()) {
                this.error("method may not be abstract and static");
            }
            if (this.isAbstract() && this.isSynchronized()) {
                this.error("method may not be abstract and synchronized");
            }
            if (this.isAbstract() && this.isNative()) {
                this.error("method may not be abstract and native");
            }
            if (this.isAbstract() && this.isStrictfp()) {
                this.error("method may not be abstract and strictfp");
            }
            if (this.isNative() && this.isStrictfp()) {
                this.error("method may not be native and strictfp");
            }
        }
        if (this.hostType().isInterfaceDecl()) {
            if (this.isStatic()) {
                this.error("interface method " + this.signature() + " in " + this.hostType().typeName() + " may not be static");
            }
            if (this.isStrictfp()) {
                this.error("interface method " + this.signature() + " in " + this.hostType().typeName() + " may not be strictfp");
            }
            if (this.isNative()) {
                this.error("interface method " + this.signature() + " in " + this.hostType().typeName() + " may not be native");
            }
            if (this.isSynchronized()) {
                this.error("interface method " + this.signature() + " in " + this.hostType().typeName() + " may not be synchronized");
            }
            if (this.isProtected()) {
                this.error("interface method " + this.signature() + " in " + this.hostType().typeName() + " may not be protected");
            }
            if (this.isPrivate()) {
                this.error("interface method " + this.signature() + " in " + this.hostType().typeName() + " may not be private");
            } else if (this.isFinal()) {
                this.error("interface method " + this.signature() + " in " + this.hostType().typeName() + " may not be final");
            }
        }
    }

    @Override
    public void nameCheck() {
        if (!this.hostType().methodsSignature(this.signature()).contains(this)) {
            this.error("method with signature " + this.signature() + " is multiply declared in type " + this.hostType().typeName());
        }
        if (this.isNative() && this.hasBlock()) {
            this.error("native methods must have an empty semicolon body");
        }
        if (this.isAbstract() && this.hasBlock()) {
            this.error("abstract methods must have an empty semicolon body");
        }
        if (!(this.hasBlock() || this.isNative() || this.isAbstract())) {
            this.error("only abstract and native methods may have an empty semicolon body");
        }
    }

    @Override
    public void toString(StringBuffer s) {
        int i;
        s.append(this.indent());
        this.getModifiers().toString(s);
        this.getTypeAccess().toString(s);
        s.append(" " + this.name() + "(");
        if (this.getNumParameter() > 0) {
            this.getParameter(0).toString(s);
            i = 1;
            while (i < this.getNumParameter()) {
                s.append(", ");
                this.getParameter(i).toString(s);
                ++i;
            }
        }
        s.append(")");
        if (this.getNumException() > 0) {
            s.append(" throws ");
            this.getException(0).toString(s);
            i = 1;
            while (i < this.getNumException()) {
                s.append(", ");
                this.getException(i).toString(s);
                ++i;
            }
        }
        if (this.hasBlock()) {
            s.append(" ");
            this.getBlock().toString(s);
        } else {
            s.append(";");
        }
    }

    @Override
    public void typeCheck() {
        TypeDecl exceptionType = this.typeThrowable();
        int i = 0;
        while (i < this.getNumException()) {
            TypeDecl typeDecl = this.getException(i).type();
            if (!typeDecl.instanceOf(exceptionType)) {
                this.error(String.valueOf(this.signature()) + " throws non throwable type " + typeDecl.fullName());
            }
            ++i;
        }
        if (!this.isVoid() && this.hasBlock() && this.getBlock().canCompleteNormally()) {
            this.error("the body of a non void method may not complete normally");
        }
    }

    public void emitInvokeMethod(CodeGeneration gen, TypeDecl hostType) {
        if (hostType.isInterfaceDecl()) {
            int size = this.type().variableSize() - 1;
            int i = 0;
            while (i < this.getNumParameter()) {
                size -= this.getParameter(i).type().variableSize();
                ++i;
            }
            String classname = hostType.constantPoolName();
            String desc = this.descName();
            String name = this.name();
            int index = gen.constantPool().addInterfaceMethodref(classname, name, desc);
            int numArg = 1;
            int i2 = 0;
            while (i2 < this.getNumParameter()) {
                numArg += this.getParameter(i2).type().variableSize();
                ++i2;
            }
            gen.emit((byte)-71, size).add2(index).add(numArg).add(0);
        } else {
            String classname = hostType.constantPoolName();
            String desc = this.descName();
            String name = this.name();
            int index = gen.constantPool().addMethodref(classname, name, desc);
            if (this.isStatic()) {
                int size = this.type().variableSize();
                int i = 0;
                while (i < this.getNumParameter()) {
                    size -= this.getParameter(i).type().variableSize();
                    ++i;
                }
                gen.emit((byte)-72, size).add2(index);
            } else {
                int size = this.type().variableSize() - 1;
                int i = 0;
                while (i < this.getNumParameter()) {
                    size -= this.getParameter(i).type().variableSize();
                    ++i;
                }
                gen.emit((byte)-74, size).add2(index);
            }
        }
    }

    public void emitInvokeSpecialMethod(CodeGeneration gen, TypeDecl hostType) {
        String classname = hostType.constantPoolName();
        String desc = this.descName();
        String name = this.name();
        int index = gen.constantPool().addMethodref(classname, name, desc);
        int size = this.type().variableSize() - 1;
        int i = 0;
        while (i < this.getNumParameter()) {
            size -= this.getParameter(i).type().variableSize();
            ++i;
        }
        gen.emit((byte)-73, size).add2(index);
    }

    private void generateBytecodes(CodeGeneration gen) {
        int label = gen.variableScopeLabel();
        if (!this.isStatic()) {
            gen.addLocalVariableEntryAtCurrentPC("this", this.hostType().typeDescriptor(), 0, label);
        }
        int i = 0;
        while (i < this.getNumParameter()) {
            ParameterDeclaration p = this.getParameter(i);
            gen.addLocalVariableEntryAtCurrentPC(p.name(), p.type().typeDescriptor(), p.localNum(), label);
            ++i;
        }
        this.createBCode(gen);
        if (this.type() instanceof VoidType) {
            gen.emitReturn();
        }
        gen.addVariableScopeLabel(label);
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        try {
            if (this.hasBlock()) {
                gen.maxLocals = Math.max(gen.maxLocals, this.getBlock().localNum());
                this.getBlock().createBCode(gen);
            }
        }
        catch (Error e) {
            System.err.println(String.valueOf(this.hostType().typeName()) + ": " + this);
            throw e;
        }
    }

    @Override
    public void generateMethod(DataOutputStream out, ConstantPool cp) throws IOException {
        out.writeChar(this.flags());
        out.writeChar(cp.addUtf8(this.name()));
        out.writeChar(cp.addUtf8(this.descName()));
        out.writeChar(this.attributes().size());
        Iterator itera = this.attributes().iterator();
        while (itera.hasNext()) {
            ((Attribute)itera.next()).emit(out);
        }
    }

    @Override
    public void touchMethod(ConstantPool cp) {
        cp.addUtf8(this.name());
        cp.addUtf8(this.descName());
        this.attributes();
    }

    @Override
    public boolean clear() {
        if (this.hasBlock()) {
            this.getBlock().clear();
            this.setBlock(new Block(new List<Stmt>()));
        }
        this.bytecodes_ConstantPool_values = null;
        return false;
    }

    public MethodDecl createAccessor(TypeDecl methodQualifier) {
        MethodDecl m = (MethodDecl)methodQualifier.getAccessor(this, "method");
        if (m != null) {
            return m;
        }
        int accessorIndex = methodQualifier.accessorCounter++;
        List<ParameterDeclaration> parameterList = new List<ParameterDeclaration>();
        int i = 0;
        while (i < this.getNumParameter()) {
            parameterList.add(new ParameterDeclaration(this.getParameter(i).type(), this.getParameter(i).name()));
            ++i;
        }
        List<Access> exceptionList = new List<Access>();
        int i2 = 0;
        while (i2 < this.getNumException()) {
            exceptionList.add(this.getException(i2).type().createQualifiedAccess());
            ++i2;
        }
        Modifiers modifiers = new Modifiers(new List<Modifier>());
        if (this.getModifiers().isStatic()) {
            modifiers.addModifier(new Modifier("static"));
        }
        modifiers.addModifier(new Modifier("synthetic"));
        modifiers.addModifier(new Modifier("public"));
        m = new MethodDecl(modifiers, this.type().createQualifiedAccess(), String.valueOf(this.name()) + "$access$" + accessorIndex, parameterList, exceptionList, new Opt<Block>(new Block(new List<Stmt>().add(this.createAccessorStmt()))));
        m = methodQualifier.addMemberMethod(m);
        methodQualifier.addAccessor(this, "method", m);
        return m;
    }

    private Stmt createAccessorStmt() {
        List<VarAccess> argumentList = new List<VarAccess>();
        int i = 0;
        while (i < this.getNumParameter()) {
            argumentList.add(new VarAccess(this.getParameter(i).name()));
            ++i;
        }
        Access access = new BoundMethodAccess(this.name(), argumentList, this);
        if (!this.isStatic()) {
            access = new ThisAccess("this").qualifiesAccess(access);
        }
        return this.isVoid() ? new ExprStmt(access) : new ReturnStmt(new Opt<Expr>(access));
    }

    public MethodDecl createSuperAccessor(TypeDecl methodQualifier) {
        MethodDecl m = (MethodDecl)methodQualifier.getAccessor(this, "method_super");
        if (m != null) {
            return m;
        }
        int accessorIndex = methodQualifier.accessorCounter++;
        List<ParameterDeclaration> parameters = new List<ParameterDeclaration>();
        List<Expr> args = new List<Expr>();
        int i = 0;
        while (i < this.getNumParameter()) {
            parameters.add(new ParameterDeclaration(this.getParameter(i).type(), this.getParameter(i).name()));
            args.add(new VarAccess(this.getParameter(i).name()));
            ++i;
        }
        Stmt stmt = this.type().isVoid() ? new ExprStmt(new SuperAccess("super").qualifiesAccess(new MethodAccess(this.name(), args))) : new ReturnStmt(new Opt<Expr>(new SuperAccess("super").qualifiesAccess(new MethodAccess(this.name(), args))));
        m = new MethodDecl(new Modifiers(new List<Modifier>().add(new Modifier("synthetic"))), this.type().createQualifiedAccess(), String.valueOf(this.name()) + "$access$" + accessorIndex, parameters, new List<Access>(), new Opt<Block>(new Block(new List<ExprStmt>().add((ExprStmt)stmt))));
        m = methodQualifier.addMemberMethod(m);
        methodQualifier.addAccessor(this, "method_super", m);
        return m;
    }

    @Override
    public BodyDecl p(Parameterization parTypeDecl) {
        MethodDeclSubstituted m = new MethodDeclSubstituted(this.getModifiers().fullCopy(), this.getTypeAccess().type().substituteReturnType(parTypeDecl), this.getID(), (List<ParameterDeclaration>)this.getParameterList().substitute(parTypeDecl), (List<Access>)this.getExceptionList().substitute(parTypeDecl), new Opt<Block>(), this);
        return m;
    }

    public void addRuntimeVisibleParameterAnnotationsAttribute(Collection c) {
        boolean foundVisibleAnnotations = false;
        ArrayList<Collection> annotations = new ArrayList<Collection>(this.getNumParameter());
        int i = 0;
        while (i < this.getNumParameter()) {
            Collection a = this.getParameter(i).getModifiers().runtimeVisibleAnnotations();
            if (!a.isEmpty()) {
                foundVisibleAnnotations = true;
            }
            annotations.add(a);
            ++i;
        }
        if (foundVisibleAnnotations) {
            c.add(new ParameterAnnotationsAttribute(this.hostType().constantPool(), annotations, "RuntimeVisibleParameterAnnotations"));
        }
    }

    public void addRuntimeInvisibleParameterAnnotationsAttribute(Collection c) {
        boolean foundInvisibleAnnotations = false;
        ArrayList<Collection> annotations = new ArrayList<Collection>(this.getNumParameter());
        int i = 0;
        while (i < this.getNumParameter()) {
            Collection a = this.getParameter(i).getModifiers().runtimeInvisibleAnnotations();
            if (!a.isEmpty()) {
                foundInvisibleAnnotations = true;
            }
            annotations.add(a);
            ++i;
        }
        if (foundInvisibleAnnotations) {
            c.add(new ParameterAnnotationsAttribute(this.hostType().constantPool(), annotations, "RuntimeInvisibleParameterAnnotations"));
        }
    }

    @Override
    public void transformation() {
        super.transformation();
        HashSet<String> processed = new HashSet<String>();
        Iterator iter = this.hostType().bridgeCandidates(this.signature()).iterator();
        while (iter.hasNext()) {
            MethodDecl erased;
            MethodDecl m = (MethodDecl)iter.next();
            if (!this.overrides(m) || (erased = m.erasedMethod()).signature().equals(this.signature()) && erased.type().erasure() == this.type().erasure()) continue;
            StringBuffer keyBuffer = new StringBuffer();
            int i = 0;
            while (i < this.getNumParameter()) {
                keyBuffer.append(erased.getParameter(i).type().erasure().fullName());
                ++i;
            }
            keyBuffer.append(erased.type().erasure().fullName());
            String key = keyBuffer.toString();
            if (processed.contains(key)) continue;
            processed.add(key);
            List<CastExpr> args = new List<CastExpr>();
            List<ParameterDeclaration> parameters = new List<ParameterDeclaration>();
            int i2 = 0;
            while (i2 < this.getNumParameter()) {
                args.add(new CastExpr(this.getParameter(i2).type().erasure().createBoundAccess(), new VarAccess("p" + i2)));
                parameters.add(new ParameterDeclaration(erased.getParameter(i2).type().erasure(), "p" + i2));
                ++i2;
            }
            Stmt stmt = this.type().isVoid() ? new ExprStmt(this.createBoundAccess(args)) : new ReturnStmt(this.createBoundAccess(args));
            List<Modifier> modifiersList = new List<Modifier>();
            if (this.isPublic()) {
                modifiersList.add(new Modifier("public"));
            } else if (this.isProtected()) {
                modifiersList.add(new Modifier("protected"));
            } else if (this.isPrivate()) {
                modifiersList.add(new Modifier("private"));
            }
            BridgeMethodDecl bridge = new BridgeMethodDecl(new Modifiers(modifiersList), (Access)erased.type().erasure().createBoundAccess(), erased.name(), parameters, (List<Access>)this.getExceptionList().fullCopy(), new Opt<Block>(new Block(new List<ExprStmt>().add((ExprStmt)stmt))));
            this.hostType().addBodyDecl(bridge);
        }
    }

    public void incAccessCount() {
        ++this.numAccess;
    }

    public boolean singleAccess() {
        return this.numAccess == 1;
    }

    public static String generateMethodName(Environment env, MethodDecl mDecl) {
        StringBuffer mName = new StringBuffer(String.valueOf(mDecl.name()) + "$" + Util.getNextNameSeqNum());
        if (mDecl.getNumParameter() > 0) {
            int i = 0;
            while (i < mDecl.getNumParameter()) {
                ParameterDeclaration p = mDecl.getParameter(i);
                if (env.contains(p) && !(env.lookup(p) instanceof ObjectLiteral)) {
                    mName.append("_" + p.name() + "_" + Util.getNextNameSeqNum());
                }
                ++i;
            }
        }
        return mName.toString();
    }

    private MethodDecl findDeclared(String name) {
        return this.hostType().findDeclared(name);
    }

    public MethodDecl peAndRegister(Environment env, List<Expr> args, java.util.List<Integer> staticIndices, String methodName, Expr target) {
        MethodDecl m = this.findDeclared(methodName);
        if (m != null) {
            m.incAccessCount();
            return m;
        }
        m = this.pevaluate(env, args, staticIndices, methodName, target);
        if (!Expr.isStatic(target)) {
            for (ClassDecl c : this.hostType().subClasses()) {
                SimpleSet s = c.methodsSignature(this.signature());
                assert (s.size() <= 1);
                if (s.size() != 1) continue;
                MethodDecl overrider = (MethodDecl)s.iterator().next();
                overrider.peAndRegister(env, args, staticIndices, methodName, target);
            }
        }
        return m;
    }

    public MethodDecl pevaluate(Environment env, List<Expr> args, java.util.List<Integer> staticIndices, String methodName, Expr target) {
        MethodDecl m = new MethodDecl(true);
        m.setID(methodName);
        m.setModifiers(this.getModifiers().fullCopy());
        m.setExceptionList((List<Access>)this.getExceptionList().fullCopy());
        m.setTypeAccess(this.getTypeAccess());
        this.hostType().addGeneratedMethod(methodName, m);
        this.hostType().addMemberMethod(m);
        ObjectLiteral targetObject = null;
        if (target instanceof ObjectLiteral) {
            targetObject = (ObjectLiteral)target;
        }
        env.inStack(targetObject);
        Block b = new Block();
        b.setParent(this);
        int i = 0;
        while (i < args.getNumChild()) {
            ParameterDeclaration p = this.getParameter(i);
            if (staticIndices.contains(i)) {
                Expr val = (Expr)args.getChild(i);
                env.add(p, val);
                if (!(val instanceof ObjectLiteral)) {
                    b.addStmt(new VariableDeclaration(p.getModifiers().fullCopy(), p.getTypeAccess(), p.name(), new Opt<Expr>(val)));
                }
            } else {
                m.addParameter(p.fullCopy());
            }
            ++i;
        }
        Opt<Block> peBlock = new Opt<Block>();
        peBlock.setParent(m);
        if (this.hasBlock()) {
            peBlock.addChild(this.getBlock().peCatch(env, b));
        }
        m.setBlockOpt(peBlock);
        m.remUnusedVars();
        env.outStack();
        return m;
    }

    public MethodDecl(boolean rewritten) {
        this();
        this.rewritten = rewritten;
    }

    public void remUnusedVars() {
        if (this.hasBlock()) {
            this.getBlock().remUnusedVars();
        }
    }

    public MethodDecl() {
        this.setChild(new List(), 2);
        this.setChild(new List(), 3);
        this.setChild(new Opt(), 4);
    }

    public MethodDecl(Modifiers p0, Access p1, String p2, List<ParameterDeclaration> p3, List<Access> p4, Opt<Block> p5) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
        this.setID(p2);
        this.setChild(p3, 2);
        this.setChild(p4, 3);
        this.setChild(p5, 4);
    }

    public MethodDecl(Modifiers p0, Access p1, Symbol p2, List<ParameterDeclaration> p3, List<Access> p4, Opt<Block> p5) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
        this.setID(p2);
        this.setChild(p3, 2);
        this.setChild(p4, 3);
        this.setChild(p5, 4);
    }

    @Override
    protected int numChildren() {
        return 5;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setModifiers(Modifiers node) {
        this.setChild(node, 0);
    }

    public Modifiers getModifiers() {
        return (Modifiers)this.getChild(0);
    }

    public Modifiers getModifiersNoTransform() {
        return (Modifiers)this.getChildNoTransform(0);
    }

    public void setTypeAccess(Access node) {
        this.setChild(node, 1);
    }

    public Access getTypeAccess() {
        return (Access)this.getChild(1);
    }

    public Access getTypeAccessNoTransform() {
        return (Access)this.getChildNoTransform(1);
    }

    public void setID(String value) {
        this.tokenString_ID = value;
    }

    public void setID(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol.value;
        this.IDstart = symbol.getStart();
        this.IDend = symbol.getEnd();
    }

    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    public void setParameterList(List<ParameterDeclaration> list) {
        this.setChild(list, 2);
    }

    public int getNumParameter() {
        return this.getParameterList().getNumChild();
    }

    public ParameterDeclaration getParameter(int i) {
        return (ParameterDeclaration)this.getParameterList().getChild(i);
    }

    public void addParameter(ParameterDeclaration node) {
        List<ParameterDeclaration> list = this.parent == null || state == null ? this.getParameterListNoTransform() : this.getParameterList();
        list.addChild(node);
    }

    public void addParameterNoTransform(ParameterDeclaration node) {
        List<ParameterDeclaration> list = this.getParameterListNoTransform();
        list.addChild(node);
    }

    public void setParameter(ParameterDeclaration node, int i) {
        List<ParameterDeclaration> list = this.getParameterList();
        list.setChild(node, i);
    }

    public List<ParameterDeclaration> getParameters() {
        return this.getParameterList();
    }

    public List<ParameterDeclaration> getParametersNoTransform() {
        return this.getParameterListNoTransform();
    }

    public List<ParameterDeclaration> getParameterList() {
        List list = (List)this.getChild(2);
        list.getNumChild();
        return list;
    }

    public List<ParameterDeclaration> getParameterListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    public void setExceptionList(List<Access> list) {
        this.setChild(list, 3);
    }

    @Override
    public int getNumException() {
        return this.getExceptionList().getNumChild();
    }

    @Override
    public Access getException(int i) {
        return (Access)this.getExceptionList().getChild(i);
    }

    public void addException(Access node) {
        List<Access> list = this.parent == null || state == null ? this.getExceptionListNoTransform() : this.getExceptionList();
        list.addChild(node);
    }

    public void addExceptionNoTransform(Access node) {
        List<Access> list = this.getExceptionListNoTransform();
        list.addChild(node);
    }

    public void setException(Access node, int i) {
        List<Access> list = this.getExceptionList();
        list.setChild(node, i);
    }

    public List<Access> getExceptions() {
        return this.getExceptionList();
    }

    public List<Access> getExceptionsNoTransform() {
        return this.getExceptionListNoTransform();
    }

    public List<Access> getExceptionList() {
        List list = (List)this.getChild(3);
        list.getNumChild();
        return list;
    }

    public List<Access> getExceptionListNoTransform() {
        return (List)this.getChildNoTransform(3);
    }

    public void setBlockOpt(Opt<Block> opt) {
        this.setChild(opt, 4);
    }

    public boolean hasBlock() {
        return this.getBlockOpt().getNumChild() != 0;
    }

    public Block getBlock() {
        return (Block)this.getBlockOpt().getChild(0);
    }

    public void setBlock(Block node) {
        this.getBlockOpt().setChild(node, 0);
    }

    public Opt<Block> getBlockOpt() {
        return (Opt)this.getChild(4);
    }

    public Opt<Block> getBlockOptNoTransform() {
        return (Opt)this.getChildNoTransform(4);
    }

    private boolean refined_MethodDecl_MethodDecl_moreSpecificThan_MethodDecl(MethodDecl m) {
        if (this.getNumParameter() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.getNumParameter()) {
            if (!this.getParameter(i).type().instanceOf(m.getParameter(i).type())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Collection refined_Attributes_MethodDecl_attributes() {
        ArrayList<Attribute> l = new ArrayList<Attribute>();
        l.add(new ExceptionsAttribute(this.bytecodes(this.hostType().constantPool()), this));
        if (this.isAbstract() || this.isNative()) {
            return l;
        }
        l.add(new CodeAttribute(this.bytecodes(this.hostType().constantPool()), this));
        if (this.getModifiers().isSynthetic()) {
            l.add(new SyntheticAttribute(this.hostType().constantPool()));
        }
        return l;
    }

    private int refined_Flags_MethodDecl_flags() {
        int res = 0;
        if (this.isPublic()) {
            res |= 1;
        }
        if (this.isPrivate()) {
            res |= 2;
        }
        if (this.isProtected()) {
            res |= 4;
        }
        if (this.isStatic()) {
            res |= 8;
        }
        if (this.isFinal()) {
            res |= 0x10;
        }
        if (this.isSynchronized()) {
            res |= 0x20;
        }
        if (this.isNative()) {
            res |= 0x100;
        }
        if (this.isAbstract()) {
            res |= 0x400;
        }
        if (this.isStrictfp() || this.hostType().isStrictfp() && !this.hostType().isInterfaceDecl()) {
            res |= 0x800;
        }
        return res;
    }

    private Collection refined_AnnotationsCodegen_MethodDecl_attributes() {
        Collection c = this.refined_Attributes_MethodDecl_attributes();
        this.getModifiers().addRuntimeVisibleAnnotationsAttribute(c);
        this.getModifiers().addRuntimeInvisibleAnnotationsAttribute(c);
        this.addRuntimeVisibleParameterAnnotationsAttribute(c);
        this.addRuntimeInvisibleParameterAnnotationsAttribute(c);
        return c;
    }

    public boolean accessibleFrom(TypeDecl type) {
        TypeDecl _parameters = type;
        if (this.accessibleFrom_TypeDecl_values == null) {
            this.accessibleFrom_TypeDecl_values = new HashMap(4);
        }
        if (this.accessibleFrom_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.accessibleFrom_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean accessibleFrom_TypeDecl_value = this.accessibleFrom_compute(type);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.accessibleFrom_TypeDecl_values.put(_parameters, accessibleFrom_TypeDecl_value);
        }
        return accessibleFrom_TypeDecl_value;
    }

    private boolean accessibleFrom_compute(TypeDecl type) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isProtected()) {
            if (this.hostPackage().equals(type.hostPackage())) {
                return true;
            }
            return type.withinBodyThatSubclasses(this.hostType()) != null;
        }
        if (this.isPrivate()) {
            return this.hostType().topLevelType() == type.topLevelType();
        }
        return this.hostPackage().equals(type.hostPackage());
    }

    @Override
    public int size() {
        ASTNode$State state = this.state();
        int size_value = this.size_compute();
        return size_value;
    }

    private int size_compute() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        ASTNode$State state = this.state();
        boolean isEmpty_value = this.isEmpty_compute();
        return isEmpty_value;
    }

    private boolean isEmpty_compute() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        ASTNode$State state = this.state();
        boolean contains_Object_value = this.contains_compute(o);
        return contains_Object_value;
    }

    private boolean contains_compute(Object o) {
        return this == o;
    }

    @Override
    public int lineNumber() {
        ASTNode$State state = this.state();
        int lineNumber_value = this.lineNumber_compute();
        return lineNumber_value;
    }

    private int lineNumber_compute() {
        return MethodDecl.getLine(this.IDstart);
    }

    public boolean throwsException(TypeDecl exceptionType) {
        TypeDecl _parameters = exceptionType;
        if (this.throwsException_TypeDecl_values == null) {
            this.throwsException_TypeDecl_values = new HashMap(4);
        }
        if (this.throwsException_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.throwsException_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean throwsException_TypeDecl_value = this.throwsException_compute(exceptionType);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.throwsException_TypeDecl_values.put(_parameters, throwsException_TypeDecl_value);
        }
        return throwsException_TypeDecl_value;
    }

    private boolean throwsException_compute(TypeDecl exceptionType) {
        int i = 0;
        while (i < this.getNumException()) {
            if (exceptionType.instanceOf(this.getException(i).type())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String name() {
        ASTNode$State state = this.state();
        String name_value = this.name_compute();
        return name_value;
    }

    private String name_compute() {
        return this.getID();
    }

    public String signature() {
        if (this.signature_computed) {
            return this.signature_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.signature_value = this.signature_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.signature_computed = true;
        }
        return this.signature_value;
    }

    private String signature_compute() {
        StringBuffer s = new StringBuffer();
        s.append(String.valueOf(this.name()) + "(");
        int i = 0;
        while (i < this.getNumParameter()) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(this.getParameter(i).type().erasure().typeName());
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    public boolean sameSignature(MethodDecl m) {
        ASTNode$State state = this.state();
        boolean sameSignature_MethodDecl_value = this.sameSignature_compute(m);
        return sameSignature_MethodDecl_value;
    }

    private boolean sameSignature_compute(MethodDecl m) {
        return this.signature().equals(m.signature());
    }

    public boolean moreSpecificThan(MethodDecl m) {
        MethodDecl _parameters = m;
        if (this.moreSpecificThan_MethodDecl_values == null) {
            this.moreSpecificThan_MethodDecl_values = new HashMap(4);
        }
        if (this.moreSpecificThan_MethodDecl_values.containsKey(_parameters)) {
            return (Boolean)this.moreSpecificThan_MethodDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean moreSpecificThan_MethodDecl_value = this.moreSpecificThan_compute(m);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.moreSpecificThan_MethodDecl_values.put(_parameters, moreSpecificThan_MethodDecl_value);
        }
        return moreSpecificThan_MethodDecl_value;
    }

    private boolean moreSpecificThan_compute(MethodDecl m) {
        if (!this.isVariableArity() && !m.isVariableArity()) {
            return this.refined_MethodDecl_MethodDecl_moreSpecificThan_MethodDecl(m);
        }
        int num = Math.max(this.getNumParameter(), m.getNumParameter());
        int i = 0;
        while (i < num) {
            TypeDecl t2;
            TypeDecl t1 = i < this.getNumParameter() - 1 ? this.getParameter(i).type() : this.getParameter(this.getNumParameter() - 1).type().componentType();
            TypeDecl typeDecl = t2 = i < m.getNumParameter() - 1 ? m.getParameter(i).type() : m.getParameter(m.getNumParameter() - 1).type().componentType();
            if (!t1.instanceOf(t2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean overrides(MethodDecl m) {
        MethodDecl _parameters = m;
        if (this.overrides_MethodDecl_values == null) {
            this.overrides_MethodDecl_values = new HashMap(4);
        }
        if (this.overrides_MethodDecl_values.containsKey(_parameters)) {
            return (Boolean)this.overrides_MethodDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean overrides_MethodDecl_value = this.overrides_compute(m);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.overrides_MethodDecl_values.put(_parameters, overrides_MethodDecl_value);
        }
        return overrides_MethodDecl_value;
    }

    private boolean overrides_compute(MethodDecl m) {
        return !this.isStatic() && !m.isPrivate() && m.accessibleFrom(this.hostType()) && this.hostType().instanceOf(m.hostType()) && m.signature().equals(this.signature());
    }

    public boolean hides(MethodDecl m) {
        MethodDecl _parameters = m;
        if (this.hides_MethodDecl_values == null) {
            this.hides_MethodDecl_values = new HashMap(4);
        }
        if (this.hides_MethodDecl_values.containsKey(_parameters)) {
            return (Boolean)this.hides_MethodDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean hides_MethodDecl_value = this.hides_compute(m);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.hides_MethodDecl_values.put(_parameters, hides_MethodDecl_value);
        }
        return hides_MethodDecl_value;
    }

    private boolean hides_compute(MethodDecl m) {
        return this.isStatic() && !m.isPrivate() && m.accessibleFrom(this.hostType()) && this.hostType().instanceOf(m.hostType()) && m.signature().equals(this.signature());
    }

    public SimpleSet parameterDeclaration(String name) {
        String _parameters = name;
        if (this.parameterDeclaration_String_values == null) {
            this.parameterDeclaration_String_values = new HashMap(4);
        }
        if (this.parameterDeclaration_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.parameterDeclaration_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet parameterDeclaration_String_value = this.parameterDeclaration_compute(name);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.parameterDeclaration_String_values.put(_parameters, parameterDeclaration_String_value);
        }
        return parameterDeclaration_String_value;
    }

    private SimpleSet parameterDeclaration_compute(String name) {
        int i = 0;
        while (i < this.getNumParameter()) {
            if (this.getParameter(i).name().equals(name)) {
                return this.getParameter(i);
            }
            ++i;
        }
        return SimpleSet.emptySet;
    }

    @Override
    public boolean isSynthetic() {
        ASTNode$State state = this.state();
        boolean isSynthetic_value = this.isSynthetic_compute();
        return isSynthetic_value;
    }

    private boolean isSynthetic_compute() {
        return this.getModifiers().isSynthetic();
    }

    public boolean isPublic() {
        ASTNode$State state = this.state();
        boolean isPublic_value = this.isPublic_compute();
        return isPublic_value;
    }

    private boolean isPublic_compute() {
        return this.getModifiers().isPublic() || this.hostType().isInterfaceDecl();
    }

    public boolean isPrivate() {
        ASTNode$State state = this.state();
        boolean isPrivate_value = this.isPrivate_compute();
        return isPrivate_value;
    }

    private boolean isPrivate_compute() {
        return this.getModifiers().isPrivate();
    }

    public boolean isProtected() {
        ASTNode$State state = this.state();
        boolean isProtected_value = this.isProtected_compute();
        return isProtected_value;
    }

    private boolean isProtected_compute() {
        return this.getModifiers().isProtected();
    }

    public boolean isAbstract() {
        ASTNode$State state = this.state();
        boolean isAbstract_value = this.isAbstract_compute();
        return isAbstract_value;
    }

    private boolean isAbstract_compute() {
        return this.getModifiers().isAbstract() || this.hostType().isInterfaceDecl();
    }

    @Override
    public boolean isStatic() {
        ASTNode$State state = this.state();
        boolean isStatic_value = this.isStatic_compute();
        return isStatic_value;
    }

    private boolean isStatic_compute() {
        return this.getModifiers().isStatic();
    }

    public boolean isFinal() {
        ASTNode$State state = this.state();
        boolean isFinal_value = this.isFinal_compute();
        return isFinal_value;
    }

    private boolean isFinal_compute() {
        return this.getModifiers().isFinal() || this.hostType().isFinal() || this.isPrivate();
    }

    public boolean isSynchronized() {
        ASTNode$State state = this.state();
        boolean isSynchronized_value = this.isSynchronized_compute();
        return isSynchronized_value;
    }

    private boolean isSynchronized_compute() {
        return this.getModifiers().isSynchronized();
    }

    public boolean isNative() {
        ASTNode$State state = this.state();
        boolean isNative_value = this.isNative_compute();
        return isNative_value;
    }

    private boolean isNative_compute() {
        return this.getModifiers().isNative();
    }

    public boolean isStrictfp() {
        ASTNode$State state = this.state();
        boolean isStrictfp_value = this.isStrictfp_compute();
        return isStrictfp_value;
    }

    private boolean isStrictfp_compute() {
        return this.getModifiers().isStrictfp();
    }

    @Override
    public String dumpString() {
        ASTNode$State state = this.state();
        String dumpString_value = this.dumpString_compute();
        return dumpString_value;
    }

    private String dumpString_compute() {
        return String.valueOf(this.getClass().getName()) + " [" + this.getID() + "]";
    }

    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getTypeAccess().type();
    }

    @Override
    public boolean isVoid() {
        ASTNode$State state = this.state();
        boolean isVoid_value = this.isVoid_compute();
        return isVoid_value;
    }

    private boolean isVoid_compute() {
        return this.type().isVoid();
    }

    public boolean mayOverrideReturn(MethodDecl m) {
        ASTNode$State state = this.state();
        boolean mayOverrideReturn_MethodDecl_value = this.mayOverrideReturn_compute(m);
        return mayOverrideReturn_MethodDecl_value;
    }

    private boolean mayOverrideReturn_compute(MethodDecl m) {
        return this.type().instanceOf(m.type());
    }

    @Override
    public Collection attributes() {
        if (this.attributes_computed) {
            return this.attributes_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.attributes_value = this.attributes_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.attributes_computed = true;
        }
        return this.attributes_value;
    }

    private Collection attributes_compute() {
        Collection c = this.refined_AnnotationsCodegen_MethodDecl_attributes();
        if (this.needsSignatureAttribute()) {
            c.add(new SignatureAttribute(this.hostType().constantPool(), this.methodTypeSignature()));
        }
        return c;
    }

    public String descName() {
        if (this.descName_computed) {
            return this.descName_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.descName_value = this.descName_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.descName_computed = true;
        }
        return this.descName_value;
    }

    private String descName_compute() {
        StringBuffer b = new StringBuffer();
        b.append("(");
        int i = 0;
        while (i < this.getNumParameter()) {
            b.append(this.getParameter(i).type().typeDescriptor());
            ++i;
        }
        b.append(")");
        if (this.type().elementType().isUnknown()) {
            System.out.println(this.getTypeAccess().dumpTree());
            throw new Error("Error generating descName for " + this.signature() + ", did not expect unknown return type");
        }
        b.append(this.type().typeDescriptor());
        return b.toString();
    }

    public CodeGeneration bytecodes(ConstantPool constantPool) {
        ConstantPool _parameters = constantPool;
        if (this.bytecodes_ConstantPool_values == null) {
            this.bytecodes_ConstantPool_values = new HashMap(4);
        }
        if (this.bytecodes_ConstantPool_values.containsKey(_parameters)) {
            return (CodeGeneration)this.bytecodes_ConstantPool_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        CodeGeneration bytecodes_ConstantPool_value = this.bytecodes_compute(constantPool);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.bytecodes_ConstantPool_values.put(_parameters, bytecodes_ConstantPool_value);
        }
        return bytecodes_ConstantPool_value;
    }

    private CodeGeneration bytecodes_compute(ConstantPool constantPool) {
        CodeGeneration gen = new CodeGeneration(constantPool);
        this.generateBytecodes(gen);
        if (!gen.numberFormatError()) {
            return gen;
        }
        gen = new CodeGeneration(constantPool, true);
        this.generateBytecodes(gen);
        if (!gen.numberFormatError()) {
            return gen;
        }
        throw new Error("Could not generate code for " + this.signature() + " in " + this.hostType().typeName());
    }

    public int flags() {
        if (this.flags_computed) {
            return this.flags_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.flags_value = this.flags_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.flags_computed = true;
        }
        return this.flags_value;
    }

    private int flags_compute() {
        int res = this.refined_Flags_MethodDecl_flags();
        if (this.isVariableArity()) {
            res |= 0x80;
        }
        return res;
    }

    @Override
    public boolean isBytecodeMethod() {
        ASTNode$State state = this.state();
        boolean isBytecodeMethod_value = this.isBytecodeMethod_compute();
        return isBytecodeMethod_value;
    }

    private boolean isBytecodeMethod_compute() {
        return true;
    }

    @Override
    public boolean flush() {
        ASTNode$State state = this.state();
        boolean flush_value = this.flush_compute();
        return flush_value;
    }

    private boolean flush_compute() {
        return false;
    }

    public int offsetBeforeParameters() {
        if (this.offsetBeforeParameters_computed) {
            return this.offsetBeforeParameters_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.offsetBeforeParameters_value = this.offsetBeforeParameters_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.offsetBeforeParameters_computed = true;
        }
        return this.offsetBeforeParameters_value;
    }

    private int offsetBeforeParameters_compute() {
        return this.isStatic() ? 0 : 1;
    }

    public int offsetAfterParameters() {
        if (this.offsetAfterParameters_computed) {
            return this.offsetAfterParameters_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.offsetAfterParameters_value = this.offsetAfterParameters_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.offsetAfterParameters_computed = true;
        }
        return this.offsetAfterParameters_value;
    }

    private int offsetAfterParameters_compute() {
        if (this.getNumParameter() == 0) {
            return this.offsetBeforeParameters();
        }
        return this.getParameter(this.getNumParameter() - 1).localNum() + this.getParameter(this.getNumParameter() - 1).type().variableSize();
    }

    public int resultOffset() {
        if (this.resultOffset_computed) {
            return this.resultOffset_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.resultOffset_value = this.resultOffset_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.resultOffset_computed = true;
        }
        return this.resultOffset_value;
    }

    private int resultOffset_compute() {
        return this.type().isVoid() ? 0 : this.type().variableSize();
    }

    public boolean annotationMethodOverride() {
        ASTNode$State state = this.state();
        boolean annotationMethodOverride_value = this.annotationMethodOverride_compute();
        return annotationMethodOverride_value;
    }

    private boolean annotationMethodOverride_compute() {
        return !this.hostType().ancestorMethods(this.signature()).isEmpty();
    }

    @Override
    public boolean hasAnnotationSuppressWarnings(String s) {
        ASTNode$State state = this.state();
        boolean hasAnnotationSuppressWarnings_String_value = this.hasAnnotationSuppressWarnings_compute(s);
        return hasAnnotationSuppressWarnings_String_value;
    }

    private boolean hasAnnotationSuppressWarnings_compute(String s) {
        return this.getModifiers().hasAnnotationSuppressWarnings(s);
    }

    @Override
    public boolean isDeprecated() {
        ASTNode$State state = this.state();
        boolean isDeprecated_value = this.isDeprecated_compute();
        return isDeprecated_value;
    }

    private boolean isDeprecated_compute() {
        return this.getModifiers().hasDeprecatedAnnotation();
    }

    @Override
    public boolean usesTypeVariable() {
        if (this.usesTypeVariable_computed) {
            return this.usesTypeVariable_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.usesTypeVariable_value = this.usesTypeVariable_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.usesTypeVariable_computed = true;
        }
        return this.usesTypeVariable_value;
    }

    private boolean usesTypeVariable_compute() {
        return this.getModifiers().usesTypeVariable() || this.getTypeAccess().usesTypeVariable() || this.getParameterList().usesTypeVariable() || this.getExceptionList().usesTypeVariable();
    }

    public MethodDecl sourceMethodDecl() {
        if (this.sourceMethodDecl_computed) {
            return this.sourceMethodDecl_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.sourceMethodDecl_value = this.sourceMethodDecl_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.sourceMethodDecl_computed = true;
        }
        return this.sourceMethodDecl_value;
    }

    private MethodDecl sourceMethodDecl_compute() {
        return this;
    }

    @Override
    public boolean visibleTypeParameters() {
        ASTNode$State state = this.state();
        boolean visibleTypeParameters_value = this.visibleTypeParameters_compute();
        return visibleTypeParameters_value;
    }

    private boolean visibleTypeParameters_compute() {
        return !this.isStatic();
    }

    public int arity() {
        ASTNode$State state = this.state();
        int arity_value = this.arity_compute();
        return arity_value;
    }

    private int arity_compute() {
        return this.getNumParameter();
    }

    public boolean isVariableArity() {
        ASTNode$State state = this.state();
        boolean isVariableArity_value = this.isVariableArity_compute();
        return isVariableArity_value;
    }

    private boolean isVariableArity_compute() {
        return this.getNumParameter() == 0 ? false : this.getParameter(this.getNumParameter() - 1).isVariableArity();
    }

    public ParameterDeclaration lastParameter() {
        ASTNode$State state = this.state();
        ParameterDeclaration lastParameter_value = this.lastParameter_compute();
        return lastParameter_value;
    }

    private ParameterDeclaration lastParameter_compute() {
        return this.getParameter(this.getNumParameter() - 1);
    }

    public MethodDecl erasedMethod() {
        ASTNode$State state = this.state();
        MethodDecl erasedMethod_value = this.erasedMethod_compute();
        return erasedMethod_value;
    }

    private MethodDecl erasedMethod_compute() {
        return this;
    }

    @Override
    public boolean needsSignatureAttribute() {
        ASTNode$State state = this.state();
        boolean needsSignatureAttribute_value = this.needsSignatureAttribute_compute();
        return needsSignatureAttribute_value;
    }

    private boolean needsSignatureAttribute_compute() {
        if (this.type().needsSignatureAttribute()) {
            return true;
        }
        int i = 0;
        while (i < this.getNumParameter()) {
            if (this.getParameter(i).type().needsSignatureAttribute()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String methodTypeSignature() {
        ASTNode$State state = this.state();
        String methodTypeSignature_value = this.methodTypeSignature_compute();
        return methodTypeSignature_value;
    }

    private String methodTypeSignature_compute() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int i = 0;
        while (i < this.getNumParameter()) {
            buf.append(this.getParameter(i).type().classTypeSignature());
            ++i;
        }
        buf.append(")");
        buf.append(this.type().classTypeSignature());
        i = 0;
        while (i < this.getNumException()) {
            buf.append("^" + this.getException(i).type().classTypeSignature());
            ++i;
        }
        return buf.toString();
    }

    public boolean maybeInlinable() {
        ASTNode$State state = this.state();
        boolean maybeInlinable_value = this.maybeInlinable_compute();
        return maybeInlinable_value;
    }

    private boolean maybeInlinable_compute() {
        return this.rewritten && this.singleAccess() && this.isStatic();
    }

    public MethodDecl rewrite_pe(Environment env) {
        ASTNode$State state = this.state();
        MethodDecl rewrite_pe_jpe_Environment_value = this.rewrite_pe_compute(env);
        return rewrite_pe_jpe_Environment_value;
    }

    private MethodDecl rewrite_pe_compute(Environment env) {
        MethodDecl m = this;
        StringBuffer mName = new StringBuffer(this.name());
        if (this.getNumParameter() > 0) {
            int i = 0;
            while (i < this.getNumParameter()) {
                ParameterDeclaration p = this.getParameter(i);
                if (env.contains(p)) {
                    mName.append("_" + p.name() + "_" + Util.getNextNameSeqNum());
                }
                ++i;
            }
        }
        Block oldb = this.getBlock();
        m.setBlock(new Block());
        oldb.peCatch(env, this.getBlock());
        m.setID(mName.toString());
        m.remUnusedVars();
        return m;
    }

    @Override
    public boolean hasSource() {
        ASTNode$State state = this.state();
        boolean hasSource_value = this.hasSource_compute();
        return hasSource_value;
    }

    private boolean hasSource_compute() {
        return this.hostType().compilationUnit().fromSource();
    }

    @Override
    public boolean fillInMethodDeclarations() {
        ASTNode$State state = this.state();
        boolean fillInMethodDeclarations_value = this.fillInMethodDeclarations_compute();
        return fillInMethodDeclarations_value;
    }

    private boolean fillInMethodDeclarations_compute() {
        StringBuffer s = new StringBuffer("");
        this.getModifiers().toString(s);
        this.getTypeAccess().toString(s);
        s.append(" " + this.name() + "(");
        if (this.getNumParameter() > 0) {
            this.getParameter(0).toString(s);
            int i = 1;
            while (i < this.getNumParameter()) {
                s.append(", ");
                this.getParameter(i).toString(s);
                ++i;
            }
        }
        s.append(")");
        Program root = this.getProgram();
        return root.methodDeclarations.add(this);
    }

    public MethodDecl drive(MethodDecl m) {
        ASTNode$State state = this.state();
        MethodDecl drive_MethodDecl_value = this.drive_compute(m);
        return drive_MethodDecl_value;
    }

    private MethodDecl drive_compute(MethodDecl m) {
        MethodDecl newM = this.fullCopy();
        newM.setID(String.valueOf(this.getID()) + "__" + m.getID() + "_" + Util.getNextNameSeqNum());
        MethodAccess drivenMethodAccess = new MethodAccess();
        drivenMethodAccess.setID(m.getID());
        int i = 0;
        while (i < m.getParameterList().getNumChild()) {
            ParameterDeclaration pd = m.getParameter(i).fullCopy();
            String pName = "__" + Util.getNextNameSeqNum() + "$" + pd.getID();
            pd.setID(pName);
            newM.addParameter(pd);
            drivenMethodAccess.addArg(new VarAccess(pName));
            ++i;
        }
        newM.getBlock().rewriteReturns(drivenMethodAccess);
        newM.setTypeAccess(m.getTypeAccess());
        this.hostType().addMemberMethod(newM);
        return newM;
    }

    public boolean handlesException(TypeDecl exceptionType) {
        TypeDecl _parameters = exceptionType;
        if (this.handlesException_TypeDecl_values == null) {
            this.handlesException_TypeDecl_values = new HashMap(4);
        }
        if (this.handlesException_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.handlesException_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean handlesException_TypeDecl_value = this.getParent().Define_boolean_handlesException(this, null, exceptionType);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.handlesException_TypeDecl_values.put(_parameters, handlesException_TypeDecl_value);
        }
        return handlesException_TypeDecl_value;
    }

    public MethodDecl unknownMethod() {
        ASTNode$State state = this.state();
        MethodDecl unknownMethod_value = this.getParent().Define_MethodDecl_unknownMethod(this, null);
        return unknownMethod_value;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getBlockOptNoTransform()) {
            return v.isFinal() && (v.isClassVariable() || v.isInstanceVariable()) ? true : this.isDAbefore(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getBlockOptNoTransform()) {
            return !v.isFinal() || !v.isClassVariable() && !v.isInstanceVariable();
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_handlesException(ASTNode caller, ASTNode child, TypeDecl exceptionType) {
        if (caller == this.getBlockOptNoTransform()) {
            return this.throwsException(exceptionType) || this.handlesException(exceptionType);
        }
        return this.getParent().Define_boolean_handlesException(this, caller, exceptionType);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.parameterDeclaration(name);
        }
        if (caller == this.getBlockOptNoTransform()) {
            SimpleSet set = this.parameterDeclaration(name);
            if (!set.isEmpty()) {
                return set;
            }
            return this.lookupVariable(name);
        }
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    @Override
    public boolean Define_boolean_mayBePublic(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBePublic(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeProtected(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeProtected(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBePrivate(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBePrivate(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeAbstract(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeAbstract(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeStatic(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeStatic(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeFinal(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeFinal(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeSynchronized(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeSynchronized(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeNative(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeNative(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeStrictfp(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeStrictfp(this, caller);
    }

    @Override
    public ASTNode Define_ASTNode_enclosingBlock(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockOptNoTransform()) {
            return this;
        }
        return this.getParent().Define_ASTNode_enclosingBlock(this, caller);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getExceptionListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return NameType.TYPE_NAME;
        }
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return NameType.TYPE_NAME;
        }
        if (caller == this.getTypeAccessNoTransform()) {
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public TypeDecl Define_TypeDecl_returnType(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockOptNoTransform()) {
            return this.type();
        }
        return this.getParent().Define_TypeDecl_returnType(this, caller);
    }

    @Override
    public boolean Define_boolean_inStaticContext(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockOptNoTransform()) {
            return this.isStatic();
        }
        return this.getParent().Define_boolean_inStaticContext(this, caller);
    }

    @Override
    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockOptNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    @Override
    public boolean Define_boolean_isMethodParameter(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return true;
        }
        return this.getParent().Define_boolean_isMethodParameter(this, caller);
    }

    @Override
    public boolean Define_boolean_isConstructorParameter(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return false;
        }
        return this.getParent().Define_boolean_isConstructorParameter(this, caller);
    }

    @Override
    public boolean Define_boolean_isExceptionHandlerParameter(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return false;
        }
        return this.getParent().Define_boolean_isExceptionHandlerParameter(this, caller);
    }

    @Override
    public int Define_int_localNum(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockOptNoTransform()) {
            return this.offsetAfterParameters() + this.resultOffset();
        }
        if (caller == this.getParameterListNoTransform()) {
            int index = caller.getIndexOfChild(child);
            if (index == 0) {
                return this.offsetBeforeParameters();
            }
            return this.getParameter(index - 1).localNum() + this.getParameter(index - 1).type().variableSize();
        }
        return this.getParent().Define_int_localNum(this, caller);
    }

    @Override
    public int Define_int_resultSaveLocalNum(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockOptNoTransform()) {
            return this.offsetAfterParameters();
        }
        return this.getParent().Define_int_resultSaveLocalNum(this, caller);
    }

    @Override
    public boolean Define_boolean_mayUseAnnotationTarget(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getModifiersNoTransform()) {
            return name.equals("METHOD");
        }
        return this.getParent().Define_boolean_mayUseAnnotationTarget(this, caller, name);
    }

    @Override
    public boolean Define_boolean_variableArityValid(ASTNode caller, ASTNode child) {
        if (caller == this.getParameterListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return i == this.getNumParameter() - 1;
        }
        return this.getParent().Define_boolean_variableArityValid(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

