/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Binary;
import AST.CodeGeneration;
import AST.Expr;
import AST.TypeDecl;

public abstract class RelationalExpr
extends Binary
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public RelationalExpr clone() throws CloneNotSupportedException {
        RelationalExpr node = (RelationalExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public void typeCheck() {
        if (!this.getLeftOperand().type().isNumericType()) {
            this.error(String.valueOf(this.getLeftOperand().type().typeName()) + " is not numeric");
        }
        if (!this.getRightOperand().type().isNumericType()) {
            this.error(String.valueOf(this.getRightOperand().type().typeName()) + " is not numeric");
        }
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        this.emitBooleanCondition(gen);
    }

    @Override
    public void emitEvalBranch(CodeGeneration gen) {
        if (this.isTrue()) {
            gen.emitGoto(this.true_label());
        } else if (this.isFalse()) {
            gen.emitGoto(this.false_label());
        } else {
            TypeDecl type = this.getLeftOperand().type();
            if (type.isNumericType()) {
                type = this.binaryNumericPromotedType();
                this.getLeftOperand().createBCode(gen);
                this.getLeftOperand().type().emitCastTo(gen, type);
                this.getRightOperand().createBCode(gen);
                this.getRightOperand().type().emitCastTo(gen, type);
            } else {
                this.getLeftOperand().createBCode(gen);
                this.getRightOperand().createBCode(gen);
            }
            this.compareBranch(gen, this.true_label(), type);
            gen.emitGoto(this.false_label());
        }
    }

    public void compareBranch(CodeGeneration gen, int label, TypeDecl typeDecl) {
        throw new Error("compareBranch not supported for " + this.getClass().getName());
    }

    public void compareNotBranch(CodeGeneration gen, int label, TypeDecl typeDecl) {
        throw new Error("compareBranch not supported for " + this.getClass().getName());
    }

    public RelationalExpr() {
    }

    public RelationalExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLeftOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getLeftOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getLeftOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public void setRightOperand(Expr node) {
        this.setChild(node, 1);
    }

    @Override
    public Expr getRightOperand() {
        return (Expr)this.getChild(1);
    }

    @Override
    public Expr getRightOperandNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeBoolean();
    }

    @Override
    public boolean definesLabel() {
        ASTNode$State state = this.state();
        boolean definesLabel_value = this.definesLabel_compute();
        return definesLabel_value;
    }

    private boolean definesLabel_compute() {
        return false;
    }

    @Override
    public int Define_int_condition_false_label(ASTNode caller, ASTNode child) {
        if (caller == this.getRightOperandNoTransform()) {
            return this.false_label();
        }
        if (caller == this.getLeftOperandNoTransform()) {
            return this.false_label();
        }
        return this.getParent().Define_int_condition_false_label(this, caller);
    }

    @Override
    public int Define_int_condition_true_label(ASTNode caller, ASTNode child) {
        if (caller == this.getRightOperandNoTransform()) {
            return this.true_label();
        }
        if (caller == this.getLeftOperandNoTransform()) {
            return this.true_label();
        }
        return this.getParent().Define_int_condition_true_label(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

