/*
 * Decompiled with CFR 0.152.
 */
package AST;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public interface SimpleSet {
    public static final SimpleSet emptySet = new SimpleSet(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public SimpleSet add(Object o) {
            if (o instanceof SimpleSet) {
                return (SimpleSet)o;
            }
            return new SimpleSetImpl().add(o);
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator iterator() {
            return Collections.EMPTY_LIST.iterator();
        }
    };
    public static final SimpleSet fullSet = new SimpleSet(){

        @Override
        public int size() {
            throw new Error("Operation size not supported on the full set");
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public SimpleSet add(Object o) {
            return this;
        }

        @Override
        public boolean contains(Object o) {
            return true;
        }

        @Override
        public Iterator iterator() {
            throw new Error("Operation iterator not support on the full set");
        }
    };

    public int size();

    public boolean isEmpty();

    public SimpleSet add(Object var1);

    public Iterator iterator();

    public boolean contains(Object var1);

    public static class SimpleSetImpl
    implements SimpleSet {
        private HashSet internalSet;

        public SimpleSetImpl() {
            this.internalSet = new HashSet(4);
        }

        private SimpleSetImpl(SimpleSetImpl set) {
            this.internalSet = new HashSet(set.internalSet);
        }

        @Override
        public int size() {
            return this.internalSet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.internalSet.isEmpty();
        }

        @Override
        public SimpleSet add(Object o) {
            if (this.internalSet.contains(o)) {
                return this;
            }
            SimpleSetImpl set = new SimpleSetImpl(this);
            set.internalSet.add(o);
            return set;
        }

        @Override
        public Iterator iterator() {
            return this.internalSet.iterator();
        }

        @Override
        public boolean contains(Object o) {
            return this.internalSet.contains(o);
        }
    }
}

