/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.ArrayAccess;
import AST.Block;
import AST.BranchTargetStmt;
import AST.BreakStmt;
import AST.Case;
import AST.CodeGeneration;
import AST.ConstCase;
import AST.ContinueStmt;
import AST.DefaultCase;
import AST.Expr;
import AST.List;
import AST.MethodAccess;
import AST.TypeDecl;
import AST.Variable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class SwitchStmt
extends BranchTargetStmt
implements Cloneable {
    protected Map targetOf_ContinueStmt_values;
    protected Map targetOf_BreakStmt_values;
    protected boolean defaultCase_computed = false;
    protected DefaultCase defaultCase_value;
    protected boolean end_label_computed = false;
    protected int end_label_value;
    protected boolean typeInt_computed = false;
    protected TypeDecl typeInt_value;
    protected boolean typeLong_computed = false;
    protected TypeDecl typeLong_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.targetOf_ContinueStmt_values = null;
        this.targetOf_BreakStmt_values = null;
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
        this.canCompleteNormally_computed = false;
        this.defaultCase_computed = false;
        this.defaultCase_value = null;
        this.end_label_computed = false;
        this.typeInt_computed = false;
        this.typeInt_value = null;
        this.typeLong_computed = false;
        this.typeLong_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public SwitchStmt clone() throws CloneNotSupportedException {
        SwitchStmt node = (SwitchStmt)super.clone();
        node.targetOf_ContinueStmt_values = null;
        node.targetOf_BreakStmt_values = null;
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.canCompleteNormally_computed = false;
        node.defaultCase_computed = false;
        node.defaultCase_value = null;
        node.end_label_computed = false;
        node.typeInt_computed = false;
        node.typeInt_value = null;
        node.typeLong_computed = false;
        node.typeLong_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public SwitchStmt copy() {
        try {
            SwitchStmt node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public SwitchStmt fullCopy() {
        SwitchStmt res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.indent());
        s.append("switch (");
        this.getExpr().toString(s);
        s.append(")");
        this.getBlock().toString(s);
    }

    private int emitPad(CodeGeneration gen) {
        int pad = (4 - gen.pos() % 4) % 4;
        int i = 0;
        while (i < pad) {
            gen.emit((byte)0);
            ++i;
        }
        if (gen.pos() % 4 != 0) {
            throw new Error("Switch not at 4-byte boundary:" + gen.pos());
        }
        return pad;
    }

    private int defaultOffset(CodeGeneration gen, int switch_label) {
        boolean hasDefault;
        boolean bl = hasDefault = this.defaultCase() != null;
        if (hasDefault) {
            int offset = gen.addressOf(this.defaultCase().label(gen)) - gen.addressOf(switch_label);
            return offset;
        }
        return 0;
    }

    @Override
    public void transformation() {
        if (this.getExpr().type().isEnumDecl()) {
            TypeDecl type = this.getExpr().type();
            this.hostType().createEnumArray(type);
            this.hostType().createEnumMethod(type);
            this.setExpr(this.hostType().createEnumMethod(type).createBoundAccess(new List()).qualifiesAccess(new ArrayAccess(((Expr)this.getExpr().fullCopy()).qualifiesAccess(new MethodAccess("ordinal", new List<Expr>())))));
        }
        super.transformation();
    }

    public SwitchStmt() {
    }

    public SwitchStmt(Expr p0, Block p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setExpr(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(0);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setBlock(Block node) {
        this.setChild(node, 1);
    }

    public Block getBlock() {
        return (Block)this.getChild(1);
    }

    public Block getBlockNoTransform() {
        return (Block)this.getChildNoTransform(1);
    }

    @Override
    public void typeCheck() {
        TypeDecl type = this.getExpr().type();
        if (!(type.isIntegralType() && !type.isLong() || type.isEnumDecl())) {
            this.error("Switch expression must be of char, byte, short, int, or enum type");
        }
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        super.createBCode(gen);
        int cond_label = this.hostType().constantPool().newLabel();
        int switch_label = this.hostType().constantPool().newLabel();
        gen.emitGoto(cond_label);
        this.getBlock().createBCode(gen);
        if (this.canCompleteNormally()) {
            gen.emitGoto(this.end_label());
        }
        gen.addLabel(cond_label);
        this.getExpr().createBCode(gen);
        if (this.getExpr().type().isReferenceType()) {
            this.getExpr().type().emitUnboxingOperation(gen);
        }
        TreeMap<Integer, ConstCase> map = new TreeMap<Integer, ConstCase>();
        int i = 0;
        while (i < this.getBlock().getNumStmt()) {
            if (this.getBlock().getStmt(i) instanceof ConstCase) {
                ConstCase ca = (ConstCase)this.getBlock().getStmt(i);
                map.put(new Integer(ca.getValue().constant().intValue()), ca);
            }
            ++i;
        }
        long low = map.isEmpty() ? 0 : (Integer)map.firstKey();
        long high = map.isEmpty() ? 0 : (Integer)map.lastKey();
        long tableSwitchSize = 8L + (high - low + 1L) * 4L;
        long lookupSwitchSize = 4L + (long)map.size() * 8L;
        gen.addLabel(switch_label);
        if (tableSwitchSize < lookupSwitchSize) {
            gen.emit((byte)-86);
            int pad = this.emitPad(gen);
            int defaultOffset = this.defaultOffset(gen, switch_label);
            if (defaultOffset == 0) {
                defaultOffset = 1 + pad + 4 + 4 + 4 + 4 * (int)(high - low + 1L);
            }
            gen.add4(defaultOffset);
            gen.add4((int)low);
            gen.add4((int)high);
            long i2 = low;
            while (i2 <= high) {
                ConstCase ca = (ConstCase)map.get(new Integer((int)i2));
                if (ca != null) {
                    int offset = gen.addressOf(ca.label(gen)) - gen.addressOf(switch_label);
                    gen.add4(offset);
                } else {
                    gen.add4(defaultOffset);
                }
                ++i2;
            }
        } else {
            gen.emit((byte)-85);
            int pad = this.emitPad(gen);
            int defaultOffset = this.defaultOffset(gen, switch_label);
            if (defaultOffset == 0) {
                defaultOffset = 1 + pad + 4 + 4 + 8 * this.numCase();
            }
            gen.add4(defaultOffset);
            gen.add4(map.size());
            for (ConstCase ca : map.values()) {
                gen.add4(ca.getValue().constant().intValue());
                int offset = gen.addressOf(ca.label(gen)) - gen.addressOf(switch_label);
                gen.add4(offset);
            }
        }
        gen.addLabel(this.end_label());
    }

    @Override
    public boolean targetOf(ContinueStmt stmt) {
        ContinueStmt _parameters = stmt;
        if (this.targetOf_ContinueStmt_values == null) {
            this.targetOf_ContinueStmt_values = new HashMap(4);
        }
        if (this.targetOf_ContinueStmt_values.containsKey(_parameters)) {
            return (Boolean)this.targetOf_ContinueStmt_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean targetOf_ContinueStmt_value = this.targetOf_compute(stmt);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.targetOf_ContinueStmt_values.put(_parameters, targetOf_ContinueStmt_value);
        }
        return targetOf_ContinueStmt_value;
    }

    private boolean targetOf_compute(ContinueStmt stmt) {
        return false;
    }

    @Override
    public boolean targetOf(BreakStmt stmt) {
        BreakStmt _parameters = stmt;
        if (this.targetOf_BreakStmt_values == null) {
            this.targetOf_BreakStmt_values = new HashMap(4);
        }
        if (this.targetOf_BreakStmt_values.containsKey(_parameters)) {
            return (Boolean)this.targetOf_BreakStmt_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean targetOf_BreakStmt_value = this.targetOf_compute(stmt);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.targetOf_BreakStmt_values.put(_parameters, targetOf_BreakStmt_value);
        }
        return targetOf_BreakStmt_value;
    }

    private boolean targetOf_compute(BreakStmt stmt) {
        return !stmt.hasLabel();
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        if (this.noDefaultLabel() && !this.getExpr().isDAafter(v)) {
            return false;
        }
        if (this.switchLabelEndsBlock() && !this.getExpr().isDAafter(v)) {
            return false;
        }
        if (!this.assignedAfterLastStmt(v)) {
            return false;
        }
        for (BreakStmt stmt : this.targetBreaks()) {
            if (stmt.isDAafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    public boolean assignedAfterLastStmt(Variable v) {
        ASTNode$State state = this.state();
        boolean assignedAfterLastStmt_Variable_value = this.assignedAfterLastStmt_compute(v);
        return assignedAfterLastStmt_Variable_value;
    }

    private boolean assignedAfterLastStmt_compute(Variable v) {
        return this.getBlock().isDAafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        if (this.noDefaultLabel() && !this.getExpr().isDUafter(v)) {
            return false;
        }
        if (this.switchLabelEndsBlock() && !this.getExpr().isDUafter(v)) {
            return false;
        }
        if (!this.unassignedAfterLastStmt(v)) {
            return false;
        }
        for (BreakStmt stmt : this.targetBreaks()) {
            if (stmt.isDUafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    public boolean unassignedAfterLastStmt(Variable v) {
        ASTNode$State state = this.state();
        boolean unassignedAfterLastStmt_Variable_value = this.unassignedAfterLastStmt_compute(v);
        return unassignedAfterLastStmt_Variable_value;
    }

    private boolean unassignedAfterLastStmt_compute(Variable v) {
        return this.getBlock().isDUafter(v);
    }

    public boolean switchLabelEndsBlock() {
        ASTNode$State state = this.state();
        boolean switchLabelEndsBlock_value = this.switchLabelEndsBlock_compute();
        return switchLabelEndsBlock_value;
    }

    private boolean switchLabelEndsBlock_compute() {
        return this.getBlock().getNumStmt() > 0 && this.getBlock().getStmt(this.getBlock().getNumStmt() - 1) instanceof ConstCase;
    }

    public boolean lastStmtCanCompleteNormally() {
        ASTNode$State state = this.state();
        boolean lastStmtCanCompleteNormally_value = this.lastStmtCanCompleteNormally_compute();
        return lastStmtCanCompleteNormally_value;
    }

    private boolean lastStmtCanCompleteNormally_compute() {
        return this.getBlock().canCompleteNormally();
    }

    public boolean noStmts() {
        ASTNode$State state = this.state();
        boolean noStmts_value = this.noStmts_compute();
        return noStmts_value;
    }

    private boolean noStmts_compute() {
        int i = 0;
        while (i < this.getBlock().getNumStmt()) {
            if (!(this.getBlock().getStmt(i) instanceof Case)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean noStmtsAfterLastLabel() {
        ASTNode$State state = this.state();
        boolean noStmtsAfterLastLabel_value = this.noStmtsAfterLastLabel_compute();
        return noStmtsAfterLastLabel_value;
    }

    private boolean noStmtsAfterLastLabel_compute() {
        return this.getBlock().getNumStmt() > 0 && this.getBlock().getStmt(this.getBlock().getNumStmt() - 1) instanceof Case;
    }

    public boolean noDefaultLabel() {
        ASTNode$State state = this.state();
        boolean noDefaultLabel_value = this.noDefaultLabel_compute();
        return noDefaultLabel_value;
    }

    private boolean noDefaultLabel_compute() {
        int i = 0;
        while (i < this.getBlock().getNumStmt()) {
            if (this.getBlock().getStmt(i) instanceof DefaultCase) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean canCompleteNormally() {
        if (this.canCompleteNormally_computed) {
            return this.canCompleteNormally_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.canCompleteNormally_value = this.canCompleteNormally_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.canCompleteNormally_computed = true;
        }
        return this.canCompleteNormally_value;
    }

    private boolean canCompleteNormally_compute() {
        return this.lastStmtCanCompleteNormally() || this.noStmts() || this.noStmtsAfterLastLabel() || this.noDefaultLabel() || this.reachableBreak();
    }

    public DefaultCase defaultCase() {
        if (this.defaultCase_computed) {
            return this.defaultCase_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.defaultCase_value = this.defaultCase_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.defaultCase_computed = true;
        }
        return this.defaultCase_value;
    }

    private DefaultCase defaultCase_compute() {
        int i = 0;
        while (i < this.getBlock().getNumStmt()) {
            if (this.getBlock().getStmt(i) instanceof DefaultCase) {
                return (DefaultCase)this.getBlock().getStmt(i);
            }
            ++i;
        }
        return null;
    }

    public int end_label() {
        if (this.end_label_computed) {
            return this.end_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.end_label_value = this.end_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.end_label_computed = true;
        }
        return this.end_label_value;
    }

    private int end_label_compute() {
        return this.hostType().constantPool().newLabel();
    }

    public int numCase() {
        ASTNode$State state = this.state();
        int numCase_value = this.numCase_compute();
        return numCase_value;
    }

    private int numCase_compute() {
        int result = 0;
        int i = 0;
        while (i < this.getBlock().getNumStmt()) {
            if (this.getBlock().getStmt(i) instanceof Case) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    @Override
    public int break_label() {
        ASTNode$State state = this.state();
        int break_label_value = this.break_label_compute();
        return break_label_value;
    }

    private int break_label_compute() {
        return this.end_label();
    }

    public TypeDecl typeInt() {
        if (this.typeInt_computed) {
            return this.typeInt_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeInt_value = this.getParent().Define_TypeDecl_typeInt(this, null);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeInt_computed = true;
        }
        return this.typeInt_value;
    }

    public TypeDecl typeLong() {
        if (this.typeLong_computed) {
            return this.typeLong_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeLong_value = this.getParent().Define_TypeDecl_typeLong(this, null);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeLong_computed = true;
        }
        return this.typeLong_value;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getBlockNoTransform()) {
            return this.getExpr().isDAafter(v);
        }
        if (caller == this.getExprNoTransform()) {
            if (((ASTNode)((Object)v)).isDescendantTo(this)) {
                return false;
            }
            boolean result = this.isDAbefore(v);
            return result;
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getBlockNoTransform()) {
            return this.getExpr().isDUafter(v);
        }
        if (caller == this.getExprNoTransform()) {
            return this.isDUbefore(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_insideSwitch(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_insideSwitch(this, caller);
    }

    @Override
    public Case Define_Case_bind(ASTNode caller, ASTNode child, Case c) {
        if (caller == this.getBlockNoTransform()) {
            Block b = this.getBlock();
            int i = 0;
            while (i < b.getNumStmt()) {
                if (b.getStmt(i) instanceof Case && ((Case)b.getStmt(i)).constValue(c)) {
                    return (Case)b.getStmt(i);
                }
                ++i;
            }
            return null;
        }
        return this.getParent().Define_Case_bind(this, caller, c);
    }

    @Override
    public TypeDecl Define_TypeDecl_switchType(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return this.getExpr().type();
        }
        return this.getParent().Define_TypeDecl_switchType(this, caller);
    }

    @Override
    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return this.reachable();
        }
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    @Override
    public boolean Define_boolean_reportUnreachable(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return this.reachable();
        }
        return this.getParent().Define_boolean_reportUnreachable(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

