/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.AbstractDot;
import AST.Access;
import AST.Expr;
import AST.GenericTypeDecl;
import AST.ImportDecl;
import AST.List;
import AST.Literal;
import AST.MethodAccess;
import AST.NameType;
import AST.ObjectLiteral;
import AST.ParTypeAccess;
import AST.SimpleSet;
import AST.TypeDecl;
import AST.Variable;
import beaver.Symbol;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import jpe.Environment;
import jpe.Util;

public class TypeAccess
extends Access
implements Cloneable {
    protected String tokenString_Package;
    public int Packagestart;
    public int Packageend;
    protected String tokenString_ID;
    public int IDstart;
    public int IDend;
    protected boolean decls_computed = false;
    protected SimpleSet decls_value;
    protected boolean decl_computed = false;
    protected TypeDecl decl_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.decls_computed = false;
        this.decls_value = null;
        this.decl_computed = false;
        this.decl_value = null;
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public TypeAccess clone() throws CloneNotSupportedException {
        TypeAccess node = (TypeAccess)super.clone();
        node.decls_computed = false;
        node.decls_value = null;
        node.decl_computed = false;
        node.decl_value = null;
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public TypeAccess copy() {
        try {
            TypeAccess node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public TypeAccess fullCopy() {
        TypeAccess res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void accessControl() {
        super.accessControl();
        TypeDecl hostType = this.hostType();
        if (hostType != null && !hostType.isUnknown() && !this.type().accessibleFrom(hostType)) {
            this.error(this + " in " + this.hostType().fullName() + " can not access type " + this.type().fullName());
        } else if ((hostType == null || hostType.isUnknown()) && !this.type().accessibleFromPackage(this.hostPackage())) {
            this.error(this + " can not access type " + this.type().fullName());
        }
    }

    @Override
    public void nameCheck() {
        if (this.isQualified() && !this.qualifier().isTypeAccess() && !this.qualifier().isPackageAccess()) {
            this.error("can not access the type named " + this.decl().typeName() + " in this context");
        }
        if (this.decls().isEmpty()) {
            this.error("no visible type named " + this.typeName());
        }
        if (this.decls().size() > 1) {
            StringBuffer s = new StringBuffer();
            s.append("several types named " + this.name() + ":");
            Iterator iter = this.decls().iterator();
            while (iter.hasNext()) {
                TypeDecl t = (TypeDecl)iter.next();
                s.append(" " + t.typeName());
            }
            this.error(s.toString());
        }
    }

    public TypeAccess(String name, int start, int end) {
        this(name);
        this.start = start;
        this.end = end;
    }

    public TypeAccess(String typeName) {
        this("", typeName);
    }

    @Override
    public void toString(StringBuffer s) {
        if (this.decl().isReferenceType()) {
            s.append(this.nameWithPackage());
        } else {
            s.append(this.decl().name());
        }
    }

    @Override
    public void checkModifiers() {
        if (!(!this.decl().isDeprecated() || this.withinDeprecatedAnnotation() || this.hostType() != null && this.hostType().topLevelType() == this.decl().topLevelType() || this.withinSuppressWarnings("deprecation"))) {
            this.warning(String.valueOf(this.decl().typeName()) + " has been deprecated");
        }
    }

    public boolean isRaw() {
        ASTNode parent = this.getParent();
        while (parent instanceof AbstractDot) {
            parent = parent.getParent();
        }
        if (parent instanceof ParTypeAccess) {
            return false;
        }
        return !(parent instanceof ImportDecl);
    }

    @Override
    public void typeCheck() {
        TypeDecl type = this.type();
        if (type.isRawType() && type.isNestedType() && type.enclosingType().isParameterizedType() && !type.enclosingType().isRawType()) {
            this.error("Can not access a member type of a paramterized type as a raw type");
        }
    }

    public Field hasField(Class<?> c, String fieldName) {
        try {
            Field f = c.getDeclaredField(fieldName);
            return f;
        }
        catch (NoSuchFieldException e) {
            Class<?> sc = c.getSuperclass();
            if (sc != null) {
                return this.hasField(sc, fieldName);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public TypeAccess() {
    }

    public TypeAccess(String p0, String p1) {
        this.setPackage(p0);
        this.setID(p1);
    }

    public TypeAccess(Symbol p0, Symbol p1) {
        this.setPackage(p0);
        this.setID(p1);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setPackage(String value) {
        this.tokenString_Package = value;
    }

    public void setPackage(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setPackage is only valid for String lexemes");
        }
        this.tokenString_Package = (String)symbol.value;
        this.Packagestart = symbol.getStart();
        this.Packageend = symbol.getEnd();
    }

    public String getPackage() {
        return this.tokenString_Package != null ? this.tokenString_Package : "";
    }

    public void setID(String value) {
        this.tokenString_ID = value;
    }

    public void setID(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol.value;
        this.IDstart = symbol.getStart();
        this.IDend = symbol.getEnd();
    }

    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    @Override
    public void transformation() {
        super.transformation();
        if (this.type().elementType().isNestedType() && this.hostType() != null) {
            this.hostType().addUsedNestedType(this.type().elementType().erasure().sourceTypeDecl());
        }
    }

    private TypeDecl refined_TypeScopePropagation_TypeAccess_decl() {
        SimpleSet decls = this.decls();
        if (decls.size() == 1) {
            return (TypeDecl)decls.iterator().next();
        }
        return this.unknownType();
    }

    public SimpleSet decls() {
        if (this.decls_computed) {
            return this.decls_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decls_value = this.decls_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decls_computed = true;
        }
        return this.decls_value;
    }

    private SimpleSet decls_compute() {
        if (this.packageName().equals("")) {
            return this.lookupType(this.name());
        }
        TypeDecl typeDecl = this.lookupType(this.packageName(), this.name());
        if (typeDecl != null) {
            return SimpleSet.emptySet.add(typeDecl);
        }
        return SimpleSet.emptySet;
    }

    public TypeDecl decl() {
        if (this.decl_computed) {
            return this.decl_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decl_value = this.decl_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decl_computed = true;
        }
        return this.decl_value;
    }

    private TypeDecl decl_compute() {
        TypeDecl decl = this.refined_TypeScopePropagation_TypeAccess_decl();
        if (decl instanceof GenericTypeDecl && this.isRaw()) {
            return ((GenericTypeDecl)((Object)decl)).lookupParTypeDecl(new ArrayList());
        }
        return decl;
    }

    @Override
    public SimpleSet qualifiedLookupVariable(String name) {
        ASTNode$State state = this.state();
        SimpleSet qualifiedLookupVariable_String_value = this.qualifiedLookupVariable_compute(name);
        return qualifiedLookupVariable_String_value;
    }

    private SimpleSet qualifiedLookupVariable_compute(String name) {
        if (this.type().accessibleFrom(this.hostType())) {
            SimpleSet c = this.type().memberFields(name);
            c = this.keepAccessibleFields(c);
            if (this.type().isClassDecl() && c.size() == 1) {
                c = this.removeInstanceVariables(c);
            }
            return c;
        }
        return SimpleSet.emptySet;
    }

    @Override
    public String dumpString() {
        ASTNode$State state = this.state();
        String dumpString_value = this.dumpString_compute();
        return dumpString_value;
    }

    private String dumpString_compute() {
        return String.valueOf(this.getClass().getName()) + " [" + this.getPackage() + ", " + this.getID() + "]";
    }

    public String name() {
        ASTNode$State state = this.state();
        String name_value = this.name_compute();
        return name_value;
    }

    private String name_compute() {
        return this.getID();
    }

    @Override
    public String packageName() {
        ASTNode$State state = this.state();
        String packageName_value = this.packageName_compute();
        return packageName_value;
    }

    private String packageName_compute() {
        return this.getPackage();
    }

    public String nameWithPackage() {
        ASTNode$State state = this.state();
        String nameWithPackage_value = this.nameWithPackage_compute();
        return nameWithPackage_value;
    }

    private String nameWithPackage_compute() {
        return this.getPackage().equals("") ? this.name() : String.valueOf(this.getPackage()) + "." + this.name();
    }

    @Override
    public String typeName() {
        ASTNode$State state = this.state();
        String typeName_value = this.typeName_compute();
        return typeName_value;
    }

    private String typeName_compute() {
        return this.isQualified() ? String.valueOf(this.qualifier().typeName()) + "." + this.name() : this.nameWithPackage();
    }

    @Override
    public boolean isTypeAccess() {
        ASTNode$State state = this.state();
        boolean isTypeAccess_value = this.isTypeAccess_compute();
        return isTypeAccess_value;
    }

    private boolean isTypeAccess_compute() {
        return true;
    }

    @Override
    public NameType predNameType() {
        ASTNode$State state = this.state();
        NameType predNameType_value = this.predNameType_compute();
        return predNameType_value;
    }

    private NameType predNameType_compute() {
        return NameType.PACKAGE_OR_TYPE_NAME;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.decl();
    }

    @Override
    public boolean staticContextQualifier() {
        ASTNode$State state = this.state();
        boolean staticContextQualifier_value = this.staticContextQualifier_compute();
        return staticContextQualifier_value;
    }

    private boolean staticContextQualifier_compute() {
        return true;
    }

    @Override
    public boolean usesTypeVariable() {
        ASTNode$State state = this.state();
        boolean usesTypeVariable_value = this.usesTypeVariable_compute();
        return usesTypeVariable_value;
    }

    private boolean usesTypeVariable_compute() {
        return this.decl().usesTypeVariable() || super.usesTypeVariable();
    }

    public Literal getFieldValue(Variable v) {
        ASTNode$State state = this.state();
        Literal getFieldValue_Variable_value = this.getFieldValue_compute(v);
        return getFieldValue_Variable_value;
    }

    private Literal getFieldValue_compute(Variable v) {
        String fName = v.name();
        String targetTypeName = String.valueOf(this.packageName()) + "." + this.name();
        try {
            Class<?> targetClass = Util.getClassForType(targetTypeName);
            Field statField = this.hasField(targetClass, fName);
            statField.setAccessible(true);
            Object val = statField.get(null);
            Literal retLiteral = Literal.buildLiteral(val);
            if (retLiteral instanceof ObjectLiteral) {
                TypeDecl td = Util.lookupType(val.getClass());
                if (td == null) {
                    td = v.type();
                }
                ((ObjectLiteral)retLiteral).setTypeDecl(td);
                ((ObjectLiteral)retLiteral).setVariable(v);
            }
            return retLiteral;
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Invocation problem", e);
        }
        return null;
    }

    @Override
    public Literal invoke(Environment env, MethodAccess ma, List<Expr> actualParams) {
        ASTNode$State state = this.state();
        Literal invoke_jpe_Environment_MethodAccess_List_Expr__value = this.invoke_compute(env, ma, actualParams);
        return invoke_jpe_Environment_MethodAccess_List_Expr__value;
    }

    private Literal invoke_compute(Environment env, MethodAccess ma, List<Expr> actualParams) {
        String targetTypeName = String.valueOf(this.packageName()) + "." + this.name();
        try {
            Class<?>[] parameterTypes = Util.getParameterTypes(ma.decl());
            Object[] parameters = Util.getParameters(actualParams);
            Class<?> targetClass = Util.getClassForType(targetTypeName);
            Method m = targetClass.getMethod(ma.name(), parameterTypes);
            Object val = m.invoke(null, parameters);
            return ObjectLiteral.makeObjectLiteral(val, ma);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Invocation problem", e);
        }
        return null;
    }

    @Override
    public Expr pe(Environment env) {
        ASTNode$State state = this.state();
        Expr pe_jpe_Environment_value = this.pe_compute(env);
        return pe_jpe_Environment_value;
    }

    private Expr pe_compute(Environment env) {
        TypeAccess newTA = this.fullCopy();
        newTA.setID(this.name());
        newTA.setPackage(this.decl().packageName());
        return newTA;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

