/*
 * Decompiled with CFR 0.152.
 */
package AST;

import AST.ASTNode;
import AST.ASTNode$State;
import AST.Block;
import AST.BooleanLiteral;
import AST.BranchTargetStmt;
import AST.BreakStmt;
import AST.CodeGeneration;
import AST.ContinueStmt;
import AST.EmptyStmt;
import AST.Expr;
import AST.List;
import AST.MethodAccess;
import AST.Stmt;
import AST.TypeDecl;
import AST.Variable;
import java.util.HashMap;
import java.util.Map;
import jpe.Environment;
import jpe.JPE;

public class WhileStmt
extends BranchTargetStmt
implements Cloneable {
    protected Map targetOf_ContinueStmt_values;
    protected Map targetOf_BreakStmt_values;
    protected Map isDUbeforeCondition_Variable_values;
    protected boolean cond_label_computed = false;
    protected int cond_label_value;
    protected boolean end_label_computed = false;
    protected int end_label_value;
    protected boolean stmt_label_computed = false;
    protected int stmt_label_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.targetOf_ContinueStmt_values = null;
        this.targetOf_BreakStmt_values = null;
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
        this.isDUbeforeCondition_Variable_values = null;
        this.canCompleteNormally_computed = false;
        this.cond_label_computed = false;
        this.end_label_computed = false;
        this.stmt_label_computed = false;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public WhileStmt clone() throws CloneNotSupportedException {
        WhileStmt node = (WhileStmt)super.clone();
        node.targetOf_ContinueStmt_values = null;
        node.targetOf_BreakStmt_values = null;
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.isDUbeforeCondition_Variable_values = null;
        node.canCompleteNormally_computed = false;
        node.cond_label_computed = false;
        node.end_label_computed = false;
        node.stmt_label_computed = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public WhileStmt copy() {
        try {
            WhileStmt node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public WhileStmt fullCopy() {
        WhileStmt res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.indent());
        s.append("while(");
        this.getCondition().toString(s);
        s.append(")");
        this.getStmt().toString(s);
    }

    @Override
    public void typeCheck() {
        TypeDecl cond = this.getCondition().type();
        if (!cond.isBoolean()) {
            this.error("the type of \"" + this.getCondition() + "\" is " + cond.name() + " which is not boolean");
        }
    }

    @Override
    public void createBCode(CodeGeneration gen) {
        super.createBCode(gen);
        gen.addLabel(this.cond_label());
        this.getCondition().emitEvalBranch(gen);
        gen.addLabel(this.stmt_label());
        if (this.getCondition().canBeTrue()) {
            this.getStmt().createBCode(gen);
            if (this.getStmt().canCompleteNormally()) {
                gen.emitGoto(this.cond_label());
            }
        }
        gen.addLabel(this.end_label());
    }

    @Override
    public Stmt pe(Environment env) {
        List<Stmt> unfolding = this.unfold(new List<Stmt>(), env, 1);
        int children = unfolding.getNumChild();
        if (children == 0) {
            return new EmptyStmt();
        }
        if (children == 1) {
            return (Stmt)unfolding.getChild(0);
        }
        return new Block(unfolding);
    }

    private List<Stmt> unfold(List<Stmt> unfoldedStmts, Environment env, int unfoldIdx) {
        Expr cond;
        if (JPE.verbose()) {
            System.out.println("While loop " + unfoldIdx + "th unfolding.");
        }
        if (!((cond = this.getCondition().peCatch(env)) instanceof BooleanLiteral)) {
            if (unfoldIdx > 1) {
                throw new Error("While loop condition " + cond + " has to be static");
            }
            return unfoldedStmts.add(new WhileStmt(cond, this.getStmt().peCatch(env)));
        }
        if (!cond.constant().booleanValue()) {
            return unfoldedStmts;
        }
        unfoldedStmts.add(this.getStmt().peCatch(env));
        return this.unfold(unfoldedStmts, env, ++unfoldIdx);
    }

    @Override
    public boolean canRemove(Map<String, Boolean> usedVars) {
        this.addUsedVars(usedVars);
        this.getStmt().canRemove(usedVars);
        return false;
    }

    @Override
    public void addUsedVars(Map<String, Boolean> usedVars) {
        this.getStmt().addUsedVars(usedVars);
        this.getCondition().addUsedVars(usedVars);
    }

    public WhileStmt() {
    }

    public WhileStmt(Expr p0, Stmt p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setCondition(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getCondition() {
        return (Expr)this.getChild(0);
    }

    public Expr getConditionNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setStmt(Stmt node) {
        this.setChild(node, 1);
    }

    public Stmt getStmt() {
        return (Stmt)this.getChild(1);
    }

    public Stmt getStmtNoTransform() {
        return (Stmt)this.getChildNoTransform(1);
    }

    @Override
    public boolean targetOf(ContinueStmt stmt) {
        ContinueStmt _parameters = stmt;
        if (this.targetOf_ContinueStmt_values == null) {
            this.targetOf_ContinueStmt_values = new HashMap(4);
        }
        if (this.targetOf_ContinueStmt_values.containsKey(_parameters)) {
            return (Boolean)this.targetOf_ContinueStmt_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean targetOf_ContinueStmt_value = this.targetOf_compute(stmt);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.targetOf_ContinueStmt_values.put(_parameters, targetOf_ContinueStmt_value);
        }
        return targetOf_ContinueStmt_value;
    }

    private boolean targetOf_compute(ContinueStmt stmt) {
        return !stmt.hasLabel();
    }

    @Override
    public boolean targetOf(BreakStmt stmt) {
        BreakStmt _parameters = stmt;
        if (this.targetOf_BreakStmt_values == null) {
            this.targetOf_BreakStmt_values = new HashMap(4);
        }
        if (this.targetOf_BreakStmt_values.containsKey(_parameters)) {
            return (Boolean)this.targetOf_BreakStmt_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean targetOf_BreakStmt_value = this.targetOf_compute(stmt);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.targetOf_BreakStmt_values.put(_parameters, targetOf_BreakStmt_value);
        }
        return targetOf_BreakStmt_value;
    }

    private boolean targetOf_compute(BreakStmt stmt) {
        return !stmt.hasLabel();
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        if (!this.getCondition().isDAafterFalse(v)) {
            return false;
        }
        for (BreakStmt stmt : this.targetBreaks()) {
            if (stmt.isDAafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        if (!this.isDUbeforeCondition(v)) {
            return false;
        }
        if (!this.getCondition().isDUafterFalse(v)) {
            return false;
        }
        for (BreakStmt stmt : this.targetBreaks()) {
            if (stmt.isDUafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    public boolean isDUbeforeCondition(Variable v) {
        ASTNode$State.CircularValue _value;
        Variable _parameters = v;
        if (this.isDUbeforeCondition_Variable_values == null) {
            this.isDUbeforeCondition_Variable_values = new HashMap(4);
        }
        if (this.isDUbeforeCondition_Variable_values.containsKey(_parameters)) {
            Object _o = this.isDUbeforeCondition_Variable_values.get(_parameters);
            if (!(_o instanceof ASTNode$State.CircularValue)) {
                return (Boolean)_o;
            }
            _value = (ASTNode$State.CircularValue)_o;
        } else {
            _value = new ASTNode$State.CircularValue();
            this.isDUbeforeCondition_Variable_values.put(_parameters, _value);
            _value.value = true;
        }
        ASTNode$State state = this.state();
        if (!state.IN_CIRCLE) {
            boolean new_isDUbeforeCondition_Variable_value;
            state.IN_CIRCLE = true;
            int num = state.boundariesCrossed;
            boolean isFinal = this.is$Final();
            do {
                _value.visited = new Integer(state.CIRCLE_INDEX);
                state.CHANGE = false;
                new_isDUbeforeCondition_Variable_value = this.isDUbeforeCondition_compute(v);
                if (new_isDUbeforeCondition_Variable_value != (Boolean)_value.value) {
                    state.CHANGE = true;
                    _value.value = new_isDUbeforeCondition_Variable_value;
                }
                ++state.CIRCLE_INDEX;
            } while (state.CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.isDUbeforeCondition_Variable_values.put(_parameters, new_isDUbeforeCondition_Variable_value);
            } else {
                this.isDUbeforeCondition_Variable_values.remove(_parameters);
                state.RESET_CYCLE = true;
                this.isDUbeforeCondition_compute(v);
                state.RESET_CYCLE = false;
            }
            state.IN_CIRCLE = false;
            return new_isDUbeforeCondition_Variable_value;
        }
        if (!new Integer(state.CIRCLE_INDEX).equals(_value.visited)) {
            _value.visited = new Integer(state.CIRCLE_INDEX);
            boolean new_isDUbeforeCondition_Variable_value = this.isDUbeforeCondition_compute(v);
            if (state.RESET_CYCLE) {
                this.isDUbeforeCondition_Variable_values.remove(_parameters);
            } else if (new_isDUbeforeCondition_Variable_value != (Boolean)_value.value) {
                state.CHANGE = true;
                _value.value = new_isDUbeforeCondition_Variable_value;
            }
            return new_isDUbeforeCondition_Variable_value;
        }
        return (Boolean)_value.value;
    }

    private boolean isDUbeforeCondition_compute(Variable v) {
        if (!this.isDUbefore(v)) {
            return false;
        }
        if (!this.getStmt().isDUafter(v)) {
            return false;
        }
        for (ContinueStmt stmt : this.targetContinues()) {
            if (stmt.isDUafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean continueLabel() {
        ASTNode$State state = this.state();
        boolean continueLabel_value = this.continueLabel_compute();
        return continueLabel_value;
    }

    private boolean continueLabel_compute() {
        return true;
    }

    @Override
    public boolean canCompleteNormally() {
        if (this.canCompleteNormally_computed) {
            return this.canCompleteNormally_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.canCompleteNormally_value = this.canCompleteNormally_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.canCompleteNormally_computed = true;
        }
        return this.canCompleteNormally_value;
    }

    private boolean canCompleteNormally_compute() {
        return this.reachable() && (!this.getCondition().isConstant() || !this.getCondition().isTrue()) || this.reachableBreak();
    }

    @Override
    public boolean definesLabel() {
        ASTNode$State state = this.state();
        boolean definesLabel_value = this.definesLabel_compute();
        return definesLabel_value;
    }

    private boolean definesLabel_compute() {
        return true;
    }

    public int cond_label() {
        if (this.cond_label_computed) {
            return this.cond_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.cond_label_value = this.cond_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.cond_label_computed = true;
        }
        return this.cond_label_value;
    }

    private int cond_label_compute() {
        return this.hostType().constantPool().newLabel();
    }

    public int end_label() {
        if (this.end_label_computed) {
            return this.end_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.end_label_value = this.end_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.end_label_computed = true;
        }
        return this.end_label_value;
    }

    private int end_label_compute() {
        return this.hostType().constantPool().newLabel();
    }

    public int stmt_label() {
        if (this.stmt_label_computed) {
            return this.stmt_label_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.stmt_label_value = this.stmt_label_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.stmt_label_computed = true;
        }
        return this.stmt_label_value;
    }

    private int stmt_label_compute() {
        return this.hostType().constantPool().newLabel();
    }

    @Override
    public int break_label() {
        ASTNode$State state = this.state();
        int break_label_value = this.break_label_compute();
        return break_label_value;
    }

    private int break_label_compute() {
        return this.end_label();
    }

    @Override
    public int continue_label() {
        ASTNode$State state = this.state();
        int continue_label_value = this.continue_label_compute();
        return continue_label_value;
    }

    private int continue_label_compute() {
        return this.cond_label();
    }

    @Override
    public Stmt rewriteReturns(MethodAccess m) {
        ASTNode$State state = this.state();
        Stmt rewriteReturns_MethodAccess_value = this.rewriteReturns_compute(m);
        return rewriteReturns_MethodAccess_value;
    }

    private Stmt rewriteReturns_compute(MethodAccess m) {
        this.setStmt(this.getStmt().rewriteReturns(m));
        return this;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getStmtNoTransform()) {
            return this.getCondition().isDAafterTrue(v);
        }
        if (caller == this.getConditionNoTransform()) {
            return this.isDAbefore(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getStmtNoTransform()) {
            return this.getCondition().isDUafterTrue(v);
        }
        if (caller == this.getConditionNoTransform()) {
            return this.isDUbeforeCondition(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_insideLoop(ASTNode caller, ASTNode child) {
        if (caller == this.getStmtNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_insideLoop(this, caller);
    }

    @Override
    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        if (caller == this.getStmtNoTransform()) {
            return this.reachable() && !this.getCondition().isFalse();
        }
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    @Override
    public boolean Define_boolean_reportUnreachable(ASTNode caller, ASTNode child) {
        if (caller == this.getStmtNoTransform()) {
            return this.reachable();
        }
        return this.getParent().Define_boolean_reportUnreachable(this, caller);
    }

    @Override
    public int Define_int_condition_false_label(ASTNode caller, ASTNode child) {
        if (caller == this.getConditionNoTransform()) {
            return this.end_label();
        }
        return this.getParent().Define_int_condition_false_label(this, caller);
    }

    @Override
    public int Define_int_condition_true_label(ASTNode caller, ASTNode child) {
        if (caller == this.getConditionNoTransform()) {
            return this.stmt_label();
        }
        return this.getParent().Define_int_condition_true_label(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

