/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp;

import beaver.comp.Action;
import beaver.comp.State;
import beaver.spec.Grammar;
import beaver.spec.Terminal;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

class ParsingTables {
    public final State first_state;
    final int n_term;
    short[] actions;
    int last_action_index;
    short[] lookaheads;
    short[] terminal_offsets;
    short[] nonterminal_offsets;
    short[] default_actions;

    static int countStates(State state) {
        while (state.next != null) {
            state = state.next;
        }
        return state.id;
    }

    ParsingTables(Grammar grammar, State listArray) {
        int n = ParsingTables.countStates((State)listArray);
        this.first_state = listArray;
        this.n_term = grammar.terminals.length;
        this.default_actions = new short[n + 1];
        this.terminal_offsets = new short[n + 1];
        this.nonterminal_offsets = new short[n + 1];
        this.actions = new short[65534];
        this.lookaheads = new short[this.actions.length];
        for (int i = 0; i <= n; ++i) {
            this.nonterminal_offsets[i] = Short.MAX_VALUE;
            this.terminal_offsets[i] = Short.MAX_VALUE;
        }
        Action.List[] listArray2 = new Action.List[n * 2];
        int n2 = 0;
        Object object = listArray;
        while (object != null) {
            if (object.default_action != null) {
                this.default_actions[object.id] = object.default_action.getId();
            }
            if (object.terminal_lookahead_actions.num_actions > 0) {
                listArray2[n2++] = object.terminal_lookahead_actions;
            }
            if (object.nonterminal_lookahead_actions.num_actions > 0) {
                listArray2[n2++] = object.nonterminal_lookahead_actions;
            }
            object = object.next;
        }
        object = new Action.List[n2];
        System.arraycopy(listArray2, 0, object, 0, n2);
        listArray2 = object;
        Arrays.sort(listArray2, Action.List.NUM_ACTIONS_CMP);
        this.resetLookaheads(0);
        int n3 = 0;
        for (int i = 0; i < listArray2.length; ++i) {
            Action.List list = listArray2[i];
            int n4 = this.findOffset(list, n3);
            if (list.first.lookahead instanceof Terminal) {
                if (this.terminal_offsets[list.state.id] != Short.MAX_VALUE) {
                    throw new IllegalStateException("terminal offset " + list.state.id + " is used");
                }
                this.terminal_offsets[list.state.id] = (short)n4;
            } else {
                if (this.nonterminal_offsets[list.state.id] != Short.MAX_VALUE) {
                    throw new IllegalStateException("nonterminal offset " + list.state.id + " is used");
                }
                this.nonterminal_offsets[list.state.id] = (short)n4;
            }
            this.last_action_index = Math.max(this.last_action_index, n4 + list.last.lookahead.id);
            n3 = this.advanceStartIndex(n3);
        }
    }

    private void resetLookaheads(int n) {
        while (n < this.lookaheads.length) {
            this.lookaheads[n++] = -1;
        }
    }

    private int advanceStartIndex(int n) {
        int n2 = this.actions.length;
        while (n < n2 && this.actions[n] != 0) {
            ++n;
        }
        return n;
    }

    private int findOffset(Action.List list, int n) {
        short s = list.first.lookahead.id;
        short s2 = list.last.lookahead.id;
        int n2 = s2 - s + 1;
        int n3 = this.actions.length - n2;
        for (int i = n; i <= n3; ++i) {
            int n4;
            if (this.actions[i] != 0 || !this.tryInsertActions(list, n4 = i - s)) continue;
            this.insertActions(list, n4);
            return n4;
        }
        throw new IllegalStateException("cannot find place for some actions in parsing tables");
    }

    private void insertActions(Action.List list, int n) {
        Action action = list.first;
        while (action != null) {
            int n2 = n + action.lookahead.id;
            if (this.actions[n2] != 0) {
                throw new IllegalStateException("inserting action in occupied slot");
            }
            this.actions[n2] = action.getId();
            action = action.next;
        }
    }

    private boolean tryInsertActions(Action.List list, int n) {
        if (this.canInsertActions(list, n)) {
            this.insertLookaheads(list, n);
            if (list.first.lookahead.id >= this.n_term || !this.hasCollisions()) {
                return true;
            }
            this.removeLookaheads(list, n);
        }
        return false;
    }

    private boolean canInsertActions(Action.List list, int n) {
        Action action = list.first;
        while (action != null) {
            if (this.actions[n + action.lookahead.id] != 0) {
                return false;
            }
            action = action.next;
        }
        return true;
    }

    private void insertLookaheads(Action.List list, int n) {
        Action action = list.first;
        while (action != null) {
            int n2 = n + action.lookahead.id;
            if (this.lookaheads[n2] >= 0) {
                throw new IllegalStateException("lookahead collision during initial insert");
            }
            this.lookaheads[n2] = action.lookahead.id;
            action = action.next;
        }
    }

    private void removeLookaheads(Action.List list, int n) {
        Action action = list.first;
        while (action != null) {
            this.lookaheads[n + action.lookahead.id] = -1;
            action = action.next;
        }
    }

    private boolean hasCollisions() {
        State state = this.first_state;
        while (state != null) {
            short s = this.terminal_offsets[state.id];
            if (s != Short.MAX_VALUE) {
                Action action = state.terminal_lookahead_actions.first;
                for (int i = 0; i < this.n_term; ++i) {
                    if (action != null && action.lookahead.id == i) {
                        action = action.next;
                        continue;
                    }
                    int n = s + i;
                    if (0 > n || n >= this.lookaheads.length || this.lookaheads[n] != i) continue;
                    return true;
                }
            }
            state = state.next;
        }
        return false;
    }

    int getSize() {
        return (this.last_action_index + 1) * 2 * 2 + this.terminal_offsets.length * 2 * 3;
    }

    void writeTo(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2 = this.last_action_index + 1;
        dataOutputStream.writeShort(n2);
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeShort(this.actions[n]);
        }
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeShort(this.lookaheads[n]);
        }
        n2 = this.terminal_offsets.length;
        dataOutputStream.writeShort(n2);
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeShort(this.terminal_offsets[n]);
        }
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeShort(this.nonterminal_offsets[n]);
        }
        for (n = 0; n < n2; ++n) {
            dataOutputStream.writeShort(this.default_actions[n]);
        }
    }
}

