/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp.run;

import beaver.Parser;
import beaver.comp.ParserGenerator;
import beaver.comp.io.SrcReader;
import beaver.comp.run.Options;
import beaver.comp.util.Log;
import beaver.spec.Grammar;
import java.io.File;
import java.io.IOException;

public class Make {
    static void printVersion() {
        System.err.print("Beaver parser generator v");
        System.err.println("0.9.4");
        System.err.println("Copyright (C) 2003,2004 Alexander Demenchuk <alder@softanvil.com>.");
        System.err.println("All rights reserved.");
    }

    static void printUsage() {
        System.err.println("Usage: java -jar beaver.jar [options] filename");
        System.err.println(" where options are:");
        System.err.println("\t-a generate parsing states report (.stat)");
        System.err.println("\t-c do not compress parsing tables");
        System.err.println("\t-d dry-run - do not generate anything");
        System.err.println("\t-e export parsing tables into a file (.spec)");
        System.err.println("\t-n generate non-anonymous delegates for action routines");
        System.err.println("\t-s sort terminals (by name)");
        System.err.println("\t-t generate terminal names");
        System.err.println("\t-T export Terminals \"enum\" class into a file");
        System.err.println("\t-s sort terminals (by name)");
        System.err.println("\t-w use \"switch\" to invoke action routines");
        System.err.println("\t-v print version information and exit");
        System.err.println("\t-h print this help text and exit");
    }

    static Options parseOptions(String[] stringArray) {
        Options options = new Options();
        int n = stringArray.length - 1;
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].length();
            if (n2 < 2 || stringArray[i].charAt(0) != '-') {
                throw new IllegalArgumentException("Error: \"" + stringArray[i] + "\" is an invalid option.");
            }
            block14: for (int j = 1; j < n2; ++j) {
                switch (stringArray[i].charAt(j)) {
                    case 'a': {
                        options.report_actions = true;
                        continue block14;
                    }
                    case 'c': {
                        options.no_compression = true;
                        continue block14;
                    }
                    case 'd': {
                        options.no_output = true;
                        continue block14;
                    }
                    case 'e': {
                        options.exp_parsing_tables = true;
                        continue block14;
                    }
                    case 'n': {
                        options.name_action_classes = true;
                        continue block14;
                    }
                    case 's': {
                        options.sort_terminals = true;
                        continue block14;
                    }
                    case 't': {
                        options.terminal_names = true;
                        continue block14;
                    }
                    case 'T': {
                        options.export_terminals = true;
                        continue block14;
                    }
                    case 'w': {
                        options.use_switch = true;
                        continue block14;
                    }
                    case 'v': {
                        Make.printVersion();
                        System.exit(0);
                        continue block14;
                    }
                    case 'h': {
                        Make.printUsage();
                        System.exit(0);
                        continue block14;
                    }
                    default: {
                        throw new IllegalArgumentException("Error: \"-" + stringArray[i].charAt(j) + "\" is an invalid option.");
                    }
                }
            }
        }
        return options;
    }

    static File getSrcFile(String string) {
        File file = new File(string);
        if (!file.canRead()) {
            throw new IllegalArgumentException("Error: cannot read \"" + string + "\"");
        }
        return file;
    }

    static void compile(SrcReader srcReader, Options options, Log log) {
        try {
            ParserGenerator.compile(srcReader, options, log);
        }
        catch (Parser.Exception exception) {
            System.err.print("Error: ");
            System.err.println(exception.getMessage());
        }
        catch (Grammar.Exception exception) {
            System.err.print("Error: ");
            System.err.println(exception.getMessage());
        }
        catch (IOException iOException) {
            System.err.print("System Error: ");
            System.err.println(iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            Make.printUsage();
        } else {
            try {
                Log log = new Log();
                Options options = Make.parseOptions(stringArray);
                File file = Make.getSrcFile(stringArray[stringArray.length - 1]);
                SrcReader srcReader = new SrcReader(file);
                Make.compile(srcReader, options, log);
                log.report(file.getName(), srcReader);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(illegalArgumentException.getMessage());
                Make.printUsage();
            }
        }
    }
}

