/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp.util;

import beaver.Scanner;
import beaver.Symbol;
import beaver.comp.io.SrcReader;
import java.io.PrintStream;

public class Log {
    private Record.List errors = new Record.List();
    private Record.List warnings = new Record.List();
    private Record.List messages = new Record.List();

    public void error(Symbol symbol, String string) {
        this.error(symbol.getStart(), symbol.getEnd(), string);
    }

    public void error(Scanner.Exception exception) {
        int n = Symbol.makePosition(exception.line, exception.column);
        this.error(n, n, exception.getMessage());
    }

    public void error(int n, int n2, String string) {
        this.errors.add(new Record(n, n2, string));
    }

    public void error(String string) {
        this.error(0, 0, string);
    }

    public void warning(Symbol symbol, String string) {
        this.warning(symbol.getStart(), symbol.getEnd(), string);
    }

    public void warning(int n, int n2, String string) {
        this.warnings.add(new Record(n, n2, string));
    }

    public void warning(String string) {
        this.warning(0, 0, string);
    }

    public void message(String string) {
        this.messages.add(new Record(0, 0, string));
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public void report(String string, SrcReader srcReader) {
        Object object;
        int n = this.errors.size();
        int n2 = this.warnings.size();
        if (n > 0 || n2 > 0) {
            object = System.err;
            Record record = this.errors.start();
            while (record != null) {
                record.report("Error", (PrintStream)object, srcReader);
                record = record.next;
            }
            this.errors.reset();
            record = this.warnings.start();
            while (record != null) {
                record.report("Warning", (PrintStream)object, srcReader);
                record = record.next;
            }
            this.warnings.reset();
            if (n > 0 || n2 > 0) {
                ((PrintStream)object).print(string);
                ((PrintStream)object).print(": ");
                ((PrintStream)object).print(n);
                ((PrintStream)object).print(" error");
                if (n != 1) {
                    ((PrintStream)object).print('s');
                }
                ((PrintStream)object).print(", ");
                ((PrintStream)object).print(n2);
                ((PrintStream)object).print(" warning");
                if (n2 != 1) {
                    ((PrintStream)object).print('s');
                }
                ((PrintStream)object).println('.');
            }
        }
        object = this.messages.start();
        while (object != null) {
            ((Record)object).report(null, System.out, srcReader);
            object = ((Record)object).next;
        }
        this.messages.reset();
    }

    public static class Record {
        Record next;
        private final int start_pos;
        private final int end_pos;
        private final String message;

        Record(int n, int n2, String string) {
            this.start_pos = n;
            this.end_pos = n2;
            this.message = string;
        }

        public void report(String string, PrintStream printStream, SrcReader srcReader) {
            int n;
            int n2;
            printStream.print(srcReader.file.getName());
            printStream.print(':');
            if (this.start_pos > 0) {
                printStream.print(Symbol.getLine(this.start_pos));
                printStream.print(',');
                printStream.print(Symbol.getColumn(this.start_pos));
                printStream.print('-');
                printStream.print(Symbol.getLine(this.end_pos));
                printStream.print(',');
                printStream.print(Symbol.getColumn(this.end_pos));
                printStream.print(':');
            }
            if (string != null) {
                printStream.print(' ');
                printStream.print(string);
                printStream.print(':');
            }
            printStream.print(' ');
            printStream.println(this.message);
            if (this.start_pos > 0 && (n2 = Symbol.getLine(this.start_pos)) == (n = Symbol.getLine(this.end_pos))) {
                int n3;
                String string2 = srcReader.getLine(n2).replace('\t', ' ');
                printStream.print(string2);
                int n4 = Symbol.getColumn(this.start_pos);
                for (n3 = n4 - 1; n3 > 0; --n3) {
                    printStream.print(' ');
                }
                printStream.print('^');
                for (n3 = Symbol.getColumn(this.end_pos) - n4 - 1; n3 > 0; --n3) {
                    printStream.print('-');
                }
                if (n3 == 0) {
                    printStream.print('^');
                }
                printStream.println();
            }
        }

        public static class List {
            private Record first;
            private Record last;
            private int size;

            public void add(Record record) {
                if (this.last == null) {
                    this.first = this.last = record;
                } else {
                    this.last = this.last.next = record;
                }
                ++this.size;
            }

            public Record start() {
                return this.first;
            }

            public int size() {
                return this.size;
            }

            public void reset() {
                this.last = null;
                this.first = null;
                this.size = 0;
            }
        }
    }
}

