/*
 * Decompiled with CFR 0.152.
 */
package jpe;

import AST.Variable;
import java.util.ArrayList;
import java.util.List;
import jpe.Environment;

public class CompileTimeInfo {
    private List<String> dependencies = new ArrayList<String>();
    private boolean staticStage = false;
    private Variable variable;

    public CompileTimeInfo(Variable variable) {
        this.variable = variable;
    }

    public void addDependency(String v) {
        this.dependencies.add(v);
        this.staticStage = false;
    }

    public boolean isCompileTime() {
        return this.staticStage;
    }

    public void setCompileTime(boolean staticStage) {
        this.staticStage = staticStage;
    }

    public boolean canBeStaticInEnv(Environment env) {
        if (this.dependencies.size() == 0) {
            return this.staticStage;
        }
        for (String v : this.dependencies) {
            if (env.lookupVarByName(v) != null) continue;
            return false;
        }
        return true;
    }
}

