/*
 * Decompiled with CFR 0.152.
 */
package jpe;

import AST.AbstractObject;
import AST.Expr;
import AST.Variable;
import java.util.Iterator;
import java.util.Stack;
import jpe.PEStack;

public class Environment {
    private Stack<PEStack> stack = new Stack();
    private boolean executeFlag = false;

    public Expr getCurrentThis() {
        return (Expr)((Object)this.getCurrentStack().thisObject);
    }

    public boolean isExecuteFlagOn() {
        return this.executeFlag;
    }

    public void setExecuteFlag() {
        this.executeFlag = true;
    }

    public void unsetExecuteFlag() {
        this.executeFlag = false;
    }

    public Environment() {
    }

    public Environment(PEStack peStack) {
        this.stack.push(peStack);
    }

    public void inStack(AbstractObject thiz) {
        this.stack.push(new PEStack(thiz));
    }

    public Environment cloneCurrentStackEnv() {
        return new Environment(this.stack.peek().clone());
    }

    public void outStack() {
        this.stack.pop();
    }

    public void inFrame() {
        this.getCurrentStack().inFrame();
    }

    public void outFrame() {
        this.getCurrentStack().outFrame();
    }

    public PEStack getCurrentStack() {
        return this.stack.peek();
    }

    public Expr lookup(Variable n) {
        Expr e = this.stack.peek().lookup(n);
        return e;
    }

    public boolean contains(Variable n) {
        return this.stack.peek().contains(n);
    }

    public void add(Variable n, Expr v) {
        this.stack.peek().add(n, v);
    }

    public void remove(Variable n) {
        throw new Error("should not be in remove");
    }

    public Expr lookupVarByName(String s) {
        return this.stack.peek().lookupVarByName(s);
    }

    public String toString() {
        Iterator i = this.stack.iterator();
        StringBuffer s = new StringBuffer("(\n");
        while (i.hasNext()) {
            s.append(i.next() + ",\n");
        }
        s.append(")");
        return s.toString();
    }

    public void removeAltered(Environment env) {
        throw new Error("should not be in removeAltered");
    }
}

