/*
 * Decompiled with CFR 0.152.
 */
package jpe;

import AST.Expr;
import AST.Variable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Frame
implements Iterable<Map.Entry<Variable, Expr>> {
    private Frame parentFrame = null;
    private Map<Variable, Expr> map = new HashMap<Variable, Expr>();

    public Frame getParentFrame() {
        return this.parentFrame;
    }

    public Frame() {
    }

    public Frame(Frame parentFrame, Map<Variable, Expr> map) {
        this.parentFrame = parentFrame;
        this.map = map;
    }

    public Frame(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public Expr lookup(Variable n) {
        Expr e = this.map.get(n);
        if (e == null && this.parentFrame != null) {
            return this.parentFrame.lookup(n);
        }
        return e;
    }

    public boolean contains(Variable n) {
        boolean b = this.map.containsKey(n);
        if (!b && this.parentFrame != null) {
            return this.parentFrame.contains(n);
        }
        return b;
    }

    public Frame findOwnerFrame(Variable n) {
        if (this.map.containsKey(n)) {
            return this;
        }
        if (this.parentFrame != null) {
            return this.parentFrame.findOwnerFrame(n);
        }
        return null;
    }

    public void add(Variable n, Expr v) {
        Frame f = this.findOwnerFrame(n);
        if (f == null) {
            this.map.put(n, v);
        } else {
            f.addToMap(n, v);
        }
    }

    private void addToMap(Variable n, Expr v) {
        this.map.put(n, v);
    }

    public void remove(Variable n) {
        throw new Error("should not be in remove");
    }

    public Frame clone() {
        HashMap<Variable, Expr> mapClone = new HashMap<Variable, Expr>();
        Set<Map.Entry<Variable, Expr>> es = this.map.entrySet();
        for (Map.Entry<Variable, Expr> n : es) {
            mapClone.put(n.getKey(), n.getValue());
        }
        Frame parentFrameClone = null;
        if (this.parentFrame != null) {
            parentFrameClone = this.parentFrame.clone();
        }
        return new Frame(parentFrameClone, mapClone);
    }

    @Override
    public Iterator<Map.Entry<Variable, Expr>> iterator() {
        return new FrameIterator();
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer("{");
        for (Map.Entry<Variable, Expr> entry : this.map.entrySet()) {
            Variable v = entry.getKey();
            strBuffer.append(String.valueOf(v.name()) + "=" + entry.getValue() + ",");
        }
        if (this.parentFrame != null) {
            strBuffer.append(this.parentFrame.toString());
        }
        strBuffer.append("}");
        return strBuffer.toString();
    }

    public Expr lookupVarByName(String s) {
        for (Variable v : this.map.keySet()) {
            if (!v.name().equals(s)) continue;
            return this.map.get(v);
        }
        if (this.parentFrame != null) {
            return this.parentFrame.lookupVarByName(s);
        }
        return null;
    }

    public class FrameIterator
    implements Iterator<Map.Entry<Variable, Expr>> {
        private Iterator<Map.Entry<Variable, Expr>> currentFrameIterator = null;
        private Iterator<Map.Entry<Variable, Expr>> parentFrameIterator = null;
        private Map.Entry<Variable, Expr> lastItem;

        public FrameIterator() {
            this.currentFrameIterator = Frame.this.map.entrySet().iterator();
            if (Frame.this.parentFrame != null) {
                this.parentFrameIterator = Frame.this.parentFrame.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentFrameIterator != null && this.currentFrameIterator.hasNext() || this.parentFrameIterator != null && this.parentFrameIterator.hasNext();
        }

        @Override
        public Map.Entry<Variable, Expr> next() {
            this.lastItem = this.currentFrameIterator.hasNext() ? this.currentFrameIterator.next() : this.parentFrameIterator.next();
            return this.lastItem;
        }

        @Override
        public void remove() {
            if (this.lastItem != null) {
                Frame.this.remove(this.lastItem.getKey());
            }
        }
    }
}

