/*
 * Decompiled with CFR 0.152.
 */
package jpe;

import AST.Options;
import java.io.File;
import java.util.ArrayList;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import jpe.JavaChecker;

public class JPE {
    protected static boolean verbose;
    public static File tempClassDir;
    public static Options options;

    static {
        tempClassDir = new File("/tmp/jpe" + System.currentTimeMillis());
        tempClassDir.mkdirs();
        options = new Options();
    }

    public static void main(String[] args) {
        verbose = false;
        JPE.runTest(args);
    }

    protected static void runTest(String[] args) {
        options.initOptions();
        options.addKeyOption("-version");
        options.addKeyOption("-print");
        options.addKeyOption("-g");
        options.addKeyOption("-g:none");
        options.addKeyOption("-g:lines,vars,source");
        options.addKeyOption("-nowarn");
        options.addKeyOption("-verbose");
        options.addKeyOption("-deprecation");
        options.addKeyValueOption("-classpath");
        options.addKeyValueOption("-sourcepath");
        options.addKeyValueOption("-bootclasspath");
        options.addKeyValueOption("-extdirs");
        options.addKeyValueOption("-d");
        options.addKeyValueOption("-encoding");
        options.addKeyValueOption("-source");
        options.addKeyValueOption("-target");
        options.addKeyOption("-help");
        options.addKeyOption("-O");
        options.addKeyOption("-J-Xmx128M");
        options.addKeyOption("-recover");
        options.addOptions(args);
        if (!options.hasValueForOption("-d")) {
            options.setValueForOption(tempClassDir.getAbsolutePath(), "-d");
        } else {
            tempClassDir = new File(options.getValueForOption("-d"));
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler.run(null, null, null, JPE.optionsToString(options)) != 0) {
            System.err.println("There are errors in the source provided.");
        }
        JavaChecker javaChecker = new JavaChecker();
        javaChecker.compile(args);
        javaChecker.pe();
    }

    public static boolean verbose() {
        return verbose;
    }

    public static String[] optionsToString(Options ops) {
        ArrayList<String> opList = new ArrayList<String>();
        String[] sops = new String[]{"-g", "-g:none", "-g:lines,vars,source", "-verbose", "-deprecation", "-classpath", "-sourcepath", "-bootclasspath", "-extdirs", "-d", "-encoding", "-O", "-J-Xmx128M", "-recover"};
        Object[] objectArray = sops;
        int n = sops.length;
        int n2 = 0;
        while (n2 < n) {
            String sop = objectArray[n2];
            if (ops.hasOption(sop)) {
                opList.add(sop);
                if (ops.hasValueForOption(sop)) {
                    opList.add(ops.getValueForOption(sop));
                }
            }
            ++n2;
        }
        opList.add("-nowarn");
        objectArray = ops.files().toArray();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            opList.add(f.toString());
            ++n2;
        }
        return opList.toArray(new String[opList.size()]);
    }
}

