/*
 * Decompiled with CFR 0.152.
 */
package jpe;

import AST.Literal;
import AST.MethodDecl;
import AST.ParameterDeclaration;
import java.util.ArrayList;
import java.util.List;
import jpe.Parameter;

public class Method {
    private MethodDecl decl;
    private List<Parameter> literalParams = new ArrayList<Parameter>();
    private String genMethodName;

    public void addParam(int i, Literal arg) {
        this.literalParams.add(new Parameter(i, arg));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.decl == null ? 0 : this.decl.hashCode());
        result = 31 * result + (this.genMethodName == null ? 0 : this.genMethodName.hashCode());
        result = 31 * result + (this.literalParams == null ? 0 : this.literalParams.hashCode());
        return result;
    }

    public Method(MethodDecl decl, List<Parameter> staticParams) {
        this.decl = decl;
        this.literalParams = staticParams;
    }

    private boolean equalsObjectLiteralParams(List<Parameter> l1, List<Parameter> l2) {
        if (l1.size() == l2.size()) {
            int i = 0;
            while (i < l1.size()) {
                if (!l1.get(i).equals(l2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean equalsMethodDecl(MethodDecl m1, MethodDecl m2) {
        if (!m1.name().equals(m2.name())) {
            return false;
        }
        if (m1.type().name().equals(m2.type().name()) && m1.type().packageName().equals(m2.type().packageName()) && m1.getParameters().getNumChild() == m2.getParameters().getNumChild()) {
            int i = 0;
            while (i < m1.getParameterList().getNumChild()) {
                ParameterDeclaration p1 = (ParameterDeclaration)m1.getParameters().getChild(i);
                ParameterDeclaration p2 = (ParameterDeclaration)m2.getParameters().getChild(i);
                if (!p1.type().name().equals(p2.type().name()) || !p1.type().packageName().equals(p2.type().packageName())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Method)) {
            return false;
        }
        Method other = (Method)obj;
        if (this.decl == null ? other.decl != null : !this.equalsMethodDecl(this.decl, other.decl)) {
            return false;
        }
        return !(this.literalParams == null ? other.literalParams != null : !this.equalsObjectLiteralParams(this.literalParams, other.literalParams));
    }

    public String getGenMethodName() {
        return this.genMethodName;
    }

    public Method setGenMethodName(String genMethodName) {
        this.genMethodName = genMethodName;
        return this;
    }
}

