/*
 * Decompiled with CFR 0.152.
 */
package jpe;

import AST.AbstractObject;
import AST.Expr;
import AST.Literal;
import AST.NullLiteral;
import AST.ObjectLiteral;
import AST.PartialObject;
import AST.Variable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import jpe.Frame;

public class PEStack
implements Iterable<Map.Entry<Variable, Expr>> {
    public AbstractObject thisObject;
    public Expr returnValue = new NullLiteral("null");
    private Frame currentFrame;

    public PEStack(AbstractObject thiz) {
        this(new Frame(), thiz);
    }

    public PEStack(Frame currentFrame, AbstractObject thiz) {
        this.currentFrame = currentFrame;
        this.thisObject = thiz;
    }

    public Expr lookup(Variable n) {
        Expr e = this.currentFrame.lookup(n);
        if (e == null && this.thisObject != null) {
            e = this.thisObject.getFieldValue(n);
        }
        return e;
    }

    public boolean contains(Variable n) {
        boolean c = this.currentFrame.contains(n);
        if (!c && this.thisObject != null) {
            c = this.thisObject.hasField(n);
        }
        return c;
    }

    public void add(Variable n, Expr v) {
        this.currentFrame.add(n, v);
    }

    public Expr lookupVarByName(String s) {
        Expr v = this.currentFrame.lookupVarByName(s);
        if (v == null && this.thisObject != null) {
            if (s.equals("this")) {
                return this.thisObject instanceof ObjectLiteral ? (ObjectLiteral)this.thisObject : (PartialObject)this.thisObject;
            }
            v = this.thisObject.getFieldValue(s);
        }
        return v;
    }

    public void remove(Variable n) {
        throw new Error("should not be in remove");
    }

    public Frame findOwnerFrame(Variable n) {
        return this.currentFrame.findOwnerFrame(n);
    }

    public void inFrame() {
        Frame newFrame;
        this.currentFrame = newFrame = new Frame(this.currentFrame);
    }

    public void outFrame() {
        this.currentFrame = this.currentFrame.getParentFrame();
    }

    public PEStack clone() {
        try {
            return new PEStack(this.currentFrame.clone(), this.thisObject == null ? null : this.thisObject.clone());
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeAltered(PEStack s) {
        Iterator<Map.Entry<Variable, Expr>> i = this.iterator();
        ArrayList<Variable> toRemove = new ArrayList<Variable>();
        while (i.hasNext()) {
            Map.Entry<Variable, Expr> n = i.next();
            if (n.getValue() instanceof Literal) {
                if (s.contains(n.getKey())) {
                    Literal l1 = (Literal)s.lookup(n.getKey());
                    if (l1.literalValueObject().equals(((Literal)n.getValue()).literalValueObject())) continue;
                    toRemove.add(n.getKey());
                    continue;
                }
                toRemove.add(n.getKey());
                continue;
            }
            toRemove.add(n.getKey());
        }
        for (Variable k : toRemove) {
            this.remove(k);
        }
    }

    @Override
    public Iterator<Map.Entry<Variable, Expr>> iterator() {
        return this.currentFrame.iterator();
    }

    public String toString() {
        return "[" + this.currentFrame.toString() + "]";
    }
}

